<?php

namespace Noorgfx;

class SingleProductAdditionalActions {
	public function __construct() {
		add_filter(
			'noorgfx_woo_single_options_layers:extra',
			[$this, 'add_layer_options']
		);

		add_action(
			'noorgfx:woocommerce:product:custom:layer',
			[$this, 'render']
		);
	}

	public function get_actions() {
		return apply_filters(
			'noorgfx:woocommerce:single-product:additional-actions',
			[]
		);
	}

	public function add_layer_options($opt) {
		if (empty($this->get_actions())) {
			return $opt;
		}

		$actions_options = [];
		$actions_values = [];

		foreach ($this->get_actions() as $action) {
			$actions_options[$action['id']] = [
				'label' => $action['label']
			];

			if (isset($action['options'])) {
				$actions_options[$action['id']]['options'] = $action['options'];
			}

			$actions_values[] = [
				'id' => $action['id'],
				'enabled' => true,
			];
		}

		$opt['product_actions'] = [
			'label' => __('Additional Actions', 'noorgfx'),
			'options' => [
				[
					'actions_type' => [
						'label' => __('Buttons Type', 'noorgfx'),
						'type' => 'ct-radio',
						'value' => 'link',
						'view' => 'text',
						'design' => 'block',
						'choices' => [
							'link' => __('Link', 'noorgfx'),
							'button' => __('Button', 'noorgfx'),
						],
						'sync' => [
							'id' => 'woo_card_layout_skip'
						]
					],
				],

				[
					'woo_actions_layout' => [
						'label' => false,
						'type' => 'ct-layers',
						'manageable' => false,
						'itemClass' => 'ct-inner-layer',
						'sync' => [
							noorgfx_sync_whole_page([
								'prefix' => 'woo_categories',
								'loader_selector' => '[data-products] > li'
							])
						],
						'value' => $actions_values,
						'settings' => $actions_options
					]
				],

				'label_visibility' => [
					'label' => __('Label Visibility', 'noorgfx'),
					'type' => 'ct-visibility',
					'design' => 'block',
					'allow_empty' => true,
					'setting' => ['transport' => 'postMessage'],
					'sync' => [
						'id' => 'woo_card_layout_skip'
					],
					'value' => noorgfx_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => false,
					]),
					'choices' => noorgfx_ordered_keys([
						'desktop' => __('Desktop', 'noorgfx'),
						'tablet' => __('Tablet', 'noorgfx'),
						'mobile' => __('Mobile', 'noorgfx'),
					]),
				],

				'spacing' => [
					'label' => __('Bottom Spacing', 'noorgfx'),
					'type' => 'ct-slider',
					'min' => 0,
					'max' => 100,
					'value' => 35,
					'responsive' => true,
					'sync' => [
						'id' => 'woo_card_layout_skip'
					]
				],
			]
		];

		return $opt;
	}

	public function render($layer) {
		if ($layer['id'] !== 'product_actions') {
			return;
		}

		$content = '';

		$actions_values = [];

		foreach ($this->get_actions() as $action) {
			$actions_values[] = [
				'id' => $action['id'],
				'enabled' => true,
			];
		}

		$label_visibility = noorgfx_akg('label_visibility', $layer, [
			'desktop' => true,
			'tablet' => true,
			'mobile' => false,
		]);
		$layout = noorgfx_akg('woo_actions_layout', $layer, $actions_values);

		if (empty($layout)) {
			return;
		}

		foreach($layout as $action) {
			if (! $action['enabled']) {
				continue;
			}

			$content = apply_filters(
				'noorgfx:woocommerce:single-product:additional-actions:content:' . $action['id'],
				$content,
				array_merge(
					$action,
					[
						'label_visibility' => $label_visibility
					]
				)
			);
		}

		if (empty($content)) {
			return;
		}

		echo noorgfx_html_tag(
			'div',
			[
				'class' => 'ct-product-additional-actions',
				'data-type' => noorgfx_akg('actions_type', $layer, 'link')
			],
			$content
		);
	}
}

