<?php

if (! function_exists('noorgfx_get_woo_out_of_stock_badge')) {
	function noorgfx_get_woo_out_of_stock_badge($args = []) {
		$args = wp_parse_args(
			$args,
			[
				// archive | single
				'location' => 'archive'
			]
		);

		$has_stock_badge = noorgfx_get_theme_mod('has_stock_badge', [
			'archive' => true,
			'single' => true,
		]);

		if (
			$args['location'] === 'archive' && ! $has_stock_badge['archive']
			||
			$args['location'] === 'single' && ! $has_stock_badge['single']
		) {
			return '';
		}

		return noorgfx_html_tag(
			'span',
			[
				'class' => 'out-of-stock-badge',
				'data-shape' => noorgfx_get_theme_mod('sale_badge_shape', 'type-2')
			],
			noorgfx_get_theme_mod(
				'stock_badge_value',
				__('SOLD OUT', 'noorgfx')
			)
		);
	}
}
