<?php

namespace Noorgfx;

class Sidebar {
	public function render() {
		if (noorgfx_sidebar_position() === 'none') {
			return '';
		}

		$sticky_output = [];

		$type = noorgfx_get_theme_mod('sidebar_type', 'type-1');

		if (noorgfx_get_theme_mod('has_sticky_sidebar', 'no') === 'yes') {
			$sidebar_stick_behavior = noorgfx_get_theme_mod(
				'sidebar_stick_behavior',
				'sidebar'
			);

			if ($sidebar_stick_behavior === 'sidebar') {
				$sticky_output['data-sticky'] = 'sidebar';
			} else {
				$sticky_output['data-sticky'] = 'widgets';
			}
		}

		$widgets_separated_output = [];

		if (
			$type === 'type-2'
			&&
			noorgfx_get_theme_mod('separated_widgets', 'no') === 'yes'
		) {
			$widgets_separated_output['data-widgets'] = 'separated';
		}

		$class_output = '';

		$sidebar_classes = noorgfx_visibility_classes(noorgfx_get_theme_mod('sidebar_visibility', [
			'desktop' => true,
			'tablet' => false,
			'mobile' => false,
		]));

		if (! empty(trim($sidebar_classes))) {
			$class_output = $sidebar_classes;
		}

		$prefix = noorgfx_manager()->screen->get_prefix();

		$deep_link_args = [
			'return' => 'array'
		];

		if (! is_singular()) {
			$deep_link_args['suffix'] = $prefix . '_has_sidebar';
		}

		$outputs = [
			'before' => $this->make_action('noorgfx:sidebar:before'),

			'start' => $this->make_action('noorgfx:sidebar:start'),

			'widgets' => $this->get_widgets(),

			'end' => $this->make_action('noorgfx:sidebar:end'),

			'after' => $this->make_action('noorgfx:sidebar:after'),
		];

		$main_content = $outputs['start'] . $outputs['widgets'] . $outputs['end'];

		if (! empty($main_content)) {
			$main_content = noorgfx_html_tag(
				'div',
				array_merge(
					[
						'class' => 'ct-sidebar',
					],
					$sticky_output,
					$widgets_separated_output
				),
				$main_content
			);
		}

		$aside_content = $outputs['before'] . $main_content . $outputs['after'];

		if (empty($aside_content)) {
			return '<aside></aside>';
		}

		return noorgfx_html_tag(
			'aside',
			array_merge(
				[
					'class' => $class_output,
					'data-type' => $type,
					'id' => 'sidebar',
				],
				noorgfx_generic_get_deep_link($deep_link_args),
				noorgfx_schema_org_definitions('sidebar', [
					'array' => true,
				])
			),
			$aside_content
		);
	}

	private function make_action($action) {
		ob_start();
		do_action($action);
		return trim(ob_get_clean());
	}

	private function get_widgets() {
		$sidebar_to_render = $this->get_sidebar_to_render();

		if (! is_active_sidebar($sidebar_to_render)) {
			return '';
		}

		ob_start();

		$has_last_n_widgets = false;

		if (noorgfx_get_theme_mod('has_sticky_sidebar', 'no') === 'yes') {
			$sidebar_stick_behavior = noorgfx_get_theme_mod(
				'sidebar_stick_behavior',
				'sidebar'
			);

			if ($sidebar_stick_behavior === 'last_n_widgets') {
				$sidebars_widgets = wp_get_sidebars_widgets();
				$has_last_n_widgets = true;
			}
		}

		if ($has_last_n_widgets) {
			add_action('dynamic_sidebar', [
				$this,
				'render_dynamic_sidebar_hook'
			]);
		}

		dynamic_sidebar($sidebar_to_render);

		if ($has_last_n_widgets) {
			echo '</div>';

			remove_action('dynamic_sidebar', [
				$this,
				'render_dynamic_sidebar_hook'
			]);
		}

		return trim(ob_get_clean());
	}

	public function render_dynamic_sidebar_hook($widget) {
		$sidebars_widgets = wp_get_sidebars_widgets();
		$widget_id = $widget['id'];

		$reversed_widgets = array_reverse(
			$sidebars_widgets[$this->get_sidebar_to_render()]
		);

		$widget_index = array_search($widget_id, $reversed_widgets);

		$sticky_widget_number = min(
			intval(noorgfx_get_theme_mod(
				'sticky_widget_number',
				1
			)),
			count($reversed_widgets)
		);

		if ($widget_index + 1 === $sticky_widget_number) {
			echo '<div class="ct-sticky-widgets">';
		}
	}

	private function get_sidebar_to_render() {
		if (class_exists('NoorgfxSidebarsManager')) {
			$manager = new \NoorgfxSidebarsManager();

			$maybe_sidebar = $manager->maybe_get_sidebar_that_matches();

			if ($maybe_sidebar) {
				return $maybe_sidebar;
			}
		}

		$prefix = noorgfx_manager()->screen->get_prefix();

		if ($prefix === 'product' || $prefix === 'woo_categories') {
			return 'sidebar-woocommerce';
		}

		if (
			is_search()
			&&
			isset($_GET['post_type'])
			&&
			$_GET['post_type'] === 'product'
		) {
			return 'sidebar-woocommerce';
		}

		return 'sidebar-1';
	}
}

