<?php

namespace Noorgfx;

class LegacyWidgetsNewsletterSubscribeTransformer {
	private $data = [];

	public function __construct($data) {
		$this->data = $data;
	}

	public function get_block() {
		$options = noorgfx_akg('ct_options', $this->data, []);

		$options = array_merge(
			[
				'title' => __('Newsletter', 'noorgfx'),
				'newsletter_subscribe_text' => __(
					'Enter your email address below to subscribe to our newsletter',
					'noorgfx'
				),
				'newsletter_subscribe_view_type' => 'stacked'
			],
			$options
		);

		$innerContent = [
			'<h3 class="widget-title">',
			$options['title'],
			'</h3>'
		];

		$blocks = [
			[
				'blockName' => 'noorgfx/widgets-wrapper',
				'attrs' => [
					'heading' => 'Newsletter',
					'block' => 'noorgfx/newsletter',
					'hasDescription' => true,
					"description" => "Enter your email address below to subscribe to our newsletter"
				],
				'innerBlocks' => [
					[
						'blockName' => 'core/heading',
						'attrs' => [
							'level' => 3,
							'fontSize' => 'medium',
							'className' => 'widget-title',
						],
						'innerBlocks' => [],
						'innerHTML' => join('', $innerContent),
						'innerContent' => $innerContent
					],

					[
						'blockName' => 'core/paragraph',
						'attrs' => [
							'placeholder' => 'Description'
						],
						'innerBlocks' => [],
						'innerHTML' => $options['newsletter_subscribe_text'],
						'innerContent' => [
							$options['newsletter_subscribe_text'],
						]
					],

					[
						'blockName' => 'noorgfx/newsletter',
						'attrs' => array_merge(
							[
								'lock' => [
									'remove' => true
								]
							],
							$options
						),
						'innerBlocks' => [],
						'innerHTML' => '<div>Noorgfx: Newsletter</div>',
						'innerContent' => [
							'<div>Noorgfx: Newsletter</div>'
						]
					]
				],
				'innerHTML' => '',
				'innerContent' => [null, null, null]
			]
		];

		return serialize_blocks($blocks);
	}
}


