<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Noorgfx
 */

?><!doctype html>
<html <?php language_attributes(); ?><?php echo noorgfx_html_attr() ?>>
<head>
	<?php do_action('noorgfx:head:start') ?>

	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=5, viewport-fit=cover">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
	<?php do_action('noorgfx:head:end') ?>
</head>

<?php
	ob_start();
	noorgfx_output_header();
	$global_header = ob_get_clean();
?>

<body <?php body_class(); ?> <?php echo noorgfx_body_attr() ?>>

<?php
	if (function_exists('wp_body_open')) {
		wp_body_open();
	}
?>

<div id="main-container">
	<?php
		do_action('noorgfx:header:before');

		echo $global_header;

		do_action('noorgfx:header:after');
		do_action('noorgfx:content:before');
	?>

	<main <?php echo noorgfx_main_attr() ?>>

		<?php
			do_action('noorgfx:content:top');
			noorgfx_before_current_template();
		?>
