<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Noorgfx
 */

if ( post_password_required() ) {
	return;
}

$entity_singular = 'comment';
$entity_plural = 'comments';

$commenter = wp_get_current_commenter();

$prefix = noorgfx_manager()->screen->get_prefix();

$comments_position = noorgfx_get_theme_mod($prefix . '_comments_position', 'below');

do_action('noorgfx:comments:before');

$html_atts = [
	'class' => 'ct-comments',
	'id' => 'comments'
];

if (noorgfx_get_theme_mod(
	$prefix . '_comments_containment',
	'separated'
) === 'contained'
) {
	$html_atts['class'] .= ' is-width-constrained';
}

$deep_link_args = [
	'prefix' => $prefix,
	'suffix' => $prefix . '_has_comments',
	'return' => 'array',
];

$html_atts = array_merge(
	$html_atts,
	noorgfx_generic_get_deep_link(
		$deep_link_args
	)
);

?>


<div <?php echo noorgfx_attr_to_html($html_atts); ?>>
	<?php do_action('noorgfx:comments:top'); ?>

	<?php if ( have_comments() ) : 
		$label_tag = noorgfx_get_theme_mod($prefix . '_comments_heading_tag', 'h3');
		?>
		<<?php echo esc_html($label_tag); ?> class="ct-comments-title">
			<?php comments_number( esc_html__( 'No comments yet', 'noorgfx' ), __( 'One comment', 'noorgfx' ), __( '% Comments', 'noorgfx' ) ); ?>
		</<?php echo esc_html($label_tag); ?>>
	<?php endif; // have_comments() ?>

	<?php if ( $comments_position === 'above' ) comment_form(); ?>

	<?php if ( have_comments() ) : ?>
		<ol class="ct-comment-list">
			<?php
				wp_list_comments(
					[
						'short_ping'  => true,
						'avatar_size' => 100,
						'callback' => 'noorgfx_custom_comment_template',
						'end-callback' => function () {
							echo '</li>';
						}
					]
				);
			?>
		</ol>

		<?php
		// Are there comments to navigate through?
		if (get_comment_pages_count() > 1 && get_option('page_comments')) :
			?>
			<nav class="ct-comment-navigation-container">
				<h4 class="screen-reader-text section-heading">
				<?php esc_html_e( 'Comment navigation', 'noorgfx' ); ?>
				</h4>

				<div class="ct-comments-navigation">
					<span class="prev">
					<?php previous_comments_link( __( '&larr; Older Comments', 'noorgfx' ) ); ?>
					</span>

					<span class="next">
					<?php next_comments_link( __( 'Newer Comments &rarr;', 'noorgfx' ) ); ?>
					</span>
				</div>
			</nav>
		<?php endif; // Check for comment navigation ?>

		<?php if (! comments_open() && get_comments_number()) : ?>
			<p class="no-comments">
				<?php esc_html_e( 'Comments are closed.', 'noorgfx' ); ?>
			</p>
		<?php endif; ?>

	<?php endif; // have_comments() ?>

	<?php if ( $comments_position === 'below' ) comment_form(); ?>

	<?php do_action('noorgfx:comments:bottom'); ?>

</div>

<?php do_action('noorgfx:comments:after'); ?>
