<?php

add_action('admin_notices', function () {
	noorgfx_output_component_notice();
});

function noorgfx_output_component_notice() {
	if (! apply_filters(
		'noorgfx:admin:display-component-plugin-notice',
		true
	)) {
		return;
	}

	if (! current_user_can('activate_plugins') ) return;
	if (get_option('dismissed-noorgfx_plugin_notice', false)) return;

	$manager = new Noorgfx_Plugin_Manager();
	$status = $manager->get_component_status()['status'];

	if ($status === 'active') return;

	$url = admin_url('themes.php?page=ct-dashboard');
	$plugin_url = admin_url('admin.php?page=ct-dashboard');
	$plugin_link = '#';

	echo '<div class="notice notice-noorgfx-plugin">';
	echo '<div class="notice-noorgfx-plugin-root" data-url="' . esc_attr($url) . '" data-plugin-url="' . esc_attr($plugin_url) . '" data-plugin-status="' . esc_attr($status) . '" data-link="' . esc_attr($plugin_link) . '">';

	?>

	<div class="ct-noorgfx-plugin-inner">
		<div class="ct-notification-content">
			<div style="padding-bottom:10px;color:green;font-size:15px; font-weight:bold;"><?php esc_html_e( 'قالب با موفقیت نصب و فعال شد!', 'noorgfx' ); ?></div>
			<div>
				<?php esc_html_e( 'لطفا توجه داشته باشید که این محصول بدون افزونه هسته قالب عملکرد مناسبی نخواهد داشت و لازم است حتما افزونه را از درون پکیج کامل قالب نصب کنید.', 'noorgfx' ); ?>
			</div>
			<div style="padding-top:10px;color:red;font-size:15px; font-weight:bold;">
				<?php esc_html_e( 'افزونه هسته قالب نصب یا فعال نیست! لطفا آخرین نسخه پکیج کامل محصول را دانلود و افزونه را از طریق پوشه پکیج کامل محصول از پوشه plugins نصب کنید', 'noorgfx' ); ?>
			</div>			
		</div>
	</div>
	<?php

	echo '</div>';
	echo '</div>';
}

