<?php

add_action('wp_ajax_noorgfx_dismissed_notice_handler', function () {
	update_option('dismissed-noorgfx_plugin_notice', true);
	wp_die();
});

add_action('wp_ajax_noorgfx_notice_button_click', function () {
	if (
		! current_user_can('activate_plugins')
		||
		! current_user_can('install_plugins')
		||
		! isset($_REQUEST['nonce'])
		||
		! wp_verify_nonce($_REQUEST['nonce'], 'ct-ajax-nonce')
	) {
		wp_send_json_error();
	}

	remove_action(
		'upgrader_process_complete',
		['Language_Pack_Upgrader', 'async_upgrade'],
		20
	);

	$manager = new Noorgfx_Plugin_Manager();
	$status_descriptor = $manager->get_component_status();

	if ($status_descriptor['status'] === 'active') {
		wp_send_json_success([
			'status' => 'active',
			'pluginUrl' => admin_url('admin.php?page=ct-dashboard')
		]);
	}

	if ($status_descriptor['status'] === 'uninstalled') {
		$manager->download_and_install($status_descriptor['slug']);
		$manager->plugin_activation($status_descriptor['slug']);

		wp_send_json_success([
			'status' => 'active',
			'pluginUrl' => admin_url('admin.php?page=ct-dashboard')
		]);
	}

	if ($status_descriptor['status'] === 'installed') {
		$manager->plugin_activation($status_descriptor['slug']);

		wp_send_json_success([
			'status' => 'active',
			'pluginUrl' => admin_url('admin.php?page=ct-dashboard')
		]);
	}

	wp_die();
});

