<?php
/**
 * Admin
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 */

require_once get_template_directory() . '/admin/dashboard/plugins/ct-plugin-manager.php';
require_once get_template_directory() . '/admin/helpers/jed-locale-data.php';

if (is_admin() && defined('DOING_AJAX') && DOING_AJAX) {
	require_once get_template_directory() . '/admin/dashboard/api.php';
	require_once get_template_directory() . '/admin/dashboard/plugins/ct-plugin-manager.php';
	require_once get_template_directory() . '/admin/dashboard/plugins/plugins-api.php';
}

require get_template_directory() . '/admin/dashboard/core.php';
require get_template_directory() . '/admin/blocks-editor.php';

require get_template_directory() . '/admin/notices/templates.php';
if (defined('DOING_AJAX') && DOING_AJAX) {
	require get_template_directory() . '/admin/notices/api.php';
}

add_action(
	'init',
	function () {
		noorgfx_get_jed_locale_data('noorgfx');

		noorgfx_manager()->entity_id_picker->mount_ajax_action();
	}
);

add_action(
	'admin_enqueue_scripts',
	function () {
		$theme = noorgfx_get_wp_parent_theme();

		$current_screen = get_current_screen();

		if (
			$current_screen->id
			&&
			strpos($current_screen->id, 'forminator') !== false
		) {
			return;
		}

		wp_enqueue_media();

		wp_register_script(
			'ct-events',
			get_template_directory_uri() . '/static/bundle/events.js',
			[],
			$theme->get('Version'),
			true
		);

		$deps = apply_filters('noorgfx-options-scripts-dependencies', [
			// 'underscore',
			'react',
			'react-dom',
			'wp-element',
			'wp-date',
			'wp-i18n',
			'ct-events',
			'wp-media-utils',
			// 'wp-polyfill'
		]);

		global $wp_customize;

		if (! isset($wp_customize)) {
			if ($current_screen->base !== 'edit') {
				$deps[] = 'wp-components';
			}

			if (
				$current_screen->base === 'nav-menus'
				||
				$current_screen->base === 'edit-tags'
				||
				$current_screen->base === 'term'
				||
				(
					$current_screen->base === 'post'
					&&
					$current_screen->is_block_editor
				)
				||
				(
					$current_screen->base === 'widgets'
					&&
					$current_screen->is_block_editor
				)
			) {
				$deps[] = 'underscore';
				wp_enqueue_editor();
			}

			wp_enqueue_script(
				'ct-options-scripts',
				get_template_directory_uri() . '/static/bundle/options.js',
				$deps,
				$theme->get('Version')
			);

			$styles_deps = [];

			if (
				$current_screen->base === 'nav-menus'
				||
				(
					$current_screen->base === 'post'
					&&
					$current_screen->is_block_editor
				)
			) {
				$styles_deps[] = 'wp-components';
			}

			wp_enqueue_style(
				'ct-options-styles',
				get_template_directory_uri() . '/static/bundle/options.min.css',
				$styles_deps,
				$theme->get('Version')
			);
		}

		$locale_data_ct = noorgfx_get_jed_locale_data('noorgfx');

		wp_add_inline_script(
			'wp-i18n',
			'wp.i18n.setLocaleData( ' . wp_json_encode($locale_data_ct) . ', "noorgfx" );'
		);


		if (is_rtl()) {
			wp_enqueue_style(
				'ct-options-rtl-styles',
				get_template_directory_uri() . '/static/bundle/options-rtl.min.css',
				['ct-options-styles'],
				$theme->get('Version')
			);
		}

		$gradients = [];

		if (
			get_theme_support('editor-gradient-presets')
			&&
			isset(get_theme_support('editor-gradient-presets')[0])
		) {
			$gradients = get_theme_support('editor-gradient-presets')[0];
		}

		if (function_exists('wp_get_global_settings')) {
			if (isset(wp_get_global_settings()['color']['gradients']['theme'])) {
				$gradients = wp_get_global_settings()['color']['gradients']['theme'];
			}
		}

		$localize_data = [
			'conditions_override' => noorgfx_manager()->get_conditions_overrides(),
			'theme_version' => $theme->get('Version'),
			'current_palette' => noorgfx_manager()->colors->get_color_palette(),
			'gradients' => $gradients,
			'is_dev_mode' => !! (
				defined('NOORGFX_DEVELOPMENT_MODE')
				&&
				NOORGFX_DEVELOPMENT_MODE
			),
			'nonce' => wp_create_nonce('ct-ajax-nonce'),
			'dashboard_actions_nonce' => wp_create_nonce('ct-dashboard'),
			'public_url' => get_template_directory_uri() . '/static/bundle/',
			'static_public_url' => get_template_directory_uri() . '/static/',
			'dismissed_google_fonts_notice' => get_option(
				'dismissed-noorgfx_google_fonts_notice',
				'no'
			) === 'yes',
			'ajax_url' => admin_url('admin-ajax.php'),
			'rest_url' => get_rest_url(),
			'customizer_url' => admin_url('/customize.php?autofocus'),
			'product_name' => noorgfx_get_wp_theme()->get('Name'),
			'customizer_sync' => [
				'svg_patterns' => noorgfx_get_patterns_svgs_list()
			],
			'gutenberg_metaboxes_data' => apply_filters(
				'noorgfx:gutenberg-metaboxes-data',
				[]
			),
			'backend_dynamic_styles_urls' => noorgfx_backend_dynamic_styles_urls(),
			'can_install_plugins' => current_user_can('install_plugins') ? "yes" : "no",
		];

		$block_editor_data = noorgfx_get_block_editor_data();

		if (! empty($block_editor_data)) {
			$localize_data['block_editor_data'] = $block_editor_data;
		}

		wp_localize_script(
			'ct-options-scripts',
			'ct_localizations',
			$localize_data
		);
	},
	50
);

/* -----------Change Admin Fonts and Styles----------- */
if (!function_exists( 'font_changer' )) {
  function font_changer() {
    wp_enqueue_style( 'custom_admin_panel_style', trailingslashit( get_stylesheet_directory_uri() )  . 'assets/fontchanger.css' );
  }
  add_action( 'admin_enqueue_scripts', 'font_changer' );
}
/* -----------Add Custom Fonts To Elementor----------- */
add_filter( 'elementor/fonts/groups', function( $font_groups ) {
	$font_groups['FARSI'] = __( 'فونت فارسی', 1, 1 );
	return $font_groups;
} );
add_filter( 'elementor/fonts/additional_fonts', function( $additional_fonts ) {
	$additional_fonts['Shabnam-Normal'] = 'FARSI';
	$additional_fonts['Vazir-Normal'] = 'FARSI';
	$additional_fonts['DanaFN'] = 'FARSI';
	$additional_fonts['IRsans'] = 'FARSI';
	$additional_fonts['PinarBlack'] = 'FARSI';
	$additional_fonts['Morabba'] = 'FARSI';
	$additional_fonts['Morabba-Black'] = 'FARSI';
	$additional_fonts['Anjoman'] = 'FARSI';	
	$additional_fonts['Aviny'] = 'FARSI';		
	$additional_fonts['Iranyk'] = 'FARSI';		
	$additional_fonts['Iranyk-Light'] = 'FARSI';	
	$additional_fonts['Iranyk-Black'] = 'FARSI';
	$additional_fonts['Estedad-Light'] = 'FARSI';
	$additional_fonts['Estedad-Regular'] = 'FARSI';
	$additional_fonts['Estedad-Medium'] = 'FARSI';
	$additional_fonts['Estedad-Bold'] = 'FARSI';
	$additional_fonts['Estedad-Black'] = 'FARSI';
	
	return $additional_fonts;
} );
/* ----------- Change Elementor Editor Style ----------- */
add_action('elementor/editor/wp_head', function () {
    echo '<style>
        @font-face {
            font-family: "Shabnam-Normal";
            src: url(' . get_template_directory_uri() . '/assets/fonts/Shabnam-Normal.woff2);
            font-weight: normal;
            font-style: normal;
        }
        .elementor-widget {
            font-family: "Shabnam-Normal", Tahoma, sans-serif !important;
        }
	#elementor-panel-inner, .elementor-panel .elementor-element, .elementor-panel #elementor-panel-saver-button-publish.elementor-disabled, .elementor-panel #elementor-panel-saver-button-save-options.elementor-disabled , .elementor-panel #elementor-panel-saver-button-publish, .elementor-panel #elementor-panel-saver-button-save-options, .elementor-panel-elements-search-wrapper, .elementor-control-dynamic input,#elementor-panel-elements-search-input,.ui-draggable,.elementor-panel-heading-title {font-family: Shabnam-Normal !important;font-style: normal;} 
    </style>';
});