import {
	createElement,
	Fragment,
	useEffect,
	useState,
} from '@wordpress/element'
import { __ } from 'ct-i18n'
import { Switch } from 'noorgfx-options'
import ConditionsManager from './ConditionsManager'
import { Overlay } from 'noorgfx-options'

const DisplayCondition = ({
	option: {
		// inline | modal
		display = 'inline',

		filter = 'all',

		modalTitle = __(
			'Transparent Header Display Conditions',
			'noorgfx-component'
		),
		modalDescription = __(
			'Add one or more conditions to display the transparent header.',
			'noorgfx-component'
		),

		addConditionButtonLabel = __(
			'Add Display Condition',
			'noorgfx-component'
		),
	},
	value,
	onChange,
}) => {
	const [isEditing, setIsEditing] = useState(false)
	const [localValue, setLocalValue] = useState(null)

	if (display === 'inline') {
		return (
			<ConditionsManager
				filter={filter}
				value={value}
				onChange={onChange}
				addConditionButtonLabel={addConditionButtonLabel}
			/>
		)
	}

	return (
		<Fragment>
			<button
				className="button-primary"
				style={{ width: '100%' }}
				onClick={(e) => {
					e.preventDefault()
					setIsEditing(true)
					setLocalValue(null)
				}}>
				{Object.keys(value).length > 0
					? __('Edit Conditions', 'noorgfx-component')
					: __('Add Conditions', 'noorgfx-component')}
			</button>

			<Overlay
				items={isEditing}
				className="ct-admin-modal ct-builder-conditions-modal"
				onDismiss={() => {
					setIsEditing(false)
					setLocalValue(null)
				}}
				render={() => (
					<div className="ct-modal-content">
						<h2>{modalTitle}</h2>
						<p>{modalDescription}</p>

						<div className="ct-modal-scroll">
							<ConditionsManager
								filter={filter}
								value={localValue || value}
								onChange={(value) => {
									setLocalValue(value)
								}}
								addConditionButtonLabel={
									addConditionButtonLabel
								}
							/>
						</div>

						<div className="ct-modal-actions has-divider">
							<button
								className="button-primary"
								disabled={!localValue}
								onClick={() => {
									onChange(localValue)
									setIsEditing(false)
								}}>
								{__('Save Conditions', 'noorgfx-component')}
							</button>
						</div>
					</div>
				)}
			/>
		</Fragment>
	)
}

export default DisplayCondition
