import { createElement } from '@wordpress/element'
import { __ } from 'ct-i18n'

import { InspectorControls } from '@wordpress/block-editor'

import { OptionsPanel } from 'noorgfx-options'

import NoorgfxToolsPanel from '../../../components/ToolsPanel'

import { useTaxonomiesLayers } from './layers/useTaxonomiesLayers'

const PostsInspectorControls = ({
	context,
	attributes,
	attributes: { post_type },
	setAttributes,
}) => {
	const { taxonomiesGroup } = useTaxonomiesLayers({
		attributes,
		setAttributes,
		previewedPostMatchesType: attributes.post_type === context.postType,
	})

	return (
		<InspectorControls>
			<NoorgfxToolsPanel
				className="ct-query-parameters-component"
				attributes={attributes}
				setAttributes={setAttributes}
				resetAll={() => {
					setAttributes({
						offset: 0,
						sticky_posts: 'include',
						orderby: 'post_date',
						order: 'desc',

						include_term_ids: {},
						exclude_term_ids: {},
					})
				}}
				items={[
					{
						label: __('General', 'noorgfx-component'),
						items: [
							{
								label: __('Offset', 'noorgfx-component'),

								hasValue: () => {
									return attributes.offset !== 0
								},

								reset: () => {
									setAttributes({
										offset: 0,
									})
								},

								render: () => {
									return (
										<OptionsPanel
											purpose="gutenberg"
											onChange={(
												optionId,
												optionValue
											) => {
												setAttributes({
													[optionId]: optionValue,
												})
											}}
											options={{
												offset: {
													type: 'ct-number',
													label: __(
														'Offset',
														'noorgfx-component'
													),
													value: '',
													min: 0,
													max: 500,
												},
											}}
											value={attributes}
											hasRevertButton={false}
										/>
									)
								},
							},

							{
								label: __('Order by', 'noorgfx-component'),

								hasValue: () => {
									return attributes.orderby !== 'post_date'
								},

								reset: () => {
									setAttributes({
										orderby: 'post_date',
									})
								},

								render: () => {
									return (
										<OptionsPanel
											purpose="gutenberg"
											onChange={(
												optionId,
												optionValue
											) => {
												setAttributes({
													[optionId]: optionValue,
												})
											}}
											options={{
												orderby: {
													type: 'ct-select',
													label: __(
														'Order by',
														'noorgfx-component'
													),
													value: '',
													choices: [
														{
															key: 'title',
															value: __(
																'Title',
																'noorgfx-component'
															),
														},

														{
															key: 'post_date',
															value: __(
																'Publish Date',
																'noorgfx-component'
															),
														},

														{
															key: 'modified',
															value: __(
																'Modified Date',
																'noorgfx-component'
															),
														},

														{
															key: 'comment_count',
															value: __(
																'Most commented',
																'noorgfx-component'
															),
														},

														{
															key: 'author',
															value: __(
																'Author',
																'noorgfx-component'
															),
														},

														{
															key: 'rand',
															value: __(
																'Random',
																'noorgfx-component'
															),
														},

														{
															key: 'menu_order',
															value: __(
																'Menu Order',
																'noorgfx-component'
															),
														},
													],
												},
											}}
											value={attributes}
											hasRevertButton={false}
										/>
									)
								},
							},

							{
								label: __('Order', 'noorgfx-component'),

								hasValue: () => {
									return attributes.order !== 'desc'
								},

								reset: () => {
									setAttributes({
										order: 'desc',
									})
								},

								render: () => {
									return (
										<OptionsPanel
											purpose="gutenberg"
											onChange={(
												optionId,
												optionValue
											) => {
												setAttributes({
													[optionId]: optionValue,
												})
											}}
											options={{
												order: {
													type: 'ct-select',
													label: __(
														'Order',
														'noorgfx-component'
													),
													value: '',
													choices: [
														{
															key: 'DESC',
															value: __(
																'Descending',
																'noorgfx-component'
															),
														},

														{
															key: 'ASC',
															value: __(
																'Ascending',
																'noorgfx-component'
															),
														},
													],
												},
											}}
											value={attributes}
											hasRevertButton={false}
										/>
									)
								},
							},

							{
								label: __('Sticky Posts', 'noorgfx-component'),

								hasValue: () => {
									return attributes.sticky_posts !== 'include'
								},

								reset: () => {
									setAttributes({
										sticky_posts: 'include',
									})
								},

								render: () => {
									return (
										<OptionsPanel
											purpose="gutenberg"
											onChange={(
												optionId,
												optionValue
											) => {
												setAttributes({
													[optionId]: optionValue,
												})
											}}
											options={{
												sticky_posts: {
													type: 'ct-select',
													label: __(
														'Sticky Posts',
														'noorgfx-component'
													),
													value: 'include',
													choices: [
														{
															key: 'include',
															value: __(
																'Include',
																'noorgfx-component'
															),
														},

														{
															key: 'exclude',
															value: __(
																'Exclude',
																'noorgfx-component'
															),
														},

														{
															key: 'only',
															value: __(
																'Only',
																'noorgfx-component'
															),
														},
													],
												},
											}}
											value={attributes}
											hasRevertButton={false}
										/>
									)
								},
							},
						],
					},

					...(taxonomiesGroup ? [taxonomiesGroup] : []),
				]}
				label={__('Parameters', 'noorgfx-component')}
			/>
		</InspectorControls>
	)
}

export default PostsInspectorControls
