import { createElement } from '@wordpress/element'
import { ToolbarDropdownMenu } from '@wordpress/components'
import { __, sprintf } from 'ct-i18n'

import TagNameIcon from './TagNameIcon'

export default function HeadingLevelDropdown({ tagName, onChange }) {
	return (
		<ToolbarDropdownMenu
			popoverProps={{
				className: 'block-library-heading-level-dropdown',
			}}
			icon={<TagNameIcon level={tagName} />}
			label={__('Change heading level', 'noorgfx-component')}
			controls={[
				'h1',
				'h2',
				'h3',
				'h4',
				'h5',
				'h6',
				'p',
				'span',
				'div',
			].map((targetTagName) => {
				{
					const isActive = targetTagName === tagName

					return {
						icon: (
							<TagNameIcon
								level={targetTagName}
								isPressed={isActive}
							/>
						),
						label: targetTagName,
						title: {
							h1: __('Heading 1', 'noorgfx-component'),
							h2: __('Heading 2', 'noorgfx-component'),
							h3: __('Heading 3', 'noorgfx-component'),
							h4: __('Heading 4', 'noorgfx-component'),
							h5: __('Heading 5', 'noorgfx-component'),
							h6: __('Heading 6', 'noorgfx-component'),
							p: __('Paragraph', 'noorgfx-component'),
							span: __('Span', 'noorgfx-component'),
							div: __('Div', 'noorgfx-component'),
						}[targetTagName],
						isActive,
						onClick() {
							onChange(targetTagName)
						},
						role: 'menuitemradio',
					}
				}
			})}
		/>
	)
}
