<?php

/*
Plugin Name: افزونه هسته قالب
Description: توسط این افزونه قابلیت های سفارشی سازی اختصاصی روی قالب فعال خواهد شد.
Version: 1.4.9

Author: راست چین
Author URI: https://www.rtl-theme.com/author/masoud_afkani
Text Domain: noorgfx-component
Domain Path: /languages/
License: GPLv2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html

Requires at least: 6.5
Requires PHP: 7.0
*/



if ( !defined( 'ABSPATH' ) ) {
    exit;
}
register_activation_hook( __FILE__, function () {
    if ( class_exists( '\\Noorgfx\\Plugin' ) && !function_exists( 'blc_fs' ) ) {
        $to_deactivate = plugin_basename( str_replace( '-pro/', '/', __FILE__ ) );
        if ( is_plugin_active( $to_deactivate ) ) {
            deactivate_plugins( $to_deactivate );
        }
    }
    if ( isset( $_REQUEST['action'] ) && 'activate-selected' === $_REQUEST['action'] && isset( $_POST['checked'] ) && count( $_POST['checked'] ) > 1 ) {
        return;
    }
    add_option( 'blc_activation_redirect', wp_get_current_user()->ID );
} );
if ( function_exists( 'blc_fs' ) || class_exists( '\\Noorgfx\\Plugin' ) ) {
    if ( function_exists( 'blc_fs' ) ) {
        blc_fs()->set_basename( true, __FILE__ );
    }
} else {
    if ( !function_exists( 'blc_fs' ) && (is_admin() || wp_doing_cron() || defined( 'WP_CLI' ) && WP_CLI) ) {
        global $blc_fs;
        if ( !isset( $blc_fs ) ) {
            if ( !defined( 'WP_FS__PRODUCT_5115_MULTISITE' ) ) {
                define( 'WP_FS__PRODUCT_5115_MULTISITE', true );
            }
            class NoorgfxFsNull {
                public function _get_license() {
                    return (object) ['id' => ''];
                }
                public function get_site() {
                    return (object) ['id' => ''];
                }

                public function is_plan( $plan ) {
                    return $plan === 'agency_v2';
                }

                public function can_use_premium_code() {
                    return true;
                }
                public function is_activation_mode( $and_on = true ) {
                    return false;
                }
                public function is_anonymous() {
                    return false;
                }
                public function add_filter( $tag, $function_to_add, $priority = 10, $accepted_args = 1 ) {
                    add_filter( $tag, $function_to_add, $priority, $accepted_args );
                }
                public function add_action( $tag, $function_to_add, $priority = 10, $accepted_args = 1 ) {
                    add_action( $tag, $function_to_add, $priority, $accepted_args );
                }
            }
            $blc_fs = new NoorgfxFsNull();
            $noorgfx_active_extensions = get_option( 'noorgfx_active_extensions', [] );
            if ( !is_array( $noorgfx_active_extensions ) ) {
                $noorgfx_active_extensions = [];
            }
            if ( in_array( 'white-label', $noorgfx_active_extensions ) && ($blc_fs->is_plan( 'agency' ) || $blc_fs->is_plan( 'agency_v2' )) ) {
                $settings = apply_filters( 'noorgfx:ext:white-label:settings', get_option( 'noorgfx_ext_white_label_settings', [] ) );
                if ( $settings && isset( $settings['hide_billing_account'] ) && $settings['hide_billing_account'] && !is_multisite() ) {
                    $has_account = false;
                }
            }
            function blc_fs() {
                global $blc_fs;
                return $blc_fs;
            }

            blc_fs();
            do_action( 'blc_fs_loaded' );
        }
    }
    define( 'NOORGFX__FILE__', __FILE__ );
    define( 'NOORGFX_PLUGIN_BASE', plugin_basename( NOORGFX__FILE__ ) );
    define( 'NOORGFX_PATH', plugin_dir_path( NOORGFX__FILE__ ) );
    define( 'NOORGFX_URL', plugin_dir_url( NOORGFX__FILE__ ) );
    if ( !version_compare( PHP_VERSION, '7.0', '>=' ) ) {
        add_action( 'admin_notices', 'blc_fail_php_version' );
    } elseif ( !version_compare( get_bloginfo( 'version' ), '5.0', '>=' ) ) {
        add_action( 'admin_notices', 'blc_fail_wp_version' );
    } else {
        require NOORGFX_PATH . 'plugin.php';
    }
    function blc_fail_php_version() {
        $message = sprintf( esc_html__( 'Noorgfx requires PHP version %s+, plugin is currently NOT RUNNING.', 'noorgfx-component' ), '7.0' );
        $html_message = sprintf( '<div class="error">%s</div>', wpautop( $message ) );
        echo wp_kses_post( $html_message );
    }
    function blc_fail_wp_version() {
        $message = sprintf( esc_html__( 'Noorgfx requires WordPress version %s+. Because you are using an earlier version, the plugin is currently NOT RUNNING.', 'noorgfx-component' ), '5.0' );
        $html_message = sprintf( '<div class="error">%s</div>', wpautop( $message ) );
        echo wp_kses_post( $html_message );
    }

}