<?php
if (!defined('ABSPATH')) { 
    exit; // Exit if accessed directly
}

class WordPress_Elementor_Post_List_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'wordpress_post_list';
    }

    public function get_title() {
        return __('لیست پست ها', 'wordpress-elementor-post-list');
    }

    public function get_icon() {
        return 'eicon-post-list';
    }

    public function get_categories() {
        return ['nour-widgets']; 
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'wordpress-elementor-post-list'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'row_gap',
            [
                'label' => __('فاصله بین ردیف ها', 'elementor-post-list'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 10,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'post_category',
            [
                'label' => __('دسته نوشته ها', 'wordpress-elementor-post-list'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => $this->get_post_categories(),
                'multiple' => true,
            ]
        );

        $this->add_control(
            'post_count',
            [
                'label' => __('تعداد نوشته ها', 'wordpress-elementor-post-list'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 5,
            ]
        );
        
        $this->add_control(
            'excerpt_length',
            [
                'label' => __('تعداد کلمات محتوا', 'wordpress-elementor-post-list'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 20,
            ]
        );

        $this->add_control(
            'image_position',
            [
                'label' => __('موقعیت تصویر', 'wordpress-elementor-post-list'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'right',
                'options' => [
                    'right' => __('راست', 'wordpress-elementor-post-list'),
                    'left' => __('چپ', 'wordpress-elementor-post-list'),
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('تایپوگرافی عنوان', 'wordpress-elementor-post-list'),
                'selector' => '{{WRAPPER}} .post-title',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('تایپوگرافی محتوا', 'wordpress-elementor-post-list'),
                'selector' => '{{WRAPPER}} .post-content',
            ]
        );
$this->add_control(
    'image_resolution',
    [
        'label' => __('رزولوشن تصویر', 'wordpress-elementor-post-list'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'thumbnail',
        'options' => [
            'thumbnail' => __('بندانگشتی', 'wordpress-elementor-post-list'),
            'medium' => __('متوسط', 'wordpress-elementor-post-list'),
            'large' => __('بزرگ', 'wordpress-elementor-post-list'),
            'full' => __('کامل', 'wordpress-elementor-post-list'),
        ],
    ]
);

        $this->add_responsive_control(
            'image_border_radius',
            [
                'label' => __('شعاع مرزی تصویر', 'elementor-post-list'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-image img' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $args = [
            'post_type' => 'post',
            'posts_per_page' => $settings['post_count'] ?? 5,
            'category__in' => $settings['post_category'],
        ];

        $query = new WP_Query($args);

        if ($query->have_posts()) {
            echo '<div class="post-list-widget">';

            while ($query->have_posts()) {
                $query->the_post();
                echo '<div class="post-item" style="display: flex; flex-direction: ' . ($settings['image_position'] == 'left' ? 'row-reverse' : 'row') . ';">';
echo '<div class="post-image">' . get_the_post_thumbnail(    get_the_ID(),     $settings['image_resolution'],     [        'style' => 'width: ' . $settings['image_size']['size'] . $settings['image_size']['unit'] . '; height: auto;'     ]) . '</div>';
                echo '<div class="post-info">';
                echo '<h3 class="post-title">' . get_the_title() . '</h3>';
                echo '<div class="post-content">' . wp_trim_words(get_the_excerpt(), $settings['excerpt_length'], '...') . '</div>';
                echo '</div>';
                echo '</div>';
            }

            echo '</div>';

            // اضافه کردن استایل برای ریسپانسیو
            echo '<style>
                @media (max-width: 768px) {
                    .post-list-widget .post-item {
                        flex-direction: column !important;
                        text-align: center;
                    }
                    .post-list-widget .post-image {
                        margin-bottom: 10px;
                    }
                }
            </style>';
        } else {
            echo __('هیچ نوشته ای یافت نشد', 'wordpress-elementor-post-list');
        }

        wp_reset_postdata();
    }

    private function get_post_categories() {
        $categories = get_terms('category');
        $options = [];

        foreach ($categories as $category) {
            $options[$category->term_id] = $category->name;
        }

        return $options;
    }
}
