<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Image_Hover_Effect_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'image_hover_effect';
    }

    public function get_title() {
        return __('افکت هاور تصویر', 'image-hover-effect');
    }

    public function get_icon() {
        return 'eicon-image-rollover';
    }

    public function get_categories() {
        return ['nour-widgets']; 
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'image-hover-effect'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __('انتخاب تصویر', 'image-hover-effect'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('عنوان', 'image-hover-effect'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('عنوان', 'image-hover-effect'),
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => __('توضیحات', 'image-hover-effect'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('توضیحات', 'image-hover-effect'),
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => __('متن دکمه', 'image-hover-effect'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('بیشتر بدانید', 'image-hover-effect'),
            ]
        );

        $this->add_control(
            'button_url',
            [
                'label' => __('لینک دکمه', 'image-hover-effect'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'image-hover-effect'),
            ]
        );

        $this->add_control(
            'hover_style',
            [
                'label' => __('طرح هاور', 'image-hover-effect'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'style1',
                'options' => [
                    'style1' => __('طرح 1', 'image-hover-effect'),
                    'style2' => __('طرح 2', 'image-hover-effect'),
                    'style3' => __('طرح 3', 'image-hover-effect'),
                    'style4' => __('طرح 4', 'image-hover-effect'),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل', 'image-hover-effect'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
    $this->add_control(
        'border_radius',
        [
            'label' => __('شعاع مرزی جعبه', 'image-hover-effect'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors' => [
                '{{WRAPPER}} .image-hover-effect' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );
    $this->add_control(
        'content_padding',
        [
            'label' => __('فاصله داخلی محتوا', 'image-hover-effect'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors' => [
                '{{WRAPPER}} .image-hover-effect .hover-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );
	    $this->add_control(
        'content_margin',
        [
            'label' => __('فاصله خارجی محتوا', 'image-hover-effect'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors' => [
                '{{WRAPPER}} .image-hover-effect .hover-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );
	    $this->add_control(
        'content_border_radius',
        [
            'label' => __('شعاع مرزی محتوا', 'image-hover-effect'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors' => [
                '{{WRAPPER}} .image-hover-effect .hover-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );
	    $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
            'name' => 'content_border',
            'label' => __('حاشیه محتوا', 'image-hover-effect'),
            'selector' => '{{WRAPPER}} .image-hover-effect .hover-content',
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'name' => 'title_typography',
            'label' => __('تایپوگرافی عنوان', 'image-hover-effect'),
            'selector' => '{{WRAPPER}} .image-hover-effect .hover-content h3',
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'name' => 'description_typography',
            'label' => __('تایپوگرافی توضیحات', 'image-hover-effect'),
            'selector' => '{{WRAPPER}} .image-hover-effect .hover-content p',
        ]
    );
    $this->add_control(
        'button_style_heading',
        [
            'label' => __('استایل دکمه', 'image-hover-effect'),
            'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'name' => 'button_typography',
            'label' => __('تایپوگرافی دکمه', 'image-hover-effect'),
            'selector' => '{{WRAPPER}} .image-hover-effect .hover-button',
        ]
    );
    $this->add_control(
        'button_padding',
        [
            'label' => __('فاصله داخلی دکمه', 'image-hover-effect'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors' => [
                '{{WRAPPER}} .image-hover-effect .hover-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );
    $this->add_control(
        'button_border_radius',
        [
            'label' => __('شعاع مرزی دکمه', 'image-hover-effect'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors' => [
                '{{WRAPPER}} .image-hover-effect .hover-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );
    $this->add_control(
        'button_text_color',
        [
            'label' => __('رنگ متن دکمه', 'image-hover-effect'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .image-hover-effect .hover-button' => 'color: {{VALUE}};',
            ],
        ]
    );

    $this->add_control(
        'button_background_color',
        [
            'label' => __('رنگ پس‌زمینه دکمه', 'image-hover-effect'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .image-hover-effect .hover-button' => 'background-color: {{VALUE}};',
            ],
        ]
    );
	
        $this->add_control(
            'overlay_color',
            [
                'label' => __('رنگ پوشش', 'image-hover-effect'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .image-hover-effect .hover-content' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

protected function render() {
    $settings = $this->get_settings_for_display();
    ?>
    <div class="image-hover-effect <?php echo esc_attr($settings['hover_style']); ?>">
        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
        <div class="hover-overlay"></div>
        <div class="hover-content">
            <h3><?php echo esc_html($settings['title']); ?></h3>
            <p><?php echo esc_html($settings['description']); ?></p>
            <a href="<?php echo esc_url($settings['button_url']['url']); ?>" class="hover-button"><?php echo esc_html($settings['button_text']); ?></a>
        </div>
    </div>
    <?php
}

protected function _content_template() {
    ?>
    <#
    var image = settings.image.url ? settings.image.url : '<?php echo \Elementor\Utils::get_placeholder_image_src(); ?>';
    #>
    <div class="image-hover-effect {{{ settings.hover_style }}}">
        <img src="{{{ image }}}" alt="{{{ settings.title }}}">
        <div class="hover-overlay"></div>
        <div class="hover-content">
            <h3>{{{ settings.title }}}</h3>
            <p>{{{ settings.description }}}</p>
            <a href="{{{ settings.button_url.url }}}" class="hover-button">{{{ settings.button_text }}}</a>
        </div>
    </div>
    <?php
}
}