import { __, sprintf } from 'ct-i18n'

export const mountStackableFontsIntegration = ({ getFontsData }) => {
	wp.hooks.addFilter(
		'stackable.font-family-control.options',
		'noorgfx',
		(options) => {
			const fontsData = getFontsData()

			if (!fontsData) {
				return options
			}

			let product_name = (
				window.ct_localizations || window.ct_customizer_localizations
			).product_name

			Object.values(fontsData)
				.filter(({ type }) => type !== 'system' && type !== 'google')
				.map(({ type, families }) => {
					let titles = {
						'local-google-fonts': sprintf(
							__('%s Local Google Fonts', 'noorgfx-component'),
							product_name
						),
						typekit: sprintf(
							__('%s Typekit', 'noorgfx-component'),
							product_name
						),
						file: sprintf(
							__('%s Custom Fonts', 'noorgfx-component'),
							product_name
						),
					}

					if (
						!options.some(
							(option) => option.id === `noorgfx-${type}`
						)
					) {
						options.unshift({
							id: `noorgfx-${type}`,
							title: titles[type],
							options: families.map(({ display, family }) => ({
								label: display,
								value: family.replace('ct_typekit_', ''),
							})),
						})
					}
				})

			if (!fontsData.google) {
				options = options.filter(({ id }) => id !== 'google-fonts')
			}

			return options
		}
	)
}
