import { onDocumentLoaded } from 'noorgfx-frontend'
import ctEvents from 'ct-events'

const mount = () => {
	;[...document.querySelectorAll('.noorgfx-hook-indicator > span')].map(
		(el) => {
			if (el.hasClickListener) {
				return
			}

			el.hasClickListener = true

			el.addEventListener('click', (e) => {
				e.preventDefault()

				const name = `Hook ${el.dataset.hook.split('::')[0]}`

				fetch(
					`${ct_localizations.ajax_url}?action=noorgfx_content_noorgfx_create&name=${name}&type=hook&predefined_hook=${el.dataset.hook}`
				)
					.then((r) => r.json())
					.then(({ data: { url } }) => {
						window.location = url
					})
			})
		}
	)
}

onDocumentLoaded(() => {
	mount()
})

ctEvents.on('noorgfx:frontend:init', mount)
