<?php

$cpt_choices = [
	'post' => __('Posts', 'noorgfx-component'),
	'page' => __('Pages', 'noorgfx-component')
];

$cpt_options = [
	'post' => true,
	'page' => true
];

if (class_exists('WooCommerce')) {
	$cpt_choices['product'] = __('Products', 'noorgfx-component');
	$cpt_options['product'] = true;
}

$all_cpts = [];

if (blc_theme_functions()->noorgfx_manager()) {
	$all_cpts = blc_theme_functions()->noorgfx_manager()->post_types->get_supported_post_types();
}

if (function_exists('is_bbpress')) {
	$all_cpts[] = 'forum';
	$all_cpts[] = 'topic';
	$all_cpts[] = 'reply';
}

if (class_exists('Tribe__Events__Main')) {
	$all_cpts[] = 'tribe_events';
}

foreach ($all_cpts as $single_cpt) {
	if (get_post_type_object($single_cpt)) {
		$cpt_choices[$single_cpt] = get_post_type_labels(
			get_post_type_object($single_cpt)
		)->singular_name;
	} else {
		$cpt_choices[$single_cpt] = ucfirst($single_cpt);
	}

	$cpt_options[$single_cpt] = false;
}

foreach ($cpt_choices as $cpt => $value) {
	$post_type_object = get_post_type_object($cpt);

	if ($post_type_object && isset($post_type_object->show_in_rest) && $post_type_object->show_in_rest) {
		continue;
	}

	unset($cpt_choices[$cpt]);
	unset($cpt_options[$cpt]);
}

$options = [
	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx-component' ),
		'type' => 'tab',
		'options' => array_merge([

			'search_box_placeholder' => [
				'label' => __( 'Placeholder Text', 'noorgfx-component' ),
				'type' => 'text',
				'design' => 'block',
				'value' => __( 'Search', 'noorgfx-component' ),
				'setting' => [
					'transport' => 'postMessage'
				],
			],

			'searchBoxMaxWidth' => [
				'label' => __( 'Input Maximum Width', 'noorgfx-component' ),
				'type' => 'ct-slider',
				'min' => 10,
				'max' => 100,
				'value' => 25,
				'responsive' => true,
				'divider' => 'top',
				'defaultUnit' => '%',
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'headerSearchBoxHeight' => [
				'label' => __( 'Input Height', 'noorgfx-component' ),
				'type' => 'ct-slider',
				'min' => 20,
				'max' => 80,
				'value' => 40,
				'responsive' => true,
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'icon' => [
				'type' => 'icon-picker',
				'label' => __('Icon', 'noorgfx-component'),
				'design' => 'inline',
				'divider' => 'top',
				'value' => [
					'icon' => 'blc blc-search'
				]
			],

			'enable_live_results' => [
				'label' => __( 'Live Results', 'noorgfx-component' ),
				'type' => 'ct-switch',
				'value' => 'no',
				'divider' => 'top:full',
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'enable_live_results' => 'yes' ],
				'options' => [

					'live_results_images' => [
						'label' => __( 'Live Results Images', 'noorgfx-component' ),
						'type' => 'ct-switch',
						'value' => 'yes',
						'divider' => 'top',
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'search_through/product' => true ],
						'options' => [
							'searchHeaderProductPrice' => [
								'label' => __( 'Live Results Product Price', 'noorgfx-component' ),
								'type' => 'ct-switch',
								'value' => 'no',
								'divider' => 'top',
								'setting' => [ 'transport' => 'postMessage' ],
							],

							'searchHeaderProductStatus' => [
								'label' => __( 'Live Results Product Status', 'noorgfx-component' ),
								'type' => 'ct-switch',
								'value' => 'no',
								'divider' => 'top',
								'setting' => [ 'transport' => 'postMessage' ],
							],
						]
					],

				],
			],

			'has_taxonomy_filter' => [
				'label' => __( 'Taxonomy Filter', 'noorgfx-component' ),
				'type' => 'ct-switch',
				'value' => 'no',
				'divider' => 'top:full',
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'has_taxonomy_filter' => 'yes' ],
				'options' => [

					'taxonomy_filter_visibility' => [
						'label' => __( 'Filter Visibility', 'noorgfx-component' ),
						'type' => 'ct-visibility',
						'design' => 'block',
						// 'allow_empty' => true,
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => noorgfx_default_responsive_value([
							'desktop' => true,
							'tablet' => true,
							'mobile' => false,
						]),

						'choices' => noorgfx_ordered_keys([
							'desktop' => __( 'Desktop', 'noorgfx-component' ),
							'tablet' => __( 'Tablet', 'noorgfx-component' ),
							'mobile' => __( 'Mobile', 'noorgfx-component' ),
						]),
					],

					'has_taxonomy_children' => [
						'label' => __( 'Taxonomy Children', 'noorgfx-component' ),
						'type' => 'ct-switch',
						'value' => 'no',
						'divider' => 'top',
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-title',
				'label' => __('Search Through Criteria', 'noorgfx-component'),
				'desc' => __(
					'Chose in which post types do you want to perform searches.',
					'noorgfx-component'
				)
			],

			'search_through' => [
				'label' => false,
				'type' => 'ct-checkboxes',
				'attr' => ['data-columns' => '2'],
				'disableRevertButton' => true,
				'choices' => noorgfx_ordered_keys($cpt_choices),
				'value' => $cpt_options
			],

			'search_through_taxonomy' => [
				'label' => __('Search Through Taxonomies', 'noorgfx-component'),
				'type' => 'ct-switch',
				'value' => 'no',
				'divider' => 'top',
				'desc' => __('Search through taxonomies from selected custom post types.', 'noorgfx-component'),
			],

		], $panel_type === 'footer' ? [

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'footer_search_box_horizontal_alignment' => [
				'type' => 'ct-radio',
				'label' => __( 'Horizontal Alignment', 'noorgfx-component' ),
				'view' => 'text',
				'design' => 'block',
				'responsive' => true,
				'attr' => [ 'data-type' => 'alignment' ],
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => 'CT_CSS_SKIP_RULE',
				'choices' => [
					'flex-start' => '',
					'center' => '',
					'flex-end' => '',
				],
			],

			'footer_search_box_vertical_alignment' => [
				'type' => 'ct-radio',
				'label' => __( 'Vertical Alignment', 'noorgfx-component' ),
				'view' => 'text',
				'design' => 'block',
				'divider' => 'top',
				'responsive' => true,
				'attr' => [ 'data-type' => 'vertical-alignment' ],
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => 'CT_CSS_SKIP_RULE',
				'choices' => [
					'flex-start' => '',
					'center' => '',
					'flex-end' => '',
				],
			],

			'footer_visibility' => [
				'label' => __('Element Visibility', 'noorgfx-component'),
				'type' => 'ct-visibility',
				'design' => 'block',
				'divider' => 'top',
				'sync' => 'live',
				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),
				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx-component' ),
					'tablet' => __( 'Tablet', 'noorgfx-component' ),
					'mobile' => __( 'Mobile', 'noorgfx-component' ),
				]),
			],

		] : []),
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx-component' ),
		'type' => 'tab',
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Input Font Color', 'noorgfx-component' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'sb_font_color',
						'label' => __('Default State', 'noorgfx-component')
					],

					[
						'id' => 'transparent_sb_font_color',
						'label' => __('Transparent State', 'noorgfx-component'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'sticky_sb_font_color',
						'label' => __('Sticky State', 'noorgfx-component'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'sb_font_color' => [
						'label' => __( 'Input Font Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'focus' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
								'inherit' => 'var(--theme-form-text-initial-color, var(--theme-text-color))'
							],

							[
								'title' => __( 'Focus', 'noorgfx-component' ),
								'id' => 'focus',
								'inherit' => 'var(--theme-form-text-focus-color, var(--theme-text-color))'
							],
						],
					],

					'transparent_sb_font_color' => [
						'label' => __( 'Input Font Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'focus' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Focus', 'noorgfx-component' ),
								'id' => 'focus',
							],
						],
					],

					'sticky_sb_font_color' => [
						'label' => __( 'Input Font Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'focus' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Focus', 'noorgfx-component' ),
								'id' => 'focus',
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
				'attr' => [ 'data-type' => 'small' ],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Input Icon Color', 'noorgfx-component' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'sb_icon_color',
						'label' => __('Default State', 'noorgfx-component')
					],

					[
						'id' => 'transparent_sb_icon_color',
						'label' => __('Transparent State', 'noorgfx-component'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'sticky_sb_icon_color',
						'label' => __('Sticky State', 'noorgfx-component'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'sb_icon_color' => [
						'label' => __( 'Input Icon Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'focus' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
								'inherit' => 'var(--theme-text-color)'
							],

							[
								'title' => __( 'Focus', 'noorgfx-component' ),
								'id' => 'focus',
								'inherit' => 'var(--theme-text-color)'
							],
						],
					],

					'transparent_sb_icon_color' => [
						'label' => __( 'Input Icon Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'focus' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Focus', 'noorgfx-component' ),
								'id' => 'focus',
							],
						],
					],

					'sticky_sb_icon_color' => [
						'label' => __( 'Input Icon Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'focus' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Focus', 'noorgfx-component' ),
								'id' => 'focus',
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
				'attr' => [ 'data-type' => 'small' ],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Input Border Color', 'noorgfx-component' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'sb_border_color',
						'label' => __('Default State', 'noorgfx-component')
					],

					[
						'id' => 'transparent_sb_border_color',
						'label' => __('Transparent State', 'noorgfx-component'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'sticky_sb_border_color',
						'label' => __('Sticky State', 'noorgfx-component'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'sb_border_color' => [
						'label' => __( 'Input Border Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'focus' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
								'inherit' => 'var(--theme-form-field-border-initial-color)'
							],

							[
								'title' => __( 'Focus', 'noorgfx-component' ),
								'id' => 'focus',
								'inherit' => 'var(--theme-form-field-border-focus-color)'
							],
						],
					],

					'transparent_sb_border_color' => [
						'label' => __( 'Input Border Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'focus' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Focus', 'noorgfx-component' ),
								'id' => 'focus',
							],
						],
					],

					'sticky_sb_border_color' => [
						'label' => __( 'Input Border Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'focus' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Focus', 'noorgfx-component' ),
								'id' => 'focus',
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => ['forms_type' => 'classic-forms'],
				'values_source' => 'global',
				'options' => [

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
						'attr' => [ 'data-type' => 'small' ],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-labeled-group',
						'label' => __( 'Input Background Color', 'noorgfx-component' ),
						'responsive' => true,
						'choices' => [
							[
								'id' => 'sb_background',
								'label' => __('Default State', 'noorgfx-component'),
							],

							[
								'id' => 'transparent_sb_background',
								'label' => __('Transparent State', 'noorgfx-component'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_transparent_header' => 'yes',
								],
							],

							[
								'id' => 'sticky_sb_background',
								'label' => __('Sticky State', 'noorgfx-component'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_sticky_header' => 'yes',
								],
							],
						],
						'options' => [
							'sb_background' => [
								'label' => __( 'Input Background Color', 'noorgfx-component' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],

								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(),
									],

									'focus' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx-component' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Focus', 'noorgfx-component' ),
										'id' => 'focus',
									],
								],
							],

							'transparent_sb_background' => [
								'label' => __( 'Input Background Color', 'noorgfx-component' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],

								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'focus' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx-component' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Focus', 'noorgfx-component' ),
										'id' => 'focus',
									],
								],
							],

							'sticky_sb_background' => [
								'label' => __( 'Input Background Color', 'noorgfx-component' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],

								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'focus' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx-component' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Focus', 'noorgfx-component' ),
										'id' => 'focus',
									],
								],
							],

						],
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => ['forms_type' => 'classic-forms'],
				'values_source' => 'global',
				'options' => [

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],

					'sb_radius' => [
						'label' => __( 'Input Border Radius', 'noorgfx-component' ),
						'type' => 'ct-spacing',
						'value' => noorgfx_spacing_value(),
						'min' => 0,
						'responsive' => true
					],
				],
			],

			'sb_margin' => [
				'label' => __( 'Margin', 'noorgfx-component' ),
				'type' => 'ct-spacing',
				'divider' => 'top',
				'value' => noorgfx_spacing_value(),
				'responsive' => true
			],


			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'enable_live_results' => 'yes' ],
				'options' => [

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],

					'sb_dropdown_font' => [
						'type' => 'ct-typography',
						'label' => __( 'Dropdown Font', 'noorgfx-component' ),
						'value' => noorgfx_typography_default_values([
							'size' => '14px',
							'variation' => 'n5',
							'line-height' => '1.4',
						]),
						'setting' => [ 'transport' => 'postMessage' ],
					],

					'sb_dropdown_text' => [
						'label' => __( 'Dropdown Text Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => 'var(--theme-text-color)',
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx-component' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-link-hover-color)'
							],
						],
					],

					'sb_dropdown_background' => [
						'label' => __( 'Dropdown Background', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'divider' => 'top',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => '#ffffff',
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],
						],
					],

					'sb_dropdown_shadow' => [
						'label' => __( 'Dropdown Shadow', 'noorgfx-component' ),
						'type' => 'ct-box-shadow',
						'divider' => 'top',
						'responsive' => true,
						'value' => noorgfx_box_shadow_value([
							'enable' => true,
							'h_offset' => 0,
							'v_offset' => 50,
							'blur' => 70,
							'spread' => 0,
							'inset' => false,
							'color' => [
								'color' => 'rgba(210, 213, 218, 0.4)',
							],
						])
					],

					'sb_dropdown_divider' => [
						'label' => __( 'Items Divider', 'noorgfx-component' ),
						'type' => 'ct-border',
						'design' => 'inline',
						'divider' => 'top',
						'value' => [
							'width' => 1,
							'style' => 'dashed',
							'color' => [
								'color' => 'rgba(0, 0, 0, 0.05)',
							],
						]
					],

				],
			],

		],
	],
];

if ($panel_type === 'header') {
	$options[noorgfx_rand_md5()] = [
		'type' => 'ct-condition',
		'condition' => [
			'wp_customizer_current_view' => 'tablet|mobile'
		],
		'options' => [
			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'visibility' => [
				'label' => __( 'Element Visibility', 'noorgfx-component' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'setting' => [ 'transport' => 'postMessage' ],
				'allow_empty' => true,
				'value' => noorgfx_default_responsive_value([
					'tablet' => true,
					'mobile' => true,
				]),

				'choices' => noorgfx_ordered_keys([
					'tablet' => __( 'Tablet', 'noorgfx-component' ),
					'mobile' => __( 'Mobile', 'noorgfx-component' ),
				]),
			],

		],
	];
}
