<?php

$forms_type = blc_theme_functions()->noorgfx_get_theme_mod('forms_type', 'classic-forms');

$headerSearchBoxMaxWidth = noorgfx_akg( 'searchBoxMaxWidth', $atts, 25 );

if ($headerSearchBoxMaxWidth !== 25) {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'variableName' => 'max-width',
		'value' => $headerSearchBoxMaxWidth,
		'unit' => '%'
	]);

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => [$root_selector[0]],
				'operation' => 'suffix',
				'to_add' => '[data-middle="search-input"]'
			])
		),
		'variableName' => 'search-box-max-width',
		'value' => $headerSearchBoxMaxWidth,
		'unit' => '%'
	]);
}

$headerSearchBoxHeight = noorgfx_akg( 'headerSearchBoxHeight', $atts, 40 );

if ($headerSearchBoxHeight !== 40) {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'variableName' => 'theme-form-field-height',
		'value' => $headerSearchBoxHeight,
		'unit' => 'px'
	]);
}


// default state
noorgfx_output_colors([
	'value' => noorgfx_akg('sb_font_color', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'focus' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,

	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'theme-form-text-initial-color'
		],

		'focus' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'theme-form-text-focus-color'
		],
	],
	'responsive' => true
]);

noorgfx_output_colors([
	'value' => noorgfx_akg('sb_icon_color', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'focus' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,

	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.wp-element-button'
				])
			),
			'variable' => 'theme-button-text-initial-color'
		],

		'focus' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.wp-element-button'
				])
			),
			'variable' => 'theme-button-text-hover-color'
		],
	],
	'responsive' => true
]);

noorgfx_output_colors([
	'value' => noorgfx_akg('sb_border_color', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'focus' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,

	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'theme-form-field-border-initial-color'
		],

		'focus' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'theme-form-field-border-focus-color'
		],
	],
	'responsive' => true
]);

$taxonomy_filter_visibility = noorgfx_akg(
	'taxonomy_filter_visibility',
	$atts,
	[
		'desktop' => true,
		'tablet' => true,
		'mobile' => false,
	]
);

$taxonomy_filter_visibility = noorgfx_expand_responsive_value($taxonomy_filter_visibility);

if (noorgfx_akg('has_taxonomy_filter', $atts, 'no') === 'yes') {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'variableName' => 'has-taxonomy-filter',
		'value' => [
			'desktop' => $taxonomy_filter_visibility['desktop'] ? '1' : '0',
			'tablet' => $taxonomy_filter_visibility['tablet'] ? '1' : '0',
			'mobile' => $taxonomy_filter_visibility['mobile'] ? '1' : '0',
		],
		'unit' => ''
	]);
}

if ($forms_type === 'classic-forms') {
	noorgfx_output_colors([
		'value' => noorgfx_akg('sb_background', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword() ],
			'focus' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword() ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector($root_selector),
				'variable' => 'theme-form-field-background-initial-color'
			],

			'focus' => [
				'selector' => noorgfx_assemble_selector($root_selector),
				'variable' => 'theme-form-field-background-focus-color'
			],
		],
		'responsive' => true
	]);
}

// transparent state
if (isset($has_transparent_header) && $has_transparent_header) {
	noorgfx_output_colors([
		'value' => noorgfx_akg('transparent_sb_font_color', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'focus' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-form-text-initial-color'
			],

			'focus' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-form-text-focus-color'
			],
		],
		'responsive' => true
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('transparent_sb_icon_color', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'focus' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.wp-element-button'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-button-text-initial-color'
			],

			'focus' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.wp-element-button'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-button-text-hover-color'
			],
		],
		'responsive' => true
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('transparent_sb_border_color', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'focus' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'between',
					'to_add' => '[data-transparent-row="yes"]'
				])),
				'variable' => 'theme-form-field-border-initial-color'
			],

			'focus' => [
				'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'between',
					'to_add' => '[data-transparent-row="yes"]'
				])),
				'variable' => 'theme-form-field-border-focus-color'
			],
		],
		'responsive' => true
	]);

	if ($forms_type !== 'classic-forms' || is_customize_preview()) {
		noorgfx_output_colors([
			'value' => noorgfx_akg('transparent_sb_background', $atts),
			'default' => [
				'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'focus' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			],
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,

			'variables' => [
				'default' => [
					'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])),
					'variable' => 'theme-form-field-background-initial-color'
				],

				'focus' => [
					'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])),
					'variable' => 'theme-form-field-background-focus-color'
				],
			],
			'responsive' => true
		]);
	}
}

// sticky state
if (isset($has_sticky_header) && $has_sticky_header) {
	noorgfx_output_colors([
		'value' => noorgfx_akg('sticky_sb_font_color', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'focus' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-form-text-initial-color'
			],

			'focus' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-form-text-focus-color'
			],
		],
		'responsive' => true
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('sticky_sb_icon_color', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'focus' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.wp-element-button'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-button-text-initial-color'
			],

			'focus' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.wp-element-button'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-button-text-hover-color'
			],
		],
		'responsive' => true
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('sticky_sb_border_color', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'focus' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'between',
					'to_add' => '[data-sticky*="yes"]'
				])),
				'variable' => 'theme-form-field-border-initial-color'
			],

			'focus' => [
				'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'between',
					'to_add' => '[data-sticky*="yes"]'
				])),
				'variable' => 'theme-form-field-border-focus-color'
			],
		],
		'responsive' => true
	]);

	if ($forms_type !== 'classic-forms' || is_customize_preview()) {
		noorgfx_output_colors([
			'value' => noorgfx_akg('sticky_sb_background', $atts),
			'default' => [
				'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'focus' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			],
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,

			'variables' => [
				'default' => [
					'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])),
					'variable' => 'theme-form-field-background-initial-color'
				],

				'focus' => [
					'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])),
					'variable' => 'theme-form-field-background-focus-color'
				],
			],
			'responsive' => true
		]);
	}
}


if ($forms_type === 'classic-forms' || is_customize_preview()) {
	noorgfx_output_spacing([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'property' => 'theme-form-field-border-radius',
		'value' => noorgfx_default_akg(
			'sb_radius',
			$atts,
			noorgfx_spacing_value()
		)
	]);
}

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'important' => true,
	'value' => noorgfx_default_akg(
		'sb_margin',
		$atts,
		noorgfx_spacing_value()
	)
]);


// Live results
$has_live_results = noorgfx_akg( 'enable_live_results', $atts, 'no' );

if ($has_live_results === 'yes') {
	noorgfx_output_font_css([
		'font_value' => noorgfx_akg( 'sb_dropdown_font', $atts,
			noorgfx_typography_default_values([
				'size' => '14px',
				'variation' => 'n5',
				'line-height' => '1.4',
			])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.ct-search-results'
			])
		),
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('sb_dropdown_text', $atts),
		'default' => [
			'default' => [ 'color' => 'var(--theme-text-color)' ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '.ct-search-results'
					])
				),
				'variable' => 'theme-link-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '.ct-search-results'
					])
				),
				'variable' => 'theme-link-hover-color'
			],
		],

		'responsive' => true
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('sb_dropdown_background', $atts),
		'default' => [
			'default' => [ 'color' => '#ffffff' ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '.ct-search-results'
					])
				),
				'variable' => 'search-dropdown-background'
			],
		],

		'responsive' => true
	]);

	noorgfx_output_border([
		'css' => $css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.ct-search-results'
			])
		),
		'variableName' => 'items-divider',
		'value' => noorgfx_akg('sb_dropdown_divider', $atts),
		'default' => [
			'width' => 1,
			'style' => 'dashed',
			'color' => [
				'color' => 'rgba(0, 0, 0, 0.05)',
			],
		]
	]);

	noorgfx_output_box_shadow([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.ct-search-results'
			])
		),
		'value' => noorgfx_akg('sb_dropdown_shadow', $atts, noorgfx_box_shadow_value([
			'enable' => true,
			'h_offset' => 0,
			'v_offset' => 50,
			'blur' => 70,
			'spread' => 0,
			'inset' => false,
			'color' => [
				'color' => 'rgba(210, 213, 218, 0.4)',
			],
		])),
		'variableName' => 'search-dropdown-box-shadow',
		'responsive' => true
	]);
}

// footer search box
noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'replace-last',
		'to_add' => '[data-column="search-input"]'
	])),
	'variableName' => 'horizontal-alignment',
	'value' => noorgfx_akg( 'footer_search_box_horizontal_alignment', $atts, 'CT_CSS_SKIP_RULE' ),
	'unit' => '',
]);


noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'replace-last',
		'to_add' => '[data-column="search-input"]'
	])),
	'variableName' => 'vertical-alignment',
	'value' => noorgfx_akg( 'footer_search_box_vertical_alignment', $atts, 'CT_CSS_SKIP_RULE' ),
	'unit' => '',
]);
