<?php

$class = 'ct-language-switcher';

if (!isset($device)) {
	$device = 'desktop';
}

if ($panel_type === 'header') {
	$visibility = noorgfx_default_akg('visibility', $atts, [
		'tablet' => true,
		'mobile' => true,
	]);
} else {
	$visibility = noorgfx_default_akg('footer_visibility', $atts, [
		'desktop' => true,
		'tablet' => true,
		'mobile' => true,
	]);
}

$class .= ' ' . noorgfx_visibility_classes($visibility);

$language_type = noorgfx_default_akg(
	'language_type',
	$atts,
	[
		'icon' => true,
		'label' => true,
	]
);

$dropdown_language_type = noorgfx_default_akg(
	'dropdown_language_type',
	$atts,
	[
		'custom_icon' => false,
		'icon' => true,
		'label' => true,
	]
);

$dropdown_icon = blc_get_icon([
	'icon_descriptor' => noorgfx_default_akg('dropdown_custom_icon', $atts, [
		'icon' => 'blc blc-globe',
	]),
	'icon_container' => false,
	'icon_html_atts' => [
		'class' => 'ct-icon',
	]
]);

$language_label = noorgfx_default_akg('language_label', $atts, 'long');
$dropdown_language_label = noorgfx_default_akg('dropdown_language_label', $atts, 'long');

$language_label_position = noorgfx_expand_responsive_value(
	noorgfx_default_akg('language_label_position', $atts, 'right')
);

$dropdown_language_label_position = noorgfx_expand_responsive_value(
	noorgfx_default_akg('dropdown_language_label_position', $atts, 'right')
);

$ls_type = 'inline';

if ($panel_type === 'header') {
	$ls_type = noorgfx_default_akg('ls_type', $atts, 'inline');

	if (isset($row_id) && $row_id === 'offcanvas') {
		$ls_type = 'inline';
	}
}

$items_language_type = $language_type;
$items_language_label = $language_label;
$items_language_label_position = $language_label_position[$device];

if ($ls_type === 'dropdown') {
	$items_language_type = $dropdown_language_type;
	$items_language_label_position = $dropdown_language_label_position[$device];
	$items_language_label = $dropdown_language_label;
}

$hide_current_language = noorgfx_default_akg('hide_current_language', $atts, 'no') === 'yes';

$has_arrow = noorgfx_akg('ls_dropdown_arrow', $atts, 'no') === 'yes';
$hide_missing_language = noorgfx_akg('hide_missing_language', $atts, 'no') === 'yes';

$current_plugin = null;

if (function_exists('icl_object_id') && function_exists('icl_disp_language')) {
	$current_plugin = 'wpml';
}

if (function_exists('pll_the_languages')) {
	$current_plugin = 'polylang';
}

if (class_exists('TRP_Translate_Press')) {
	$current_plugin = 'translate-press';
}

if (function_exists('weglot_get_current_language')) {
	$current_plugin = 'weglot';
}

$output = '';

$icon = '<svg class="ct-icon ct-dropdown-icon" width="8" height="8" viewBox="0 0 15 15" aria-hidden="true"><path d="M2.1,3.2l5.4,5.4l5.4-5.4L15,4.3l-7.5,7.5L0,4.3L2.1,3.2z"></path></svg>';

if ($current_plugin) {
	$descriptors = blc_theme_functions()->noorgfx_get_variables_from_file(
		dirname(__FILE__) . '/plugins/' . $current_plugin . '.php',
		['descriptors' => []],
		[
			'hide_missing_language' => $hide_missing_language,
		]
	);
	
	$items_html = [];

	foreach ($descriptors['descriptors'] as $key => $descriptor) {
		$content = '';
		$flag_image = '';

		if (
			$ls_type === 'dropdown'
			&&
			$key === 'current'
		) {
			if (
				isset($language_type['custom_icon'])
				&&
				$language_type['custom_icon']
			) {
				$content .= $icon;
			}

			if (
				$descriptor['country_flag_url']
				&&
				$language_type['icon']
			) {
				$flag_image = noorgfx_html_tag(
					'img',
					[
						'src' => $descriptor['country_flag_url'],
						'width' => '18',
						'height' => '12',
						// 'alt' => $descriptor['language_code'],
						'alt' => '',
						'aria-hidden' => 'true',
						// 'title' => $descriptor['native_name'],
					]
				);
			}

			if ($language_type['label']) {
				$content .= noorgfx_html_tag(
					'span',
					[
						'class' => 'ct-label',
						'aria-hidden' => 'true',
					],
					$language_label === 'long'
						? $descriptor['native_name']
						: $descriptor['short_name']
				);
			}

			$content .= $flag_image;

			if ($has_arrow) {
				$content .= $icon;
			}

			$output .= noorgfx_html_tag(
				'div',
				[
					'class' => 'ct-language ct-active-language',
					'data-label' => $language_label_position[$device],
					'aria-label' => $descriptor['native_name'],
					'lang' => $descriptor['language_code'],
					'tabindex' => '0',
				],
				$content
			);

			continue;
		}

		if (
			$hide_current_language
			&&
			$key === 'current'
		) {
			continue;
		}

		if (
			$descriptor['country_flag_url']
			&&
			$items_language_type['icon']
		) {
			$flag_image = noorgfx_html_tag(
				'img',
				[
					'src' => $descriptor['country_flag_url'],
					'width' => '18',
					'height' => '12',
					// 'alt' => $descriptor['language_code'],
					'alt' => '',
					'aria-hidden' => 'true',
					// 'title' => $descriptor['native_name'],
				]
			);
		}

		if ($items_language_type['label']) {
			$content .= noorgfx_html_tag(
				'span',
				[
					'class' => 'ct-label',
					'aria-hidden' => 'true',
				],
				$items_language_label === 'long'
					? $descriptor['native_name']
					: $descriptor['short_name']
			);
		}

		$content .= $flag_image;

		$items_html[] = noorgfx_html_tag(
			'li',
			$key === 'current' ? [
				'class' => 'current-lang',
			] : [],
			noorgfx_html_tag(
				'a',
				array_merge(
					[
						'href' => $descriptor['url'],
						'data-label' => $items_language_label_position,
						'aria-label' => $descriptor['native_name'],
						'lang' => $descriptor['language_code'],
					],
					($ls_type === 'dropdown' ? [] : [					
						'data-label' => $items_language_label_position,
					]),
					($current_plugin === 'weglot' ? [
						'data-wg-notranslate' => "",
					] : [])
				),
				$content
			)
		);
	}

	$output .= noorgfx_html_tag(
		'ul',
		(
			$ls_type !== "dropdown" ? [
				'class' => 'ct-language',
			] : []
		),
		implode('', $items_html)
	);
}

?>

<div
	class="<?php echo esc_attr(trim($class)) ?>"
	data-type="<?php echo $ls_type ?>"
	<?php echo noorgfx_attr_to_html($attr) ?>>

	<?php echo $output ?>

</div>
