<?php

$common_options = noorgfx_get_options(
	dirname(__FILE__) . '/common.php',
	[
		'sync_id' => $sync_id
	],
	false
);

$general_options = [
	$common_options,

	[
		'ls_items_spacing' => [
			'label' => __( 'Items Spacing', 'noorgfx-component' ),
			'type' => 'ct-slider',
			'min' => 5,
			'max' => 50,
			'value' => 20,
			'responsive' => true,
			'divider' => 'top',
		],

		'hide_current_language' => [
			'label' => __( 'Hide Current Language', 'noorgfx-component' ),
			'type' => 'ct-switch',
			'design' => 'inline',
			'divider' => 'top',
			'disableRevertButton' => true,
			'value' => 'no',
			'sync' => [
				'id' => $sync_id
			]
		],
	]
];

$design_options = [
	'ls_font' => [
		'type' => 'ct-typography',
		'label' => __( 'Font', 'noorgfx-component' ),
		'value' => noorgfx_typography_default_values([
			'size' => '12px',
			'variation' => 'n6',
			'text-transform' => 'uppercase',
		])
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-labeled-group',
		'label' => __( 'Font Color', 'noorgfx-component' ),
		'responsive' => true,
		'choices' => [
			[
				'id' => 'ls_label_color',
				'label' => __('Default State', 'noorgfx-component')
			],

			[
				'id' => 'transparent_ls_label_color',
				'label' => __('Transparent State', 'noorgfx-component'),
				'condition' => [
					'row' => '!offcanvas',
					'builderSettings/has_transparent_header' => 'yes',
				],
			],

			[
				'id' => 'sticky_ls_label_color',
				'label' => __('Sticky State', 'noorgfx-component'),
				'condition' => [
					'row' => '!offcanvas',
					'builderSettings/has_sticky_header' => 'yes',
				],
			],
		],
		'options' => [

			'ls_label_color' => [
				'label' => __( 'Font Color', 'noorgfx-component' ),
				'type'  => 'ct-color-picker',
				'design' => 'block:right',
				'responsive' => true,

				'value' => [
					'default' => [
						'color' => 'var(--theme-text-color)',
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx-component' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Hover/Active', 'noorgfx-component' ),
						'id' => 'hover',
						'inherit' => 'var(--theme-link-hover-color)'
					],
				],
			],

			'transparent_ls_label_color' => [
				'label' => __( 'Font Color', 'noorgfx-component' ),
				'type'  => 'ct-color-picker',
				'design' => 'block:right',
				'responsive' => true,

				'value' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx-component' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Hover/Active', 'noorgfx-component' ),
						'id' => 'hover',
					],
				],
			],

			'sticky_ls_label_color' => [
				'label' => __( 'Font Color', 'noorgfx-component' ),
				'type'  => 'ct-color-picker',
				'design' => 'block:right',
				'responsive' => true,

				'value' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx-component' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Hover/Active', 'noorgfx-component' ),
						'id' => 'hover',
					],
				],
			],

		],
	],

	'ls_margin' => [
		'label' => __( 'Margin', 'noorgfx-component' ),
		'type' => 'ct-spacing',
		'divider' => 'top',
		'value' => noorgfx_spacing_value(),
		'responsive' => true
	],
];

