<?php

$options = [

	'divider_height' => [
		'label' => __( 'Size', 'noorgfx-component' ),
		'type' => 'ct-slider',
		'min' => 10,
		'max' => 100,
		'value' => '100',
		'defaultUnit' => '%',
		'responsive' => true,
		'setting' => [ 'transport' => 'postMessage' ],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-divider',
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-labeled-group',
		'label' => __( 'Style & Color', 'noorgfx-component' ),
		'responsive' => true,
		'choices' => [
			[
				'id' => 'header_divider',
				'label' => __('Default State', 'noorgfx-component')
			],

			[
				'id' => 'transparent_header_divider',
				'label' => __('Transparent State', 'noorgfx-component'),
				'condition' => [
					'row' => '!offcanvas',
					'builderSettings/has_transparent_header' => 'yes',
				],
			],

			[
				'id' => 'sticky_header_divider',
				'label' => __('Sticky State', 'noorgfx-component'),
				'condition' => [
					'row' => '!offcanvas',
					'builderSettings/has_sticky_header' => 'yes',
				],
			],
		],
		'options' => [

			'header_divider' => [
				'label' => __( 'Style & Color', 'noorgfx-component' ),
				'type' => 'ct-border',
				'design' => 'block',
				'sync' => 'live',
				'responsive' => true,
				'value' => [
					'width' => 1,
					'style' => 'solid',
					'color' => [
						'color' => 'rgba(44,62,80,0.2)',
					],
				]
			],

			'transparent_header_divider' => [
				'label' => __( 'Style & Color', 'noorgfx-component' ),
				'type' => 'ct-border',
				'design' => 'block',
				'sync' => 'live',
				'responsive' => true,
				'value' => [
					'width' => 1,
					'style' => 'solid',
					'color' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				]
			],

			'sticky_header_divider' => [
				'label' => __( 'Style & Color', 'noorgfx-component' ),
				'type' => 'ct-border',
				'design' => 'block',
				'sync' => 'live',
				'responsive' => true,
				'value' => [
					'width' => 1,
					'style' => 'solid',
					'color' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				]
			],
		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-divider',
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'row' => '!offcanvas', ],
		'options' => [

			'divider_horizontal_margin' => [
				'label' => __( 'Margin', 'noorgfx-component' ),
				'type' => 'ct-spacing',
				'value' => noorgfx_spacing_value([
					'top' => 'auto',
					'bottom' => 'auto',
				]),
				'responsive' => true
			],

		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'row' => 'offcanvas', ],
		'options' => [

			'divider_vertical_margin' => [
				'label' => __( 'Margin', 'noorgfx-component' ),
				'type' => 'ct-spacing',
				'value' => noorgfx_spacing_value([
					'left' => 'auto',
					'right' => 'auto',
				]),
				'responsive' => true
			],

		],
	],
];
