<?php

$divider_size = noorgfx_akg( 'divider_height', $atts, '100' );

if ($divider_size !== '100') {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'variableName' => 'divider-size',
		'value' => $divider_size,
		'unit' => '%',
		'responsive' => true
	]);
}

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'important' => true,
	'value' => noorgfx_default_akg(
		'divider_horizontal_margin',
		$atts,
		noorgfx_spacing_value([
			'top' => 'auto',
			'bottom' => 'auto',
		])
	)
]);

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'important' => true,
	'value' => noorgfx_default_akg(
		'divider_vertical_margin',
		$atts,
		noorgfx_spacing_value([
			'left' => 'auto',
			'right' => 'auto',
		])
	)
]);

noorgfx_output_border([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'variableName' => 'divider-style',
	'value' => noorgfx_akg('header_divider', $atts),
	'default' => [
		'width' => 1,
		'style' => 'solid',
		'color' => [ 'color' => 'rgba(44,62,80,0.2)' ],
	],
	'responsive' => true
]);

// transparent state
if (isset($has_transparent_header) && $has_transparent_header) {
	noorgfx_output_border([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'between',
			'to_add' => '[data-transparent-row="yes"]'
		])),
		'variableName' => 'divider-style',
		'value' => noorgfx_akg('transparent_header_divider', $atts),
		'default' => [
			'width' => 1,
			'style' => 'solid',
			'color' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'responsive' => true
	]);
}

// sticky state
if (isset($has_sticky_header) && $has_sticky_header) {
	noorgfx_output_border([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'between',
			'to_add' => '[data-sticky*="yes"]'
		])),
		'variableName' => 'divider-style',
		'value' => noorgfx_akg('sticky_header_divider', $atts),
		'default' => [
			'width' => 1,
			'style' => 'solid',
			'color' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'responsive' => true
	]);
}

