<?php

$direction_option = [
	'contacts_items_direction' => [
		'type' => 'ct-radio',
		'label' => __( 'Items Direction', 'noorgfx-component' ),
		'view' => 'text',
		'design' => 'block',
		'divider' => 'top:full',
		'responsive' => true,
		'value' => 'column',
		'choices' => [
			'column' => __( 'Vertical', 'noorgfx-component' ),
			'row' => __( 'Horizontal', 'noorgfx-component' ),
		],
	],
];

$visibility_option = [
	'visibility' => [
		'label' => __( 'Item Visibility', 'noorgfx-component' ),
		'type' => 'ct-visibility',
		'design' => 'block',
		// 'allow_empty' => true,
		'value' => noorgfx_default_responsive_value([
			'desktop' => true,
			'tablet' => true,
			'mobile' => true,
		]),

		'choices' => noorgfx_ordered_keys([
			'desktop' => __( 'Desktop', 'noorgfx-component' ),
			'tablet' => __( 'Tablet', 'noorgfx-component' ),
			'mobile' => __( 'Mobile', 'noorgfx-component' ),
		]),

		'sync' => [
			'shouldSkip' => 'skip'
		],
	],
];

$options = [
	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx-component' ),
		'type' => 'tab',
		'options' => [
			[
				'contact_items' => [
					'label' => false,
					'type' => 'ct-layers',
					'manageable' => true,
					'value' => [
						[
							'id' => 'address',
							'enabled' => true,
							'title' => __('Address:', 'noorgfx-component'),
							'content' => 'خیابان یکم پلاک دوم',
							'link' => '',
						],

						[
							'id' => 'phone',
							'enabled' => true,
							'title' => __('Phone:', 'noorgfx-component'),
							'content' => '021-12345678',
							'link' => 'tel:021-12345678',
						],

						[
							'id' => 'mobile',
							'enabled' => true,
							'title' => __('Mobile:', 'noorgfx-component'),
							'content' => '021-12345678',
							'link' => 'tel:021-12345678',
						],

					],

					'settings' => [
						'address' => [
							'label' => __( 'Address', 'noorgfx-component' ),
							'options' => [
								[
									'title' => [
										'type' => 'text',
										'label' => __('Title', 'noorgfx-component'),
										'value' => __('Address:', 'noorgfx-component'),
										'design' => 'block',
										'sync' => [
											'shouldSkip' => 'skip'
										],
									],

									'content' => [
										'type' => 'text',
										'label' => __('Content', 'noorgfx-component'),
										'value' => 'خیابان یکم پلاک دوم',
										'design' => 'block',
										'sync' => [
											'shouldSkip' => 'skip'
										],
									],

									'link' => [
										'type' => 'text',
										'label' => __('Link (optional)', 'noorgfx-component'),
										'value' => '',
										'design' => 'block',
									],

									'icon' => [
										'type' => 'icon-picker',
										'label' => __('Icon', 'noorgfx-component'),
										'design' => 'inline',
										'value' => [
											'icon' => 'blc blc-map-pin'
										]
									],
								],

								$visibility_option
							]
						],

						'phone' => [
							'label' => __( 'Phone', 'noorgfx-component' ),
							'options' => [
								[
									'title' => [
										'type' => 'text',
										'label' => __('Title', 'noorgfx-component'),
										'value' => __('Phone:', 'noorgfx-component'),
										'design' => 'block',
										'sync' => [
											'shouldSkip' => 'skip'
										],
									],

									'content' => [
										'type' => 'text',
										'label' => __('Content', 'noorgfx-component'),
										'value' => '021-12345678',
										'design' => 'block',
										'sync' => [
											'shouldSkip' => 'skip'
										],
									],

									'link' => [
										'type' => 'text',
										'label' => __('Link (optional)', 'noorgfx-component'),
										'value' => 'tel:021-12345678',
										'design' => 'block',
									],

									'icon' => [
										'type' => 'icon-picker',
										'label' => __('Icon', 'noorgfx-component'),
										'design' => 'inline',
										'value' => [
											'icon' => 'blc blc-phone'
										]
									],
								],

								$visibility_option
							]
						],

						'mobile' => [
							'label' => __( 'Mobile', 'noorgfx-component' ),
							'options' => [
								[
									'title' => [
										'type' => 'text',
										'label' => __('Title', 'noorgfx-component'),
										'value' => __('Mobile:', 'noorgfx-component'),
										'design' => 'block',
										'sync' => [
											'shouldSkip' => 'skip'
										],
									],

									'content' => [
										'type' => 'text',
										'label' => __('Content', 'noorgfx-component'),
										'value' => '021-12345678',
										'design' => 'block',
										'sync' => [
											'shouldSkip' => 'skip'
										],
									],

									'link' => [
										'type' => 'text',
										'label' => __('Link (optional)', 'noorgfx-component'),
										'value' => 'tel:021-12345678',
										'design' => 'block',
									],

									'icon' => [
										'type' => 'icon-picker',
										'label' => __('Icon', 'noorgfx-component'),
										'design' => 'inline',
										'value' => [
											'icon' => 'blc blc-mobile-phone'
										]
									],
								],

								$visibility_option
							]
						],

						'hours' => [
							'label' => __( 'Work Hours', 'noorgfx-component' ),
							'options' => [
								[
									'title' => [
										'type' => 'text',
										'label' => __('Title', 'noorgfx-component'),
										'value' => __('Opening hours:', 'noorgfx-component'),
										'design' => 'block',
										'sync' => [
											'shouldSkip' => 'skip'
										],
									],

									'content' => [
										'type' => 'text',
										'label' => __('Content', 'noorgfx-component'),
										'value' => '9AM - 5PM',
										'design' => 'block',
										'sync' => [
											'shouldSkip' => 'skip'
										],
									],

									'link' => [
										'type' => 'text',
										'label' => __('Link (optional)', 'noorgfx-component'),
										'value' => '',
										'design' => 'block',
									],

									'icon' => [
										'type' => 'icon-picker',
										'label' => __('Icon', 'noorgfx-component'),
										'design' => 'inline',
										'value' => [
											'icon' => 'blc blc-clock'
										]
									],
								],

								$visibility_option

							]
						],

						'fax' => [
							'label' => __( 'Fax', 'noorgfx-component' ),
							'options' => [
								[
									'title' => [
										'type' => 'text',
										'label' => __('Title', 'noorgfx-component'),
										'value' => __('Fax:', 'noorgfx-component'),
										'design' => 'block',
										'sync' => [
											'shouldSkip' => 'skip'
										],
									],

									'content' => [
										'type' => 'text',
										'label' => __('Content', 'noorgfx-component'),
										'value' => '021-12345678',
										'design' => 'block',
										'sync' => [
											'shouldSkip' => 'skip'
										],
									],

									'link' => [
										'type' => 'text',
										'label' => __('Link (optional)', 'noorgfx-component'),
										'value' => 'tel:021-12345678',
										'design' => 'block',
									],

									'icon' => [
										'type' => 'icon-picker',
										'label' => __('Icon', 'noorgfx-component'),
										'design' => 'inline',
										'value' => [
											'icon' => 'blc blc-fax'
										]
									],
								],

								$visibility_option
							]
						],

						'email' => [
							'label' => __( 'Email', 'noorgfx-component' ),
							'options' => [
								[
									'title' => [
										'type' => 'text',
										'label' => __('Title', 'noorgfx-component'),
										'value' => __('Email:', 'noorgfx-component'),
										'design' => 'block',
										'sync' => [
											'shouldSkip' => 'skip'
										],
									],

									'content' => [
										'type' => 'text',
										'label' => __('Content', 'noorgfx-component'),
										'value' => 'contact@yourwebsite.com',
										'design' => 'block',
										'sync' => [
											'shouldSkip' => 'skip'
										],
									],

									'link' => [
										'type' => 'text',
										'label' => __('Link (optional)', 'noorgfx-component'),
										'value' => 'mailto:contact@yourwebsite.com',
										'design' => 'block',
									],

									'icon' => [
										'type' => 'icon-picker',
										'label' => __('Icon', 'noorgfx-component'),
										'design' => 'inline',
										'value' => [
											'icon' => 'blc blc-email'
										]
									],
								],

								$visibility_option
							]
						],

						'website' => [
							'label' => __( 'Website', 'noorgfx-component' ),
							'options' => [
								[
									'title' => [
										'type' => 'text',
										'label' => __('Title', 'noorgfx-component'),
										'value' => __('Website:', 'noorgfx-component'),
										'design' => 'block',
										'sync' => [
											'shouldSkip' => 'skip'
										],
									],

									'content' => [
										'type' => 'text',
										'label' => __('Content', 'noorgfx-component'),
										'value' => '#',
										'design' => 'block',
										'sync' => [
											'shouldSkip' => 'skip'
										],
									],

									'link' => [
										'type' => 'text',
										'label' => __('Link (optional)', 'noorgfx-component'),
										'value' => '#',
										'design' => 'block',
									],

									'icon' => [
										'type' => 'icon-picker',
										'label' => __('Icon', 'noorgfx-component'),
										'design' => 'inline',
										'value' => [
											'icon' => 'blc blc-globe'
										]
									],
								],

								$visibility_option
							]
						],
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],

				'link_target' => [
					'type'  => 'ct-switch',
					'label' => __( 'Open links in new tab', 'noorgfx-component' ),
					'value' => 'no',
				],

				'link_nofollow' => [
					'type'  => 'ct-switch',
					'label' => __( 'Set links to nofollow', 'noorgfx-component' ),
					'value' => 'no',
				],

				'link_icons' => [
					'type'  => 'ct-switch',
					'label' => __( 'Link Icons', 'noorgfx-component' ),
					'value' => 'no',
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],

				'contacts_icon_size' => [
					'label' => __( 'Icons Size', 'noorgfx-component' ),
					'type' => 'ct-slider',
					'min' => 5,
					'max' => 50,
					'value' => 15,
					'responsive' => true,
				],

				'contacts_spacing' => [
					'label' => __( 'Items Spacing', 'noorgfx-component' ),
					'type' => 'ct-slider',
					'min' => 0,
					'max' => 100,
					'value' => 15,
					'responsive' => true,
					'divider' => 'bottom',
				],

				'contacts_icon_shape' => [
					'label' => __('Icons Shape Type', 'noorgfx-component'),
					'type' => 'ct-radio',
					'value' => 'rounded',
					'view' => 'text',
					'design' => 'block',
					'choices' => [
						'simple' => __( 'None', 'noorgfx-component' ),
						'rounded' => __( 'Rounded', 'noorgfx-component' ),
						'square' => __( 'Square', 'noorgfx-component' ),
					],
					'sync' => 'live',
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'contacts_icon_shape' => '!simple' ],
					'options' => [

						'contacts_icon_fill_type' => [
							'label' => __('Shape Fill Type', 'noorgfx-component'),
							'type' => 'ct-radio',
							'value' => 'outline',
							'view' => 'text',
							'design' => 'block',
							'sync' => 'live',
							'choices' => [
								'outline' => __( 'Outline', 'noorgfx-component' ),
								'solid' => __( 'Solid', 'noorgfx-component' ),
							],
						],

					],
				],
			],

			$panel_type === 'header' ? [
				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => ['wp_customizer_current_view' => 'tablet|mobile'],
					'options' => [
						'visibility' => [
							'label' => __('Element Visibility', 'noorgfx-component'),
							'type' => 'ct-visibility',
							'design' => 'block',
							'divider' => 'top:full',
							'allow_empty' => true,
							'value' => noorgfx_default_responsive_value([
								'tablet' => true,
								'mobile' => true,
							]),

							'choices' => noorgfx_ordered_keys([
								'tablet' => __( 'Tablet', 'noorgfx-component' ),
								'mobile' => __( 'Mobile', 'noorgfx-component' ),
							]),
						],
					],
				],
			] : [],

			$panel_type === 'footer' ? [
				$direction_option,

				'footer_contacts_horizontal_alignment' => [
					'type' => 'ct-radio',
					'label' => __( 'Horizontal Alignment', 'noorgfx-component' ),
					'view' => 'text',
					'design' => 'block',
					'divider' => 'top:full',
					'responsive' => true,
					'attr' => [ 'data-type' => 'alignment' ],
					'value' => 'CT_CSS_SKIP_RULE',
					'choices' => [
						'flex-start' => '',
						'center' => '',
						'flex-end' => '',
					],
				],

				'footer_contacts_vertical_alignment' => [
					'type' => 'ct-radio',
					'label' => __( 'Vertical Alignment', 'noorgfx-component' ),
					'view' => 'text',
					'design' => 'block',
					'divider' => 'top',
					'responsive' => true,
					'attr' => [ 'data-type' => 'vertical-alignment' ],
					'value' => 'CT_CSS_SKIP_RULE',
					'choices' => [
						'flex-start' => '',
						'center' => '',
						'flex-end' => '',
					],
				],

				'footer_contacts_visibility' => [
					'label' => __( 'Element Visibility', 'noorgfx-component' ),
					'type' => 'ct-visibility',
					'design' => 'block',
					'divider' => 'top:full',
					// 'allow_empty' => true,
					'value' => noorgfx_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => true,
					]),

					'choices' => noorgfx_ordered_keys([
						'desktop' => __( 'Desktop', 'noorgfx-component' ),
						'tablet' => __( 'Tablet', 'noorgfx-component' ),
						'mobile' => __( 'Mobile', 'noorgfx-component' ),
					]),
				],
			] : [
				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'row' => 'offcanvas',
					],
					'options' => $direction_option
				]
			]
		]
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx-component' ),
		'type' => 'tab',
		'options' => [

			'contacts_font' => [
				'type' => 'ct-typography',
				'label' => __( 'Font', 'noorgfx-component' ),
				'value' => noorgfx_typography_default_values([
					'size' => '13px',
				])
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Font Color', 'noorgfx-component' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'contacts_font_color',
						'label' => __('Default State', 'noorgfx-component')
					],

					[
						'id' => 'transparent_contacts_font_color',
						'label' => __('Transparent State', 'noorgfx-component'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'sticky_contacts_font_color',
						'label' => __('Sticky State', 'noorgfx-component'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'contacts_font_color' => [
						'label' => __( 'Font Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'divider' => 'bottom',
						'responsive' => true,
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'link_initial' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'link_hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Text Initial', 'noorgfx-component' ),
								'id' => 'default',
								'inherit' => 'var(--theme-text-color)'
							],

							[
								'title' => __( 'Link Initial', 'noorgfx-component' ),
								'id' => 'link_initial',
								'inherit' => 'self:default'
							],

							[
								'title' => __( 'Link Hover', 'noorgfx-component' ),
								'id' => 'link_hover',
								'inherit' => 'var(--theme-link-hover-color)'
							],
						],
					],

					'transparent_contacts_font_color' => [
						'label' => __( 'Font Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'divider' => 'bottom',
						'responsive' => true,
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'link_initial' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'link_hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Text Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Link Initial', 'noorgfx-component' ),
								'id' => 'link_initial',
								'inherit' => 'self:default'
							],

							[
								'title' => __( 'Link Hover', 'noorgfx-component' ),
								'id' => 'link_hover',
							],
						],
					],

					'sticky_contacts_font_color' => [
						'label' => __( 'Font Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'divider' => 'bottom',
						'responsive' => true,
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'link_initial' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'link_hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Text Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Link Initial', 'noorgfx-component' ),
								'id' => 'link_initial',
								'inherit' => 'self:default'
							],

							[
								'title' => __( 'Link Hover', 'noorgfx-component' ),
								'id' => 'link_hover',
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'builderSettings/has_transparent_header' => 'yes',
					'builderSettings/has_sticky_header' => 'yes',
					'row' => '!offcanvas',
				],
				'options' => [
					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Icons Color', 'noorgfx-component' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'contacts_icon_color',
						'label' => __('Default State', 'noorgfx-component')
					],

					[
						'id' => 'transparent_contacts_icon_color',
						'label' => __('Transparent State', 'noorgfx-component'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'sticky_contacts_icon_color',
						'label' => __('Sticky State', 'noorgfx-component'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'contacts_icon_color' => [
						'label' => __( 'Icons Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
								'inherit' => 'var(--theme-text-color)'
							],

							[
								'title' => __( 'Hover', 'noorgfx-component' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-link-hover-color)'
							],
						],
					],

					'transparent_contacts_icon_color' => [
						'label' => __( 'Icons Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx-component' ),
								'id' => 'hover',
							],
						],
					],

					'sticky_contacts_icon_color' => [
						'label' => __( 'Icons Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx-component' ),
								'id' => 'hover',
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'builderSettings/has_transparent_header' => 'yes',
					'builderSettings/has_sticky_header' => 'yes',
					'row' => '!offcanvas',
				],
				'options' => [
					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],
				],
			],


			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => [
					__('Icons Background Color', 'noorgfx-component') => [
						'contacts_icon_fill_type' => 'solid'
					],

					__('Icons Border Color', 'noorgfx-component') => [
						'contacts_icon_fill_type' => 'outline'
					]
				],
				'responsive' => true,
				'choices' => [
					[
						'id' => 'contacts_icon_background',
						'label' => __('Default State', 'noorgfx-component'),
						'condition' => [
							'contacts_icon_shape' => '!simple'
						],
					],

					[
						'id' => 'transparent_contacts_icon_background',
						'label' => __('Transparent State', 'noorgfx-component'),
						'condition' => [
							'row' => '!offcanvas',
							'contacts_icon_shape' => '!simple',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'sticky_contacts_icon_background',
						'label' => __('Sticky State', 'noorgfx-component'),
						'condition' => [
							'row' => '!offcanvas',
							'contacts_icon_shape' => '!simple',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'contacts_icon_background' => [
						'label' => [
							__('Icons Background Color', 'noorgfx-component') => [
								'contacts_icon_fill_type' => 'solid'
							],

							__('Icons Border Color', 'noorgfx-component') => [
								'contacts_icon_fill_type' => 'outline'
							]
						],
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'divider' => 'top',

						'value' => [
							'default' => [
								'color' => 'rgba(218, 222, 228, 0.5)',
							],

							'hover' => [
								'color' => 'rgba(218, 222, 228, 0.7)',
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx-component' ),
								'id' => 'hover',
							],
						],
					],

					'transparent_contacts_icon_background' => [
						'label' => [
							__('Icons Background Color', 'noorgfx-component') => [
								'contacts_icon_fill_type' => 'solid'
							],

							__('Icons Border Color', 'noorgfx-component') => [
								'contacts_icon_fill_type' => 'outline'
							]
						],
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'divider' => 'top',

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx-component' ),
								'id' => 'hover',
							],
						],
					],

					'sticky_contacts_icon_background' => [
						'label' => [
							__('Icons Background Color', 'noorgfx-component') => [
								'contacts_icon_fill_type' => 'solid'
							],

							__('Icons Border Color', 'noorgfx-component') => [
								'contacts_icon_fill_type' => 'outline'
							]
						],
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'divider' => 'top',

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx-component' ),
								'id' => 'hover',
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'contacts_margin' => [
				'label' => __( 'Margin', 'noorgfx-component' ),
				'type' => 'ct-spacing',
				'value' => noorgfx_spacing_value(),
				'responsive' => true
			],

		],
	],
];

