<?php

$popup_size = noorgfx_default_akg('popup_size', $atts, 'medium');

if ($popup_size === 'custom') {
	$popup_max_width = noorgfx_default_akg('popup_max_width', $atts, '400px');

	if ($popup_max_width !== '400px') {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector('', 'block:' . $id),
			'variableName' => 'popup-max-width',
			'unit' => '',
			'value' => $popup_max_width,
		]);
	}

	$popup_max_height = noorgfx_default_akg('popup_max_height', $atts, 'CT_CSS_SKIP_RULE');

	if ($popup_max_height !== 'CT_CSS_SKIP_RULE') {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector('', 'block:' . $id),
			'variableName' => 'popup-max-height',
			'unit' => '',
			'value' => $popup_max_height,
		]);

		$css->put(
			noorgfx_prefix_selector('', 'block:' . $id),
			'--popup-height: 100%'
		);
	}
}

$popup_entrance_value = noorgfx_default_akg('popup_entrance_value', $atts, 50);

if ($popup_entrance_value !== 50) {
	$css->put(
		noorgfx_prefix_selector('', 'block:' . $id),
		'--popup-entrance-value: ' . $popup_entrance_value . 'px'
	);
}

$popup_entrance_speed = noorgfx_default_akg('popup_entrance_speed', $atts, 0.3);

if ($popup_entrance_speed !== 0.3) {
	$css->put(
		noorgfx_prefix_selector('', 'block:' . $id),
		'--popup-entrance-speed: ' . $popup_entrance_speed . 's'
	);
}

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_prefix_selector('', 'block:' . $id),
	'property' => 'popup-padding',
	'value' => noorgfx_default_akg(
		'popup_padding',
		$atts,
		noorgfx_spacing_value()
	),
	'empty_value' => 30
]);

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_prefix_selector('', 'block:' . $id),
	'property' => 'popup-border-radius',
	'value' => noorgfx_default_akg(
		'popup_border_radius',
		$atts,
		noorgfx_spacing_value()
	),
	'empty_value' => 7
]);

noorgfx_output_box_shadow([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_prefix_selector('', 'block:' . $id),
	'value' => noorgfx_default_akg('popup_shadow', $atts, noorgfx_box_shadow_value([
		'enable' => true,
		'h_offset' => 0,
		'v_offset' => 10,
		'blur' => 20,
		'spread' => 0,
		'inset' => false,
		'color' => [
			'color' => 'rgba(41, 51, 61, 0.1)',
		],
	])),
	'variableName' => 'popup-box-shadow',
	'responsive' => true
]);

$popup_edges_offset = noorgfx_default_akg('popup_edges_offset', $atts, 25);

if ($popup_edges_offset !== 25) {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('', 'block:' . $id),
		'variableName' => 'popup-edges-offset',
		'value' => $popup_edges_offset
	]);
}

noorgfx_output_colors([
	'value' => noorgfx_akg('popup_close_button_color', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,

	'variables' => [
		'default' => [
			'selector' => noorgfx_prefix_selector(' .ct-toggle-close', 'block:' . $id),
			'variable' => 'theme-icon-color'
		],

		'hover' => [
			'selector' => noorgfx_prefix_selector(' .ct-toggle-close:hover', 'block:' . $id),
			'variable' => 'theme-icon-color'
		]
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_akg('popup_close_button_shape_color', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,

	'variables' => [
		'default' => [
			'selector' => noorgfx_prefix_selector(' .ct-toggle-close', 'block:' . $id),
			'variable' => 'toggle-button-background'
		],

		'hover' => [
			'selector' => noorgfx_prefix_selector(' .ct-toggle-close:hover', 'block:' . $id),
			'variable' => 'toggle-button-background'
		]
	],
]);

noorgfx_output_background_css([
	'selector' => noorgfx_prefix_selector(' .ct-popup-inner > article', 'block:' . $id),
	'css' => $css,
	'value' => noorgfx_default_akg(
		'popup_background',
		$atts,
		noorgfx_background_default_value([
			'backgroundColor' => [
				'default' => [
					'color' => '#ffffff'
				],
			],
		])
	)
]);

noorgfx_output_background_css([
	'selector' => noorgfx_prefix_selector('', 'block:' . $id),
	'css' => $css,
	'value' => noorgfx_default_akg('popup_backdrop_background', $atts,
	noorgfx_background_default_value([
		'backgroundColor' => [
			'default' => [
				'color' => 'CT_CSS_SKIP_RULE'
			],
		],
	])
	)
]);
