<?php

$options = [
	'has_inline_code_editor' => [
		'type' => 'hidden',
		'value' => 'no'
	],

	'conditions' => [
		'label' => __('Display Conditions', 'noorgfx-component'),
		'type' => 'noorgfx-display-condition',
		'sectionAttr' => [ 'class' => 'ct-content-blocks-conditions' ],
		'filter' => 'singular',
		'display' => 'modal',
		'modalTitle' => __('Template Display Conditions', 'noorgfx-component'),
		'modalDescription' => __('Choose where you want this template to be displayed.', 'noorgfx-component'),
		'value' => [
			[
				'type' => 'include',
				'rule' => 'singulars',
				'payload' => []
			]
		],

		'value' => [],
		'design' => 'block',
	],

	'template_subtype' => [
		'label' => __( 'Replacement Behavior', 'noorgfx-component' ),
		'type' => 'ct-radio',
		'value' => 'canvas',
		'view' => 'text',
		'design' => 'block',
		'divider' => 'top:full',
		'choices' => [
			'content' => __( 'Content Area', 'noorgfx-component' ),
			'canvas' => __( 'Full Page', 'noorgfx-component' ),
		]
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'template_subtype' => 'canvas' ],
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-title',
				'variation' => 'simple-small-heading',
				'label' => __( 'Page Structure', 'noorgfx-component' ),
			],

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx-component' ),
				'type' => 'tab',
				'options' => [
					'content_block_structure' => [
						'label' => false,
						'type' => 'ct-image-picker',
						'value' => 'type-4',
						'choices' => [
							'type-3' => [
								'src' => noorgfx_image_picker_url('narrow.svg'),
								'title' => __('Narrow Width', 'noorgfx-component'),
							],

							'type-4' => [
								'src' => noorgfx_image_picker_url('normal.svg'),
								'title' => __('Normal Width', 'noorgfx-component'),
							],

							'type-2' => [
								'src' => noorgfx_image_picker_url('left-single-sidebar.svg'),
								'title' => __('Left Sidebar', 'noorgfx-component'),
							],

							'type-1' => [
								'src' => noorgfx_image_picker_url('right-single-sidebar.svg'),
								'title' => __('Right Sidebar', 'noorgfx-component'),
							],
						],
					],

					'content_style' => [
						'label' => __('Content Area Style', 'noorgfx-component'),
						'type' => 'ct-radio',
						'value' => 'wide',
						'view' => 'text',
						'design' => 'block',
						'divider' => 'top',
						'responsive' => true,
						'choices' => [
							'wide' => __( 'Wide', 'noorgfx-component' ),
							'boxed' => __( 'Boxed', 'noorgfx-component' ),
						],
					],

					'content_block_spacing' => [
						'label' => __('Content Area Vel Spacing', 'noorgfx-component'),
						'type' => 'ct-radio',
						'value' => 'both',
						'divider' => 'top',
						'view' => 'text',
						'design' => 'block',
						'disableRevertButton' => true,
						'attr' => [ 'data-type' => 'content-spacing' ],
						'choice_attr' => [ 'data-tooltip-reveal' => 'top' ],
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [
							'both'   => '<span></span>
							<i class="ct-tooltip">' . __( 'Top & Bottom', 'noorgfx-component' ) . '</i>',

							'top'    => '<span></span>
							<i class="ct-tooltip">' . __( 'Only Top', 'noorgfx-component' ) . '</i>',

							'bottom' => '<span></span>
							<i class="ct-tooltip">' . __( 'Only Bottom', 'noorgfx-component' ) . '</i>',

							'none'   => '<span></span>
							<i class="ct-tooltip">' . __( 'Disabled', 'noorgfx-component' ) . '</i>',
						]
					],

				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx-component' ),
				'type' => 'tab',
				'options' => [

					noorgfx_get_options('single-elements/structure-design', [
						// 'has_background' => false
					])

				]
			],

		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => ['has_inline_code_editor' => 'no'],
		'options' => [
			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'previewedPost' => [
				'label' => __( 'Dynamic Content Preview', 'noorgfx-component' ),
				'type' => 'noorgfx-previewed-post',
				'value' => [
					'post_id' => '',
					'post_type' => 'post'
				],
				'desc' => __('Select a post/page to preview it\'s content inside the editor while building the post/page.', 'noorgfx-component'),
			],
		],
	],
];
