<?php

global $post;

$post_id = $post->ID;

$template_type = get_post_meta($post_id, 'template_type', true);

$hooks_manager = new \Noorgfx\HooksManager();

$choices = [];

foreach ($hooks_manager->get_all_hooks() as $hook) {
	$choices[] = array_merge([
		'key' => $hook['hook'],
		'value' => isset($hook['title']) ? $hook['title'] : $hook['hook']
	], isset($hook['group']) ? [
		'group' => $hook['group']
	] : []);
}

$choices[] = [
	'key' => 'custom_hook',
	'value' => 'Custom Hook',
	'group' => __('Other', 'noorgfx-component')
];

$options = [
	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx-component' ),
		'type' => 'tab',
		'options' => [

			[
				'has_inline_code_editor' => [
					'type' => 'hidden',
					'value' => 'no'
				],

				'has_content_block_structure' => [
					'label' => __( 'Container Structure', 'noorgfx-component' ),
					'type' => 'hidden',
					'value' => 'no',
					'design' => 'none'
				],
			],

			'conditions' => [
				'label' => __('Display Conditions', 'noorgfx-component'),
				'type' => 'noorgfx-display-condition',
				'sectionAttr' => [ 'class' => 'ct-content-blocks-conditions' ],
				'display' => 'modal',
				'modalTitle' => __('Popup Display Conditions', 'noorgfx-component'),
				'modalDescription' => __('Choose where you want this popup to be displayed.', 'noorgfx-component'),
				'value' => [
					[
						'type' => 'include',
						'rule' => 'singulars',
						'payload' => []
					]
				],

				'value' => [],
				'design' => 'block',
			],


			'popup_trigger_condition' => [
				'label' => __('Launch Trigger', 'noorgfx-component' ),
				'type' => 'ct-select',
				'value' => 'default',
				'design' => 'block',
				'divider' => 'top:full',
				'choices' => noorgfx_ordered_keys([
					'default' => __('None', 'noorgfx-component'),
					'scroll' => __('On scroll', 'noorgfx-component'),
					'element_reveal' => __('On scroll to element', 'noorgfx-component'),
					'element_click' => __('On element click', 'noorgfx-component'),
					'page_load' => __('On page load', 'noorgfx-component'),
					'after_inactivity' => __('After inactivity', 'noorgfx-component'),
					'after_x_time' => __('After x time', 'noorgfx-component'),
					'after_x_pages' => __('After x pages', 'noorgfx-component'),
					'exit_intent' => __('On page exit intent', 'noorgfx-component'),
				]),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'popup_trigger_condition' => 'element_reveal' ],
				'options' => [

					'scroll_to_element' => [
						'label' => __( 'Element Class', 'noorgfx-component' ),
						'type' => 'text',
						'design' => 'block',
						'value' => '',
						'attr' => ['placeholder' => '.my-element-class'],
						'sync' => 'live',
						'desc' => __('Separate each class by comma if you have multiple elements.', 'noorgfx-component' ),
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'popup_trigger_condition' => 'element_click' ],
				'options' => [

					'click_to_element' => [
						'label' => __( 'Element Class', 'noorgfx-component' ),
						'type' => 'text',
						'design' => 'block',
						'value' => '',
						'attr' => ['placeholder' => '.my-element-class'],
						'sync' => 'live',
						'desc' => __('Separate each class by comma if you have multiple elements.', 'noorgfx-component' ),
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'popup_trigger_condition' => 'scroll' ],
				'options' => [

					'scroll_direction' => [
						'label' => __('Scroll Direction', 'noorgfx-component' ),
						'type' => 'ct-select',
						'value' => 'down',
						'design' => 'block',
						'choices' => noorgfx_ordered_keys([
							'down' => __('Scroll Down', 'noorgfx-component'),
							'up' => __('Scroll Up', 'noorgfx-component')
						]),
					],

					'scroll_value' => [
						'label' => __( 'Scroll Distance', 'noorgfx-component' ),
						'type' => 'ct-slider',
						'value' => '200px',
						'design' => 'block',
						'units' => [
							[ 'unit' => 'px','min' => 0, 'max' => 5000 ],
							[ 'unit' => '%','min' => 0, 'max' => 100 ],
							[ 'unit' => 'vh', 'min' => 0, 'max' => 100 ],
						],
						'desc' => __('Set the scroll distance till the popup block will appear.', 'noorgfx-component' ),
					],

					'close_on_scroll_back' => [
						'label' => __('Close Popup On Scroll Back', 'noorgfx-component' ),
						'type' => 'ct-switch',
						'value' => 'no',
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'popup_trigger_condition' => 'after_inactivity' ],
				'options' => [

					'inactivity_value' => [
						'label' => __( 'Inactivity Time', 'noorgfx-component' ),
						'type' => 'ct-number',
						'design' => 'inline',
						'value' => 10,
						'min' => 0,
						'max' => 5000,
						'desc' => __('Set the inactivity time (in seconds) till the popup block will appear.', 'noorgfx-component' ),
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'popup_trigger_condition' => 'after_x_time' ],
				'options' => [

					'x_time_value' => [
						'label' => __( 'After X Time', 'noorgfx-component' ),
						'type' => 'ct-number',
						'design' => 'inline',
						'value' => 10,
						'min' => 0,
						'max' => 5000,
						'desc' => __('Set after how much time (in seconds) the popup block will appear.', 'noorgfx-component' ),
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'popup_trigger_condition' => 'after_x_pages' ],
				'options' => [

					'x_pages_value' => [
						'label' => __( 'After X Pages', 'noorgfx-component' ),
						'type' => 'ct-number',
						'design' => 'inline',
						'value' => 3,
						'min' => 1,
						'max' => 15,
						'desc' => __('Set after how many visited pages the popup block will appear.', 'noorgfx-component' ),
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'popup_trigger_condition' => '! default | element_click' ],
				'options' => [
					'popup_relaunch_strategy' => [
						'label' => __('Relaunch Trigger', 'noorgfx-component' ),
						'type' => 'ct-select',
						'value' => 'default',
						'design' => 'block',
						'divider' => 'top:full',
						'choices' => noorgfx_ordered_keys([
							'default' => __('Never relaunch', 'noorgfx-component'),
							'always' => __('Always relaunch', 'noorgfx-component'),
							'custom' => __('Custom interval', 'noorgfx-component'),
						]),
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'popup_relaunch_strategy' => 'custom' ],
						'options' => [
							'days_after_close_value' => [
								'label' => __( 'Days After Close', 'noorgfx-component' ),
								'type' => 'ct-timer',
								'design' => 'block',
								'value' => [
									'days' => 14,
									'hours' => 0,
									'minutes' => 0,
								],
								'desc' => __('Number of days before the popup will automatically relaunch again.', 'noorgfx-component'),
							],

							noorgfx_rand_md5() => [
								'type' => 'ct-migrate-values',
								'migrations' => [
									'popups_new_close_actions'
								],
								'options' => [
									noorgfx_rand_md5() => [
										'type' => 'ct-condition',
										'condition' => [
											'popup_custom_close' => 'yes'
										],
										'options' => [

											'days_after_success_value' => [
												'label' => [
													__('Days After Form Submit', 'noorgfx-component') => [
														'popup_custom_close_strategy' => 'form_submit'
													],

													__('Days After Button Click', 'noorgfx-component') => [
														'popup_custom_close_strategy' => 'button_click'
													]
												],
												'type' => 'ct-timer',
												'design' => 'block',
												'divider' => 'top',
												'value' => [
													'days' => 30,
													'hours' => 0,
													'minutes' => 0,
												],
												'desc' => __('Days before the popup relaunches after the additional close trigger is activated.', 'noorgfx-component'),
											]

										],
									],
								]
							]
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-title',
				'variation' => 'simple-small-heading',
				'label' => __( 'Close Actions', 'noorgfx-component' ),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-migrate-values',
				'migrations' => [
					'popups_new_close_actions'
				],
				'options' => [
					'popup_close_button' => [
						'label' => __( 'On Close Button Click', 'noorgfx-component' ),
						'type' => 'ct-switch',
						'value' => 'yes',
						// 'divider' => 'top:full',
						// 'desc' => __('Enable this option if you want to load the popup content using AJAX.', 'noorgfx-component' ),
					],

					'popup_close_with_esc' => [
						'label' => __( 'On ESC Button Press', 'noorgfx-component' ),
						'type' => 'ct-switch',
						'value' => 'yes'
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [
							'popup_backdrop_background/backgroundColor/default/color' => "!" . Noorgfx_Css_Injector::get_skip_rule_keyword()
						],
						'options' => [
							'popup_close_with_backdrop_click' => [
								'label' => __('On Backdrop Click', 'noorgfx-component'),
								'type' => 'ct-switch',
								'value' => 'yes'
							]
						]
					],

					'popup_custom_close' => [
						'label' => __( 'On Custom Action', 'noorgfx-component' ),
						'type' => 'ct-switch',
						'value' => 'no',
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => ['popup_custom_close' => 'yes'],
						'options' => [
							'popup_custom_close_strategy' => [
								'label' => false,
								'type' => 'ct-select',
								'value' => 'form_submit',
								'design' => 'block',
								'choices' => noorgfx_ordered_keys([
									'form_submit' => __('Form Submit', 'noorgfx-component'),
									'button_click' => __('Button click', 'noorgfx-component')
								]),
							],

							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => ['popup_custom_close_strategy' => 'button_click'],
								'options' => [
									'popup_custom_close_button_selector' => [
										'label' => __('Button Class Selector', 'noorgfx-component'),
										'type' => 'text',
										'value' => '',
										'attr' => ['placeholder' => '.my-element-class'],
										'desc' => __('Button class selector that will trigger popup to close.', 'noorgfx-component'),
									],
								]
							],

							'popup_custom_close_action_delay' => [
								'label' => __('Delay', 'noorgfx-component'),
								'type' => 'ct-number',
								'design' => 'inline',
								'value' => 0,
								'min' => 0,
								'max' => 1000,
								'step' => 0.1,
								'desc' => __('Close delay time (in seconds) after the form submit action is detected.', 'noorgfx-component'),
								'blockDecimal' => false
							],
						]
					],
				]
			],

			'popup_open_animation' => [
				'label' => __('Popup Animation', 'noorgfx-component' ),
				'type' => 'ct-select',
				'value' => 'fade-in',
				'design' => 'block',
				'divider' => 'top:full',
				'choices' => noorgfx_ordered_keys([
					'fade-in' => __('Fade in fade out', 'noorgfx-component'),
					'zoom-in' => __('Zoom in zoom out', 'noorgfx-component'),
					'slide-left' => __('Slide in from left', 'noorgfx-component'),
					'slide-right' => __('Slide in from right', 'noorgfx-component'),
					'slide-top' => __('Slide in from top', 'noorgfx-component'),
					'slide-bottom' => __('Slide in from bottom', 'noorgfx-component'),
				]),
			],

			'popup_entrance_speed' => [
				'label' => __( 'Animation Speed', 'noorgfx-component' ),
				'type' => 'ct-number',
				'design' => 'inline',
				'value' => 0.3,
				'min' => 0,
				'max' => 10,
				'step' => 0.1,
				'blockDecimal' => false
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'popup_open_animation' => 'slide-left|slide-right|slide-top|slide-bottom',
				],
				'options' => [

					'popup_entrance_value' => [
						'label' => __( 'Entrance Value', 'noorgfx-component' ),
						'type' => 'ct-number',
						'design' => 'inline',
						'value' => 50,
						'min' => 0,
						'max' => 500,
					],

				],
			],

			'load_content_with_ajax' => [
				'label' => __( 'Load Content With AJAX', 'noorgfx-component' ),
				'type' => 'ct-switch',
				'value' => 'no',
				'divider' => 'top:full',
				'desc' => __('Enable this option if you want to load the popup content using AJAX.', 'noorgfx-component' ),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => ['load_content_with_ajax' => 'yes'],
				'options' => [

					'fetch_popup_content' => [
						'label' => __('Reload Content', 'noorgfx-component' ),
						'type' => 'ct-radio',
						'value' => 'never',
						'view' => 'text',
						'design' => 'block',
						'divider' => 'top',
						'choices' => [
							'never' => __('Never', 'noorgfx-component'),
							'always' => __('Always', 'noorgfx-component')
						],
						'desc' => __('Set this option to always if you have dynamic content inside the popup in order to keep everything up to date.', 'noorgfx-component' ),
					],
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => ['has_inline_code_editor' => 'no'],
				'options' => [
					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],

					'previewedPost' => [
						'label' => __( 'Dynamic Content Preview', 'noorgfx-component' ),
						'type' => 'noorgfx-previewed-post',
						'value' => [
							'post_id' => '',
							'post_type' => 'post'
						],
						'desc' => __('Select a post/page to preview it\'s content inside the editor while building the popup.', 'noorgfx-component'),
					],
				],
			],

			'visibility' => [
				'label' => __( 'Popup Visibility', 'noorgfx-component' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'divider' => 'top:full',
				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),

				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx-component' ),
					'tablet' => __( 'Tablet', 'noorgfx-component' ),
					'mobile' => __( 'Mobile', 'noorgfx-component' ),
				]),
			],

		],

	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx-component' ),
		'type' => 'tab',
		'options' => [

			'popup_size' => [
				'label' => __('Popup Size', 'noorgfx-component' ),
				'type' => 'ct-select',
				'value' => 'medium',
				'design' => 'block',
				'divider' => 'top:full',
				'choices' => noorgfx_ordered_keys([
					'small' => __('Small Size', 'noorgfx-component'),
					'medium' => __('Medium Size', 'noorgfx-component'),
					'large' => __('Large Size', 'noorgfx-component'),
					'custom' => __('Custom Size', 'noorgfx-component'),
				]),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => ['popup_size' => 'custom'],
				'options' => [

					'popup_max_width' => [
						'label' => __( 'Max Width', 'noorgfx-component' ),
						'type' => 'ct-slider',
						'value' => '400px',
						'design' => 'block',
						'units' => [
							[ 'unit' => 'px','min' => 0, 'max' => 1500 ],
							[ 'unit' => 'vw', 'min' => 0, 'max' => 100 ],
							[ 'unit' => 'vh', 'min' => 0, 'max' => 100 ],
							[ 'unit' => 'em', 'min' => 0, 'max' => 100 ],
							[ 'unit' => 'rem', 'min' => 0, 'max' => 100 ],
						],
						'responsive' => true,
						'sync' => 'live'
					],

					'popup_max_height' => [
						'label' => __( 'Max Height', 'noorgfx-component' ),
						'type' => 'ct-slider',
						'value' => 'CT_CSS_SKIP_RULE',
						'design' => 'block',
						'units' => [
							[ 'unit' => 'px','min' => 0, 'max' => 1500 ],
							[ 'unit' => 'vw', 'min' => 0, 'max' => 100 ],
							[ 'unit' => 'vh', 'min' => 0, 'max' => 100 ],
							[ 'unit' => 'em', 'min' => 0, 'max' => 100 ],
							[ 'unit' => 'rem', 'min' => 0, 'max' => 100 ],
						],
						'responsive' => true,
						'sync' => 'live'
					],

				]
			],

			'popup_position' => [
				'label' => __('Popup Position', 'noorgfx-component' ),
				'type' => 'noorgfx-position',
				'value' => 'bottom:right',
				'design' => 'block',
				'divider' => 'top:full',
			],

			'popup_scroll_lock' => [
				'label' => __( 'Scroll Lock', 'noorgfx-component' ),
				'type' => 'ct-switch',
				'value' => 'no',
				'divider' => 'top:full',
				'desc' => __('Lock the page scroll while the popup is triggered/oppened.', 'noorgfx-component' ),
			],

			'popup_edges_offset' => [
				'label' => __( 'Popup Offset', 'noorgfx-component' ),
				'type' => 'ct-slider',
				'min' => 0,
				'max' => 300,
				'value' => 25,
				'responsive' => true,
				'divider' => 'top:full',
			],

			'popup_shadow' => [
				'label' => __( 'Shadow', 'noorgfx-component' ),
				'type' => 'ct-box-shadow',
				'divider' => 'top:full',
				'responsive' => true,
				'value' => noorgfx_box_shadow_value([
					'enable' => true,
					'h_offset' => 0,
					'v_offset' => 10,
					'blur' => 20,
					'spread' => 0,
					'inset' => false,
					'color' => [
						'color' => 'rgba(41, 51, 61, 0.1)',
					],
				])
			],

			'popup_padding' => [
				'label' => __( 'Padding', 'noorgfx-component' ),
				'type' => 'ct-spacing',
				'divider' => 'top:full',
				'value' => noorgfx_spacing_value(),
				'inputAttr' => [
					'placeholder' => '30'
				],
				'responsive' => true
			],

			'popup_border_radius' => [
				'label' => __( 'Border Radius', 'noorgfx-component' ),
				'sync' => 'live',
				'type' => 'ct-spacing',
				'divider' => 'top:full',
				'value' => noorgfx_spacing_value(),
				'inputAttr' => [
					'placeholder' => '7'
				],
				'min' => 0,
				'responsive' => true
			],

			'popup_container_overflow' => [
				'label' => __('Container Overflow', 'noorgfx-component'),
				'type' => 'ct-radio',
				'value' => 'scroll',
				'view' => 'text',
				'design' => 'block',
				'divider' => 'top:full',
				'choices' => [
					'hidden' => __( 'Hidden', 'noorgfx-component' ),
					'visible' => __( 'Visible', 'noorgfx-component' ),
					'scroll' => __('Scroll', 'noorgfx-component'),
				],
				'desc' => __('Control what happens to the content that is too big to fit into the popup.', 'noorgfx-component'),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'popup_close_button' => 'yes' ],
				'options' => [
					'close_button_type' => [
						'label' => __('Close Button Position', 'noorgfx-component'),
						'type' => 'ct-radio',
						'value' => 'outside',
						'view' => 'text',
						'design' => 'block',
						'divider' => 'top:full',
						'choices' => [
							'inside' => __('Inside', 'noorgfx-component'),
							'outside' => __( 'Outside', 'noorgfx-component' ),
						],
					],

					'popup_close_button_color' => [
						'label' => __( 'Close Icon Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
								'inherit' => 'rgba(255, 255, 255, 0.7)'
							],

							[
								'title' => __( 'Hover', 'noorgfx-component' ),
								'id' => 'hover',
								'inherit' => '#ffffff'
							],
						],
					],

					'popup_close_button_shape_color' => [
						'label' => __( 'Close Icon Background', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
								'inherit' => 'rgba(0, 0, 0, 0.5)'
							],

							[
								'title' => __( 'Hover', 'noorgfx-component' ),
								'id' => 'hover',
								'inherit' => 'rgba(0, 0, 0, 0.5)'
							],
						],
					],
				],
			],

			'popup_background' => [
				'label' => __( 'Popup Background', 'noorgfx-component' ),
				'type'  => 'ct-background',
				'design' => 'inline',
				'divider' => 'top:full',
				'value' => noorgfx_background_default_value([
					'backgroundColor' => [
						'default' => [
							'color' => '#ffffff'
						],
					],
				])
			],

			'popup_backdrop_background' => [
				'label' => __( 'Popup Backdrop Background', 'noorgfx-component' ),
				'type'  => 'ct-background',
				'design' => 'inline',
				'divider' => 'top:full',
				'has_no_color' => true,
				'default_inherit_color' => 'rgba(18, 21, 25, 0.5)',
				'value' => noorgfx_background_default_value([
					'backgroundColor' => [
						'default' => [
							'color' => 'CT_CSS_SKIP_RULE'
						],
					],
				])
			],

		],
	],
];

