<?php

$options = [
	'conditions' => [
		'label' => __('Display Conditions', 'noorgfx-component'),
		'type' => 'noorgfx-display-condition',
		'value' => [
			[
				'type' => 'include',
				'rule' => 'everywhere',
			]
		],
		'display' => 'modal',
		'filter' => 'maintenance-mode',
		'modalTitle' => __('Maintenance Block Display Conditions', 'noorgfx-component'),
		'modalDescription' => __('Add one or more conditions to display the Maintenance block.', 'noorgfx-component'),
		'design' => 'block',
	],

	'has_inline_code_editor' => [
		'type' => 'hidden',
		'value' => 'no'
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'has_inline_code_editor' => 'no' ],
		'options' => [
			'has_content_block_structure' => [
				'label' => __( 'Container Structure', 'noorgfx-component' ),
				'type' => 'hidden',
				'value' => 'yes',
				'design' => 'none'
			],
		]
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [
			'has_inline_code_editor' => 'no',
			'has_content_block_structure' => 'yes'
		],
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-title',
				'label' => __( 'Page Structure', 'noorgfx-component' ),
			],

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx-component' ),
				'type' => 'tab',
				'options' => [
					'content_block_structure' => [
						'label' => false,
						'type' => 'ct-image-picker',
						'value' => 'type-4',
						'choices' => [
							'type-3' => [
								'src' => noorgfx_image_picker_url('narrow.svg'),
								'title' => __('Narrow Width', 'noorgfx-component'),
							],

							'type-4' => [
								'src' => noorgfx_image_picker_url('normal.svg'),
								'title' => __('Normal Width', 'noorgfx-component'),
							],
						],
					],

					'content_style' => [
						'label' => __('Content Area Style', 'noorgfx-component'),
						'type' => 'ct-radio',
						'value' => 'wide',
						'view' => 'text',
						'design' => 'block',
						'divider' => 'top',
						'responsive' => true,
						'choices' => [
							'wide' => __( 'Wide', 'noorgfx-component' ),
							'boxed' => __( 'Boxed', 'noorgfx-component' ),
						],
					],

					'content_block_spacing' => [
						'label' => __('Content Area Vertical Spacing', 'noorgfx-component'),
						'type' => 'ct-radio',
						'value' => 'none',
						'divider' => 'top',
						'view' => 'text',
						'design' => 'block',
						'disableRevertButton' => true,
						'attr' => [ 'data-type' => 'content-spacing' ],
						'choice_attr' => [ 'data-tooltip-reveal' => 'top' ],
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [
							'both'   => '<span></span>
							<i class="ct-tooltip">' . __( 'Top & Bottom', 'noorgfx-component' ) . '</i>',

							'top'    => '<span></span>
							<i class="ct-tooltip">' . __( 'Only Top', 'noorgfx-component' ) . '</i>',

							'bottom' => '<span></span>
							<i class="ct-tooltip">' . __( 'Only Bottom', 'noorgfx-component' ) . '</i>',

							'none'   => '<span></span>
							<i class="ct-tooltip">' . __( 'Disabled', 'noorgfx-component' ) . '</i>',
						]
					],

				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx-component' ),
				'type' => 'tab',
				'options' => [

					noorgfx_get_options('single-elements/structure-design', [
						// 'has_background' => false
					])

				]
			],
		]
	],
];

