<?php

$hooks_manager = new \Noorgfx\HooksManager();

$choices = [];

$choices[] = [
	'key' => '',
	'value' => __('None', 'noorgfx-component')
];

foreach ($hooks_manager->get_all_hooks() as $hook) {
	$choices[] = array_merge([
		'key' => $hook['hook'],
		'value' => isset($hook['title']) ? $hook['title'] : $hook['hook']
	], isset($hook['group']) ? [
		'group' => $hook['group']
	] : []);
}

$choices[] = [
	'key' => 'custom_hook',
	'value' => __('Custom Hook', 'noorgfx-component'),
	'group' => __('Other', 'noorgfx-component')
];

$options = [
	[
		'has_inline_code_editor' => [
			// 'type' => 'ct-switch',
			'type' => 'hidden',
			'value' => 'no'
		],

		'conditions' => [
			'label' => __('Display Conditions', 'noorgfx-component'),
			'type' => 'noorgfx-display-condition',
			'sectionAttr' => [ 'class' => 'ct-content-blocks-conditions' ],
			'display' => 'modal',
			'modalTitle' => __('Content Block Display Conditions', 'noorgfx-component'),
			'modalDescription' => __('Choose where you want this content block to be displayed.', 'noorgfx-component'),

			'value' => [
				[
					'type' => 'include',
					'rule' => 'singulars',
					'payload' => []
				]
			],

			'filter' => 'content_block_hook',

			'value' => [],
			'design' => 'block',
			'divider' => 'bottom:full',
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-group',
			'label' => __( 'Location & Priority', 'noorgfx-component' ),
			'attr' => [ 'class' => 'ct-condition-location' ],
			'hasGroupRevertButton' => true,
			'options' => [

				noorgfx_rand_md5() => [
					'type' => 'ct-group',
					'label' => false,
					'options' => [

						'location' => [
							'label' => false,
							'type' => 'noorgfx-hooks-select',
							'value' => '',
							'design' => 'none',
							'defaultToFirstItem' => true,
							'choices' => $choices,
							'placeholder' => __('None', 'noorgfx-component'),
							'search' => true
						],

						'priority' => [
							'label' => false,
							'type' => 'ct-number',
							'value' => 10,
							'min' => 1,
							'max' => 100,
							'design' => 'none',
							'attr' => [ 'data-width' => 'full' ],
						],

					],

				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'location' => 'custom_hook' ],
					'options' => [
						'custom_location' => [
							'label' => __('Custom Hook', 'noorgfx-component'),
							'type' => 'text',
							'value' => '',
							// 'divider' => 'bottom',
							'wrapperAttr' => [ 'data-location' => 'custom-hook' ],
						],
					]
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'location' => 'noorgfx:single:content:paragraphs-number',
					],
					'options' => [
						'paragraphs_count' => [
							'label' => __('After Block Number', 'noorgfx-component'),
							'type' => 'ct-number',
							'value' => '3',
							'design' => 'inline',
							// 'divider' => 'bottom',
							// 'wrapperAttr' => [ 'data-location' => 'block' ],
							'attr' => [ 'data-width' => 'full' ],
						],
					]
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'location' => 'noorgfx:single:content:headings-number',
					],
					'options' => [
						'headings_count' => [
							'label' => __('Before Heading Number', 'noorgfx-component'),
							'type' => 'text',
							'value' => '3',
							'design' => 'inline',
							'attr' => [ 'data-width' => 'full' ],
						],
					]
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'location' => 'noorgfx:loop:card:cards-number',
					],
					'options' => [
						'cards_count' => [
							'label' => __('After Card Number', 'noorgfx-component'),
							'type' => 'ct-number',
							'value' => '3',
							'design' => 'inline',
							'attr' => [ 'data-width' => 'full' ],
						],

						'repeat_for_every_card' => [
							'label' => __('Repeat', 'noorgfx-component'),
							'type' => 'ct-switch',
							'value' => 'no',
							'design' => 'inline',
							'wrapperAttr' => [ 'data-location' => 'block' ],
						],
					]
				],

				'additional_locations' => [
					'type' => 'noorgfx-multiple-locations-select',
					'choices' => $choices,
					'design' => 'none',
					'value' => []
				],

			],
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [ 'has_inline_code_editor' => 'no' ],
			'options' => [
				'has_content_block_structure' => [
					'label' => __( 'Container Structure', 'noorgfx-component' ),
					'type' => 'ct-radio',
					'value' => 'no',
					'view' => 'text',
					'design' => 'block',
					'divider' => 'top:full',
					'choices' => [
						'no' => __( 'Default', 'noorgfx-component' ),
						'plain' => __( 'None', 'noorgfx-component' ),
						'yes' => __( 'Custom', 'noorgfx-component' ),
					],
				],
			]
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [
				'has_inline_code_editor' => 'no',
				'has_content_block_structure' => 'yes'
			],
			'options' => [
				noorgfx_rand_md5() => [
					'title' => __( 'General', 'noorgfx-component' ),
					'type' => 'tab',
					'options' => [
						'content_block_structure' => [
							'label' => false,
							'type' => 'ct-image-picker',
							'value' => 'type-4',
							'choices' => [
								'type-3' => [
									'src' => noorgfx_image_picker_url('narrow.svg'),
									'title' => __('Narrow Width', 'noorgfx-component'),
								],

								'type-4' => [
									'src' => noorgfx_image_picker_url('normal.svg'),
									'title' => __('Normal Width', 'noorgfx-component'),
								],
							],
						],

						'content_style' => [
							'label' => __('Content Area Style', 'noorgfx-component'),
							'type' => 'ct-radio',
							'value' => 'wide',
							'view' => 'text',
							'design' => 'block',
							'divider' => 'top',
							'responsive' => true,
							'choices' => [
								'wide' => __( 'Wide', 'noorgfx-component' ),
								'boxed' => __( 'Boxed', 'noorgfx-component' ),
							],
						],

						'content_block_spacing' => [
							'label' => __('Content Area Vertical Spacing', 'noorgfx-component'),
							'type' => 'ct-radio',
							'value' => 'both',
							'divider' => 'top',
							'view' => 'text',
							'design' => 'block',
							'disableRevertButton' => true,
							'attr' => [ 'data-type' => 'content-spacing' ],
							'choice_attr' => [ 'data-tooltip-reveal' => 'top' ],
							'setting' => [ 'transport' => 'postMessage' ],
							'choices' => [
								'both'   => '<span></span>
								<i class="ct-tooltip">' . __( 'Top & Bottom', 'noorgfx-component' ) . '</i>',

								'top'    => '<span></span>
								<i class="ct-tooltip">' . __( 'Only Top', 'noorgfx-component' ) . '</i>',

								'bottom' => '<span></span>
								<i class="ct-tooltip">' . __( 'Only Bottom', 'noorgfx-component' ) . '</i>',

								'none'   => '<span></span>
								<i class="ct-tooltip">' . __( 'Disabled', 'noorgfx-component' ) . '</i>',
							]
						],

					],
				],

				noorgfx_rand_md5() => [
					'title' => __( 'Design', 'noorgfx-component' ),
					'type' => 'tab',
					'options' => [

						noorgfx_get_options('single-elements/structure-design', [
							// 'has_background' => false
						])

					]
				],
			]
		],


		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [ 'has_inline_code_editor' => 'no' ],
			'options' => [
				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],
			]
		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => ['has_inline_code_editor' => 'no'],
		'options' => [

			'previewedPost' => [
				'label' => __( 'Dynamic Content Preview', 'noorgfx-component' ),
				'type' => 'noorgfx-previewed-post',
				'value' => [
					'post_id' => '',
					'post_type' => 'post'
				],
				'desc' => __('Select a post/page to preview it\'s content inside the editor while building the hook.', 'noorgfx-component'),
			],
		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [
			'has_inline_code_editor' => 'no',
			'has_content_block_structure' => '!plain'
		],
		'options' => [
			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'visibility' => [
				'label' => __( 'Visibility', 'noorgfx-component' ),
				'type' => 'ct-visibility',
				'design' => 'block',

				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),

				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx-component' ),
					'tablet' => __( 'Tablet', 'noorgfx-component' ),
					'mobile' => __( 'Mobile', 'noorgfx-component' ),
				]),
			],

			'custom_class' => [
				'label' => __('Custom Class', 'noorgfx'),
				'type' => 'text',
				'value' => '',
				'desc' => __('Separate multiple classes with spaces.', 'noorgfx-component'),
				'divider' => 'top:full',
			],

			'custom_attributes' => [
				'label' => __('Custom Attribute', 'noorgfx'),
				'type' => 'text',
				'value' => '',
				'desc' => __('Separate multiple attributes with spaces.', 'noorgfx-component'),
				'divider' => 'top',
			],
		]
	],
];

