<?php

$hooks_manager = new \Noorgfx\HooksManager();

$choices = [];

foreach ($hooks_manager->get_all_hooks() as $hook) {
	$choices[] = array_merge([
		'key' => $hook['hook'],
		'value' => isset($hook['title']) ? $hook['title'] : $hook['hook']
	], isset($hook['group']) ? [
		'group' => $hook['group']
	] : []);
}

$choices[] = [
	'key' => 'custom_hook',
	'value' => 'Custom Hook',
	'group' => __('Other', 'noorgfx-component')
];

$options = [
	[
		'has_inline_code_editor' => [
			// 'type' => 'ct-switch',
			'type' => 'hidden',
			'value' => 'no'
		],

		'conditions' => [
			'label' => __('Display Conditions', 'noorgfx-component'),
			'type' => 'noorgfx-display-condition',
			'sectionAttr' => [ 'class' => 'ct-content-blocks-conditions' ],
			'display' => 'modal',
			'modalTitle' => __('Template Display Conditions', 'noorgfx-component'),
			'modalDescription' => __('Choose where you want this template to be displayed.', 'noorgfx-component'),
			'value' => [
				[
					'type' => 'include',
					'rule' => 'singulars',
					'payload' => []
				]
			],

			'value' => [],
			'design' => 'block',
			'divider' => 'bottom:full'
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [ 'has_inline_code_editor' => 'no' ],
			'options' => [
				'has_content_block_structure' => [
					'label' => __( 'Container Structure', 'noorgfx-component' ),
					'type' => "hidden",
					'value' => 'yes',
					'design' => 'inline'
				],
			]
		],
	],

	[
		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [
				'has_inline_code_editor' => 'no',
				'has_content_block_structure' => 'yes'
			],
			'options' => [
				noorgfx_rand_md5() => [
					'title' => __( 'General', 'noorgfx-component' ),
					'type' => 'tab',
					'options' => [
						'content_block_structure' => [
							'label' => false,
							'type' => 'ct-image-picker',
							'value' => 'type-4',
							'choices' => [
								'type-3' => [
									'src' => noorgfx_image_picker_url('narrow.svg'),
									'title' => __('Narrow Width', 'noorgfx-component'),
								],

								'type-4' => [
									'src' => noorgfx_image_picker_url('normal.svg'),
									'title' => __('Normal Width', 'noorgfx-component'),
								],
							],
						],

						'content_style' => [
							'label' => __('Content Area Style', 'noorgfx-component'),
							'type' => 'ct-radio',
							'value' => 'wide',
							'view' => 'text',
							'design' => 'block',
							'divider' => 'top',
							'responsive' => true,
							'choices' => [
								'wide' => __( 'Wide', 'noorgfx-component' ),
								'boxed' => __( 'Boxed', 'noorgfx-component' ),
							],
						],

						'content_block_spacing' => [
							'label' => __('Content Area Vertical Spacing', 'noorgfx-component'),
							'type' => 'ct-radio',
							'value' => 'both',
							'divider' => 'top',
							'view' => 'text',
							'design' => 'block',
							'disableRevertButton' => true,
							'attr' => [ 'data-type' => 'content-spacing' ],
							'choice_attr' => [ 'data-tooltip-reveal' => 'top' ],
							'setting' => [ 'transport' => 'postMessage' ],
							'choices' => [
								'both'   => '<span></span>
								<i class="ct-tooltip">' . __( 'Top & Bottom', 'noorgfx-component' ) . '</i>',

								'top'    => '<span></span>
								<i class="ct-tooltip">' . __( 'Only Top', 'noorgfx-component' ) . '</i>',

								'bottom' => '<span></span>
								<i class="ct-tooltip">' . __( 'Only Bottom', 'noorgfx-component' ) . '</i>',

								'none'   => '<span></span>
								<i class="ct-tooltip">' . __( 'Disabled', 'noorgfx-component' ) . '</i>',
							]
						],

					],
				],

				noorgfx_rand_md5() => [
					'title' => __( 'Design', 'noorgfx-component' ),
					'type' => 'tab',
					'options' => [

						noorgfx_get_options('single-elements/structure-design', [
							// 'has_background' => false
						])

					]
				],
			]
		],


		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [ 'has_inline_code_editor' => 'no' ],
			'options' => [
				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],
			]
		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'has_inline_code_editor' => 'no' ],
		'options' => [
			'visibility' => [
				'label' => __( 'Visibility', 'noorgfx-component' ),
				'type' => 'ct-visibility',
				'design' => 'block',

				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),

				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx-component' ),
					'tablet' => __( 'Tablet', 'noorgfx-component' ),
					'mobile' => __( 'Mobile', 'noorgfx-component' ),
				]),
			],
		]
	],
];

