<?php

namespace Noorgfx;

class HooksManager {
	public function get_all_hooks() {
		return array_merge([
			[
				'type' => 'action',
				'hook' => 'wp_head',
				'title' => __('WP head', 'noorgfx-component'),
				// 'visual' => false,
				'group' => __('Head', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:head:start',
				'title' => __('WP head start', 'noorgfx-component'),
				// 'visual' => false,
				'group' => __('Head', 'noorgfx-component'),
				'attr' => ['data-type' => 'full:top-margin'],
				'priority' => 15
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:head:end',
				'title' => __('WP head end', 'noorgfx-component'),
				// 'visual' => false,
				'group' => __('Head', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'wp_body_open',
				'title' => __('WP body open', 'noorgfx-component'),
				// 'visual' => false,
				'group' => __('Head', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:header:before',
				'title' => __('Header before', 'noorgfx-component'),
				// 'visual' => false,
				'group' => __('Header', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:header:after',
				'title' => __('Header after', 'noorgfx-component'),
				// 'visual' => false,
				'group' => __('Header', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:header:offcanvas:desktop:top',
				'title' => __('Desktop top', 'noorgfx-component'),
				// 'visual' => false,
				'group' => __('Header offcanvas', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:header:offcanvas:desktop:bottom',
				'title' => __('Desktop bottom', 'noorgfx-component'),
				// 'visual' => false,
				'group' => __('Header offcanvas', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:header:offcanvas:mobile:top',
				'title' => __('Mobile top', 'noorgfx-component'),
				// 'visual' => false,
				'group' => __('Header offcanvas', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:header:offcanvas:mobile:bottom',
				'title' => __('Mobile bottom', 'noorgfx-component'),
				// 'visual' => false,
				'group' => __('Header offcanvas', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:sidebar:before',
				'title' => __('Sidebar before', 'noorgfx-component'),
				'group' => __('Left/Right sidebar', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:sidebar:start',
				'title' => __('Sidebar start', 'noorgfx-component'),
				'group' => __('Left/Right sidebar', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:sidebar:end',
				'title' => __('Sidebar end', 'noorgfx-component'),
				'group' => __('Left/Right sidebar', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:sidebar:after',
				'title' => __('Sidebar after', 'noorgfx-component'),
				'group' => __('Left/Right sidebar', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'dynamic_sidebar_before',
				'title' => __('Dynamic sidebar before', 'noorgfx-component'),
				'group' => __('All widget areas', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'dynamic_sidebar',
				'title' => __('Dynamic sidebar', 'noorgfx-component'),
				'group' => __('All widget areas', 'noorgfx-component')
			],


			[
				'type' => 'action',
				'hook' => 'dynamic_sidebar_after',
				'title' => __('Dynamic sidebar after', 'noorgfx-component'),
				'group' => __('All widget areas', 'noorgfx-component')
			],


			// page post title
			[
				'type' => 'action',
				'hook' => 'noorgfx:hero:before',
				'title' => __('Before section', 'noorgfx-component'),
				'group' => __('Page/post title', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:hero:title:before',
				'title' => __('Before title', 'noorgfx-component'),
				'group' => __('Page/post title', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:hero:description:before',
				'title' => __('Before description', 'noorgfx-component'),
				'group' => __('Page/post title', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:hero:breadcrumbs:before',
				'title' => __('Before breadcrumbs', 'noorgfx-component'),
				'group' => __('Page/post title', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:hero:custom_meta:before',
				'title' => __('Before post meta', 'noorgfx-component'),
				'group' => __('Page/post title', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:hero:custom_meta:first:before',
				'title' => __('Before first post meta', 'noorgfx-component'),
				'group' => __('Page/post title', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:hero:custom_meta:second:before',
				'title' => __('Before second post meta', 'noorgfx-component'),
				'group' => __('Page/post title', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:hero:title:after',
				'title' => __('After title', 'noorgfx-component'),
				'group' => __('Page/post title', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:hero:description:after',
				'title' => __('After description', 'noorgfx-component'),
				'group' => __('Page/post title', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:hero:breadcrumbs:after',
				'title' => __('After breadcrumbs', 'noorgfx-component'),
				'group' => __('Page/post title', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:hero:custom_meta:first:after',
				'title' => __('After first post meta', 'noorgfx-component'),
				'group' => __('Page/post title', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:hero:custom_meta:second:after',
				'title' => __('After second post meta', 'noorgfx-component'),
				'group' => __('Page/post title', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:hero:custom_meta:after',
				'title' => __('After post meta', 'noorgfx-component'),
				'group' => __('Page/post title', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:hero:after',
				'title' => __('After section', 'noorgfx-component'),
				'group' => __('Page/post title', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:content:before',
				'title' => __('Before content', 'noorgfx-component'),
				'group' => __('Content', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:content:top',
				'title' => __('Top content', 'noorgfx-component'),
				'group' => __('Content', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:content:bottom',
				'title' => __('Bottom content', 'noorgfx-component'),
				'group' => __('Content', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:content:after',
				'title' => __('After content', 'noorgfx-component'),
				'group' => __('Content', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:comments:before',
				'title' => __('Before comments', 'noorgfx-component'),
				'group' => __('Comments', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:comments:top',
				'title' => __('Top comments', 'noorgfx-component'),
				'group' => __('Comments', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:comments:title:before',
				'title' => __('Before title', 'noorgfx-component'),
				'group' => __('Comments', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:comments:title:after',
				'title' => __('After title', 'noorgfx-component'),
				'group' => __('Comments', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:comments:bottom',
				'title' => __('Bottom comments', 'noorgfx-component'),
				'group' => __('Comments', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:comments:after',
				'title' => __('After comments', 'noorgfx-component'),
				'group' => __('Comments', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:single:related_posts:before',
				'title' => __('Before related posts', 'noorgfx-component'),
				'group' => __('Related posts', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:single:related_posts:top',
				'title' => __('Related posts top', 'noorgfx-component'),
				'group' => __('Related posts', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:single:related_posts:title:before',
				'title' => __('Before title', 'noorgfx-component'),
				'group' => __('Related posts', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:single:related_posts:title:after',
				'title' => __('After title', 'noorgfx-component'),
				'group' => __('Related posts', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:single:related_posts:card:top',
				'title' => __('Card top', 'noorgfx-component'),
				'group' => __('Related posts', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:single:related_posts:featured_image:before',
				'title' => __('Before featured image', 'noorgfx-component'),
				'group' => __('Related posts', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:single:related_posts:featured_image:after',
				'title' => __('After featured image', 'noorgfx-component'),
				'group' => __('Related posts', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:single:related_posts:card:bottom',
				'title' => __('Card bottom', 'noorgfx-component'),
				'group' => __('Related posts', 'noorgfx-component')
			],


			[
				'type' => 'action',
				'hook' => 'noorgfx:single:related_posts:bottom',
				'title' => __('Related posts bottom', 'noorgfx-component'),
				'group' => __('Related posts', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:single:related_posts:after',
				'title' => __('After related posts', 'noorgfx-component'),
				'group' => __('Related posts', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:loop:before',
				'title' => __('Before', 'noorgfx-component'),
				'group' => __('Loop', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:loop:after',
				'title' => __('After', 'noorgfx-component'),
				'group' => __('Loop', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:loop:card:start',
				'title' => __('Start', 'noorgfx-component'),
				'group' => __('Loop card', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:loop:card:end',
				'title' => __('End', 'noorgfx-component'),
				'group' => __('Loop card', 'noorgfx-component')
			],

			[
				'type' => 'dynamic',
				'hook' => 'noorgfx:loop:card:cards-number',
				'title' => __('After certain number of cards', 'noorgfx-component'),
				'group' => __('Loop card', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:single:top',
				'title' => __('Top', 'noorgfx-component'),
				'group' => __('Single Post', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:single:content:top',
				'title' => __('Top content', 'noorgfx-component'),
				'group' => __('Single Post', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'dynamic',
				'hook' => 'noorgfx:single:content:paragraphs-number',
				'title' => __('After certain number of blocks', 'noorgfx-component'),
				'group' => __('Single Post', 'noorgfx-component')
			],

			[
				'type' => 'dynamic',
				'hook' => 'noorgfx:single:content:headings-number',
				'title' => __('Before certain number of headings', 'noorgfx-component'),
				'group' => __('Single Post', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:single:content:bottom',
				'title' => __('Bottom content', 'noorgfx-component'),
				'group' => __('Single Post', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:single:bottom',
				'title' => __('Bottom', 'noorgfx-component'),
				'group' => __('Single Post', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'woocommerce_login_form_start',
				'title' => __('Login form start', 'noorgfx-component'),
				'group' => __('Auth forms', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'woocommerce_login_form_end',
				'title' => __('Login form end', 'noorgfx-component'),
				'group' => __('Auth forms', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:account:modal:login:start',
				'title' => __('Login form modal start', 'noorgfx-component'),
				'group' => __('Auth forms', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:account:modal:login:end',
				'title' => __('Login form modal end', 'noorgfx-component'),
				'group' => __('Auth forms', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'woocommerce_register_form_start',
				'title' => __('Register form start', 'noorgfx-component'),
				'group' => __('Auth forms', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'woocommerce_register_form_end',
				'title' => __('Register form end', 'noorgfx-component'),
				'group' => __('Auth forms', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:account:modal:register:start',
				'title' => __('Register form modal start', 'noorgfx-component'),
				'group' => __('Auth forms', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:account:modal:register:end',
				'title' => __('Register form modal end', 'noorgfx-component'),
				'group' => __('Auth forms', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:account:modal:lostpassword:start',
				'title' => __('Lost password form modal start', 'noorgfx-component'),
				'group' => __('Auth forms', 'noorgfx-component')
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:account:modal:lostpassword:end',
				'title' => __('Lost password form modal end', 'noorgfx-component'),
				'group' => __('Auth forms', 'noorgfx-component')
			],
		],

		$this->get_grouped([
			[
				'hook' => 'woocommerce_before_main_content',
				'title' => __('Before main content', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'hook' => 'woocommerce_after_main_content',
				'title' => __('After main content', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'hook' => 'noorgfx:pro:woo-extra:offcanvas-filters:top',
				'title' => __('Offcanvas Filters - Top', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'hook' => 'noorgfx:pro:woo-extra:offcanvas-filters:bottom',
				'title' => __('Offcanvas Filters - Bottom', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'hook' => 'noorgfx:pro:woo-extra:offcanvas:minicart:empty',
				'title' => __('Offcanvas Cart - Empty State', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'hook' => 'noorgfx:pro:woo-extra:offcanvas:minicart:list:after',
				'title' => __('Offcanvas Cart - List After', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			]
		], __('WooCommerce Global', 'noorgfx-component')),

		$this->get_grouped(apply_filters('noorgfx:hooks-manager:woocommerce-archive-hooks', [
			[
				'hook' => 'woocommerce_archive_description',
				'title' => __('Archive description', 'noorgfx-component')
			],

			[
				'hook' => 'woocommerce_before_shop_loop',
				'title' => __('Before shop loop', 'noorgfx-component')
			],

			/*
			[
				'hook' => 'woocommerce_before_shop_loop_item_title',
				'title' => __('Before shop loop item title', 'noorgfx-component')
			],

			[
				'hook' => 'woocommerce_after_shop_loop_item_title',
				'title' => __('After shop loop item title', 'noorgfx-component')
			],
			 */

			[
				'hook' => 'noorgfx:woocommerce:product-card:title:before',
				'title' => __('Before shop loop item title', 'noorgfx-component')
			],

			[
				'hook' => 'noorgfx:woocommerce:product-card:title:after',
				'title' => __('After shop loop item title', 'noorgfx-component')
			],

			[
				'hook' => 'noorgfx:woocommerce:product-card:price:before',
				'title' => __('Before shop loop item price', 'noorgfx-component')
			],

			[
				'hook' => 'noorgfx:woocommerce:product-card:price:after',
				'title' => __('After shop loop item price', 'noorgfx-component')
			],

			[
				'hook' => 'noorgfx:woocommerce:product-card:actions:before',
				'title' => __('Before shop loop item actions', 'noorgfx-component')
			],

			[
				'hook' => 'noorgfx:woocommerce:product-card:actions:after',
				'title' => __('After shop loop item actions', 'noorgfx-component')
			],

			[
				'hook' => 'woocommerce_after_shop_loop',
				'title' => __('After shop loop', 'noorgfx-component')
			],
		]), __('WooCommerce Archive', 'noorgfx-component')),

		$this->get_grouped([
			[
				'hook' => 'woocommerce_before_single_product',
				'title' => __('Before single product', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			/*
			[
				'hook' => 'woocommerce_before_single_product_summary',
				'title' => __('Before single product summary', 'noorgfx-component')
			],

			[
				'hook' => 'woocommerce_single_product_summary',
				'title' => __('Single product summary', 'noorgfx-component')
			],
			 */

			[
				'hook' => 'woocommerce_product_meta_start',
				'title' => __('Product meta start', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_product_meta_end',
				'title' => __('Product meta end', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_share',
				'title' => __('Share', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_after_single_product',
				'title' => __('After single product', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'hook' => 'noorgfx:woocommerce:product-single:excerpt:before',
				'title' => __('Before single product excerpt', 'noorgfx-component')
			],

			[
				'hook' => 'noorgfx:woocommerce:product-single:excerpt:after',
				'title' => __('After single product excerpt', 'noorgfx-component')
			],

			[
				'hook' => 'noorgfx:woocommerce:product-single:tabs:before',
				'title' => __('Before single product tabs', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'hook' => 'noorgfx:woocommerce:product-single:tabs:after',
				'title' => __('After single product tabs', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'hook' => 'noorgfx:woocommerce:product-gallery:before',
				'title' => __('Before single product gallery', 'noorgfx-component')
			],

			[
				'hook' => 'noorgfx:woocommerce:product-gallery:after',
				'title' => __('After single product gallery', 'noorgfx-component')
			],

			[
				'hook' => 'noorgfx:woocommerce:product-single:add_to_cart:before',
				'title' => __('Before single product "Add to cart" button', 'noorgfx-component')
			],

			[
				'hook' => 'noorgfx:woocommerce:product-single:add_to_cart:after',
				'title' => __('After single product "Add to cart" button', 'noorgfx-component')
			],

			[
				'hook' => 'noorgfx:woocommerce:product-single:meta:before',
				'title' => __('Before single product meta', 'noorgfx-component')
			],

			[
				'hook' => 'noorgfx:woocommerce:product-single:meta:after',
				'title' => __('After single product meta', 'noorgfx-component')
			],

		], __('WooCommerce Single Product', 'noorgfx-component')),

		$this->get_grouped([
			[
				'hook' => 'woocommerce_cart_is_empty',
				'title' => __('Cart is empty', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_before_cart',
				'title' => __('Before cart', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_before_cart_table',
				'title' => __('Before cart table', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_before_cart_contents',
				'title' => __('Before cart contents', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_cart_contents',
				'title' => __('Cart contents', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_after_cart_contents',
				'title' => __('After cart contents', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_cart_coupon',
				'title' => __('Cart coupon', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_cart_actions',
				'title' => __('Cart actions', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_after_cart_table',
				'title' => __('After cart table', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_cart_collaterals',
				'title' => __('Cart collaterals', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_before_cart_totals',
				'title' => __('Before cart totals', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_cart_totals_before_order_total',
				'title' => __('Cart totals before order total', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_cart_totals_after_order_total',
				'title' => __('Cart totals after order total', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_proceed_to_checkout',
				'title' => __('Proceed to checkout', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_after_cart_totals',
				'title' => __('After cart totals', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_after_cart',
				'title' => __('After cart', 'noorgfx-component')
			],

			[
				'hook' => 'woocommerce_before_mini_cart',
				'title' => __('Before Mini Cart', 'noorgfx-component')
			],

			[
				'hook' => 'woocommerce_before_mini_cart_contents',
				'title' => __('Before Mini Cart Contents', 'noorgfx-component')
			],

			[
				'hook' => 'woocommerce_mini_cart_contents',
				'title' => __('Mini Cart Contents', 'noorgfx-component')
			],

			[
				'hook' => 'woocommerce_widget_shopping_cart_before_buttons',
				'title' => __('Widget Shopping Cart Before Buttons', 'noorgfx-component')
			],

			[
				'hook' => 'woocommerce_widget_shopping_cart_after_buttons',
				'title' => __('Widget Shopping Cart After Buttons', 'noorgfx-component')
			],

			[
				'hook' => 'woocommerce_after_mini_cart',
				'title' => __('After Mini Cart', 'noorgfx-component')
			],
		], __('WooCommerce Cart', 'noorgfx-component')),


		$this->get_grouped([
			[
				'hook' => 'woocommerce_before_checkout_form',
				'title' => __('Before checkout form', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_checkout_before_customer_details',
				'title' => __('Before customer details', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_checkout_after_customer_details',
				'title' => __('After customer details', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_checkout_billing',
				'title' => __('Checkout billing', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_before_checkout_billing_form',
				'title' => __('Before checkout billing form', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_after_checkout_billing_form',
				'title' => __('After checkout billing form', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_before_order_notes',
				'title' => __('Before order notes', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_after_order_notes',
				'title' => __('After order notes', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_checkout_shipping',
				'title' => __('Checkout shipping', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_checkout_before_order_review',
				'title' => __('Checkout before order review', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_checkout_order_review',
				'title' => __('Checkout order review', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_review_order_before_cart_contents',
				'title' => __('Review order before cart contents', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_review_order_after_cart_contents',
				'title' => __('Review order after cart contents', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_review_order_before_order_total',
				'title' => __('Review order before order total', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_review_order_after_order_total',
				'title' => __('Review order after order total', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_review_order_before_payment',
				'title' => __('Review order before payment', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_review_order_before_submit',
				'title' => __('Review order before submit', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_review_order_after_submit',
				'title' => __('Review order after submit', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_review_order_after_payment',
				'title' => __('Review order after payment', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_checkout_after_order_review',
				'title' => __('Checkout after order review', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_after_checkout_form',
				'title' => __('After checkout form', 'noorgfx-component')
			],

		], __('WooCommerce Checkout', 'noorgfx-component')),


		$this->get_grouped([
			[
				'hook' => 'woocommerce_before_my_account',
				'title' => __('Before my account', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_before_account_navigation',
				'title' => __('Before account navigation', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_account_navigation',
				'title' => __('Account navigation', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_after_account_navigation',
				'title' => __('After account navigation', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_account_content',
				'title' => __('Account content', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_account_dashboard',
				'title' => __('Account dashboard', 'noorgfx-component')
			],
			[
				'hook' => 'woocommerce_after_my_account',
				'title' => __('After my account', 'noorgfx-component')
			],
		], __('WooCommerce Account', 'noorgfx-component')),


		$this->get_grouped([
			[
				'hook' => 'noorgfx:ext:woocommerce-extra:added-to-cart:product:before',
				'title' => __('Added to Cart: Before product', 'noorgfx-component')
			],
			[
				'hook' => 'noorgfx:ext:woocommerce-extra:added-to-cart:actions:before',
				'title' => __('Added to Cart: Before actions', 'noorgfx-component')
			],
			[
				'hook' => 'noorgfx:ext:woocommerce-extra:added-to-cart:suggested_products:before',
				'title' => __('Added to Cart: Before suggested products', 'noorgfx-component')
			],
			[
				'hook' => 'noorgfx:ext:woocommerce-extra:added-to-cart:suggested_products:after',
				'title' => __('Added to Cart: After suggested products', 'noorgfx-component')
			],
		], __('WooCommerce: Added to Cart', 'noorgfx-component')),

		[
			[
				'type' => 'action',
				'hook' => 'wp_footer',
				'title' => __('WP footer', 'noorgfx-component'),
				'group' => __('Footer', 'noorgfx-component'),
				'attr' => ['data-type' => 'full:bottom-margin']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:footer:before',
				'title' => __('Footer before', 'noorgfx-component'),
				'group' => __('Footer', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			],

			[
				'type' => 'action',
				'hook' => 'noorgfx:footer:after',
				'title' => __('Footer after', 'noorgfx-component'),
				'group' => __('Footer', 'noorgfx-component'),
				'attr' => ['data-type' => 'full']
			]
        ],
		);
	}

	public function humanize_locations($locations) {
		$result = [];

		foreach ($locations as $location) {
			$name = null;

			if ($location['location'] === 'custom_hook') {
				$name = blc_safe_sprintf(
					__('Custom Hook (%s)', 'noorgfx-component'),
					$location['custom_location']
				);
			}

			if ($location['location'] === 'noorgfx:single:content:paragraphs-number') {
				$name = __('After Block Number', 'noorgfx-component') . ' ' . $location[
					'paragraphs_count'
				];
			}

			if ($location['location'] === 'noorgfx:single:content:headings-number') {
				$name = __('Before Heading Number', 'noorgfx-component') . ' ' . $location[
					'headings_count'
				];
			}

			if (! $name) {
				$maybe_descriptor = $this->find_location_descriptor(
					$location['location']
				);

				if ($maybe_descriptor) {
					$name = $maybe_descriptor['title'];
				}
			}

			if (! $name) {
				$name = $location['location'];
			}

			$result[] = $name;
		}

		return $result;
	}

	private function find_location_descriptor($hook) {
		$all = $this->get_all_hooks();

		foreach ($all as $single_hook) {
			if ($single_hook['hook'] === $hook) {
				return $single_hook;
			}
		}

		return null;
	}

	private function get_grouped($items, $group = null) {
		$result = [];

		foreach ($items as $item) {
			$attr = [];
			$priority = 10;

			if (isset($item['attr'])) {
				$attr = $item['attr'];
			}

			if (isset($item['priority'])) {
				$priority = $item['priority'];
			}

			if (is_array($item)) {
				$result[] = array_merge([
					'type' => 'action',
					'attr' => $attr,
					'priority' => $priority,
					'hook' => $item['hook'],
					'title' => $item['title'],
				], $group ? ['group' => $group] : []);
			} else {
				$result[] = array_merge([
					'type' => 'action',
					'attr' => $attr,
					'priority' => $priority,
					'hook' => $item,
					'title' => $item,
				], $group ? ['group' => $group] : []);
			}
		}

		return $result;
	}
}

