<?php

if (! isset($option_design)) {
	$option_design = false;
}

$color_options = [
	'color_type' => [
		'label' => __('Color Mode', 'noorgfx-component'),
		'type' => 'ct-radio',
		'view' => 'text',
		'value' => 'simple',
		'design' => $option_design ? 'inline:start' : 'inline',
		'sync' => 'live',
		'setting' => [ 'transport' => 'postMessage' ],
		'choices' => [
			'simple' => __('One Color', 'noorgfx-component'),
			'dual' => __( 'Dual Color', 'noorgfx-component' ),
		]
	],

	'accent_color' => [
		'label' => [
			__('Color', 'noorgfx-component') => [
				'color_type' => 'simple'
			],

			__('Colors', 'noorgfx-component') => [
				'color_type' => 'dual'
			]
		],
		'type' => 'ct-color-picker',
		'design' => $option_design ? 'inline:start' : 'inline',
		'value' => [
			'default' => [
				'color' => 'CT_CSS_SKIP_RULE',
			],

			'secondary' => [
				'color' => 'CT_CSS_SKIP_RULE',
			],
		],
		'pickers' => [
			[
				'title' => [
					__('Color', 'noorgfx-component') => [
						'color_type' => 'simple'
					],

					__('Color 1', 'noorgfx-component') => [
						'color_type' => 'dual'
					]
				],
				'id' => 'default',
			],

			[
				'title' => __('Color 2', 'noorgfx-component'),
				'id' => 'secondary',
				'condition' => [ 'color_type' => 'dual' ]
			],
		]
	],
];

$image_options = [
	'image' => [
		'label' => __('Image', 'noorgfx-component' ),
		'type' => 'ct-image-uploader',
		'design' => $option_design ? 'inline:start' : 'inline',
		'value' => '',
		'emptyLabel' => __('Select Image', 'noorgfx-component'),
	]
];

$button_options = [
	'short_name' => [
		'label' => __('Short Name', 'noorgfx-component'),
		'type' => 'text',
		'design' => $option_design ? 'inline:start' : 'inline',
		'value' => '',
		// 'desc' => __('This will be used as a label for the swatch.', 'noorgfx-component'),
	]
];

$tooltip_options = [
	'tooltip_type' => [
		'label' => __('Tooltip', 'noorgfx-component'),
		'type' => 'ct-radio',
		'view' => 'text',
		'value' => 'default',
		'divider' => $option_design ? 'top:full' : 'top',
		'design' => $option_design ? 'inline:start' : 'inline',
		'sync' => 'live',
		'setting' => [ 'transport' => 'postMessage' ],
		'choices' => [
			'none' => __('None', 'noorgfx-component'),
			'default' => __( 'Text', 'noorgfx-component' ),
			'image' => __( 'Image', 'noorgfx-component' ),
		]
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'tooltip_type' => 'default' ],
		'options' => [
			'tooltip_mask' => [
				'label' => __( 'Tooltip Text', 'noorgfx-component' ),
				'type' => 'text',
				'design' => $option_design ? 'inline:start' : 'inline',
				'value' => __('{term_name}', 'noorgfx-component'),
			],
		]
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'tooltip_type' => 'image' ],
		'options' => [

			'tooltip_image' => [
				'label' => __('Tooltip Image', 'noorgfx-component'),
				'type' => 'ct-image-uploader',
				'design' => $option_design ? 'inline:start' : 'inline',
				'value' => '',
				'emptyLabel' => __('Upload Image', 'noorgfx-component'),
			]

		]
	],
];

$mixed_options = [
	'mixed_subtype' => [
		'label' => __('Subtype', 'noorgfx-component'),
		'type' => 'ct-radio',
		'view' => 'text',
		'design' => $option_design ? 'inline:start' : 'inline',
		'divider' => $option_design ? 'bottom:full' : 'bottom',
		'value' => 'color',
		'choices' => [
			'color' => __('Color', 'noorgfx-component'),
			'image' => __('Image', 'noorgfx-component'),
		]
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'mixed_subtype' => 'color' ],
		'options' => [

			$color_options

		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'mixed_subtype' => 'image' ],
		'options' => [

			$image_options

		],
	],
];

$inherit_options = [
	'message' => [
		'type' => 'ct-notification',
		'text' => sprintf(
			'This attribute is set to inherit the global settings, you can edit it from <a href="%s" target="_blank">%s</a> or change the type and edit it locally.',
			admin_url('term.php?taxonomy={attribute_slug}&post_type=product&tag_ID={tag_id}'),
			__('here', 'noorgfx-component')
		),
	]
];