<?php

$options = [
	'label' => __('Variation Swatches', 'noorgfx-component'),
	'type' => 'ct-panel',
	'setting' => ['transport' => 'postMessage'],
	'inner-options' => [

		noorgfx_rand_md5() => [
			'label' => __( 'Color Swatches', 'noorgfx-component' ),
			'type' => 'ct-panel',
			'panelSecondLevel' => true,
			'setting' => [ 'transport' => 'postMessage' ],
			'inner-options' => [

				noorgfx_rand_md5() => [
					'title' => __( 'General', 'noorgfx-component' ),
					'type' => 'tab',
					'options' => [

						'color_swatch_shape' => [
							'label' => __('Swatch Shape', 'noorgfx-component'),
							'type' => 'ct-radio',
							'value' => 'round',
							'view' => 'text',
							'design' => 'block',
							'choices' => [
								'round' => __('Round', 'noorgfx-component'),
								'square' => __('Square', 'noorgfx-component'),
							],
							'sync' => 'live',
						],

						'single_color_swatch_size' => [
							'label' => __('Single Page Swatch Size', 'noorgfx-component'),
							'type' => 'ct-slider',
							'value' => 30,
							'min' => 10,
							'max' => 100,
							'sync' => 'live',
						],

						'filter_widget_color_swatch_size' => [
							'label' => __('Widget Swatch Size', 'noorgfx-component'),
							'type' => 'ct-slider',
							'value' => 25,
							'min' => 10,
							'max' => 100,
							'sync' => 'live',
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'woo_card_layout:array-ids:product_swatches:enabled' => '!no' ],
							'values_source' => 'global',
							'options' => [

								'archive_color_swatch_size' => [
									'label' => __('Archive Cards Swatch Size', 'noorgfx-component'),
									'type' => 'ct-slider',
									'value' => 25,
									'min' => 10,
									'max' => 100,
									'sync' => 'live',
								],

							],
						],

					],
				],

				noorgfx_rand_md5() => [
					'title' => __( 'Design', 'noorgfx-component' ),
					'type' => 'tab',
					'options' => [

						'color_swatch_border_color' => [
							'label' => __( 'Border Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],

							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => 'rgba(0, 0, 0, 0.2)',
								],

								'active' => [
									'color' => 'rgba(0, 0, 0, 0.2)',
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
									'inherit' => 'var(--theme-border-color)'
								],

								[
									'title' => __( 'Hover', 'noorgfx-component' ),
									'id' => 'hover',
								],

								[
									'title' => __( 'Active', 'noorgfx-component' ),
									'id' => 'active',
								],
							],
						],

					],
				],

			],
		],


		noorgfx_rand_md5() => [
			'label' => __( 'Image Swatches', 'noorgfx-component' ),
			'type' => 'ct-panel',
			'panelSecondLevel' => true,
			'setting' => [ 'transport' => 'postMessage' ],
			'inner-options' => [

				noorgfx_rand_md5() => [
					'title' => __( 'General', 'noorgfx-component' ),
					'type' => 'tab',
					'options' => [

						'image_swatch_shape' => [
							'label' => __('Swatch Shape', 'noorgfx-component'),
							'type' => 'ct-radio',
							'value' => 'round',
							'view' => 'text',
							'design' => 'block',
							'choices' => [
								'round' => __('Round', 'noorgfx-component'),
								'square' => __('Square', 'noorgfx-component'),
							],
							'sync' => 'live',
						],

						'single_image_swatch_size' => [
							'label' => __('Single Page Swatch Size', 'noorgfx-component'),
							'type' => 'ct-slider',
							'value' => 35,
							'min' => 10,
							'max' => 100,
							'sync' => 'live',
						],

						'filter_widget_image_swatch_size' => [
							'label' => __('Widget Swatch Size', 'noorgfx-component'),
							'type' => 'ct-slider',
							'value' => 35,
							'min' => 10,
							'max' => 100,
							'sync' => 'live',
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'woo_card_layout:array-ids:product_swatches:enabled' => '!no' ],
							'values_source' => 'global',
							'options' => [

								'archive_image_swatch_size' => [
									'label' => __('Archive Cards Swatch Size', 'noorgfx-component'),
									'type' => 'ct-slider',
									'value' => 25,
									'min' => 10,
									'max' => 100,
									'sync' => 'live',
								],

							],
						],

					],
				],

				noorgfx_rand_md5() => [
					'title' => __( 'Design', 'noorgfx-component' ),
					'type' => 'tab',
					'options' => [

						'image_swatch_border_color' => [
							'label' => __( 'Border Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],

							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => 'var(--theme-palette-color-1)',
								],

								'active' => [
									'color' => 'var(--theme-palette-color-1)',
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
									'inherit' => 'var(--theme-border-color)'
								],

								[
									'title' => __( 'Hover', 'noorgfx-component' ),
									'id' => 'hover',
								],

								[
									'title' => __( 'Active', 'noorgfx-component' ),
									'id' => 'active',
								],
							],
						],

					],
				],

			],
		],


		noorgfx_rand_md5() => [
			'label' => __( 'Button Swatches', 'noorgfx-component' ),
			'type' => 'ct-panel',
			'panelSecondLevel' => true,
			'setting' => [ 'transport' => 'postMessage' ],
			'inner-options' => [

				noorgfx_rand_md5() => [
					'title' => __( 'General', 'noorgfx-component' ),
					'type' => 'tab',
					'options' => [

						'button_swatch_shape' => [
							'label' => __('Swatch Shape', 'noorgfx-component'),
							'type' => 'ct-radio',
							'value' => 'round',
							'view' => 'text',
							'design' => 'block',
							'choices' => [
								'round' => __('Round', 'noorgfx-component'),
								'square' => __('Square', 'noorgfx-component'),
							],
							'sync' => 'live',
						],

						'single_button_swatch_size' => [
							'label' => __('Single Page Swatch Size', 'noorgfx-component'),
							'type' => 'ct-slider',
							'value' => 35,
							'min' => 10,
							'max' => 100,
							'sync' => 'live',
						],

						'filter_widget_button_swatch_size' => [
							'label' => __('Widget Swatch Size', 'noorgfx-component'),
							'type' => 'ct-slider',
							'value' => 30,
							'min' => 10,
							'max' => 100,
							'sync' => 'live',
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'woo_card_layout:array-ids:product_swatches:enabled' => '!no' ],
							'values_source' => 'global',
							'options' => [

								'archive_button_swatch_size' => [
									'label' => __('Archive Cards Swatch Size', 'noorgfx-component'),
									'type' => 'ct-slider',
									'value' => 25,
									'min' => 10,
									'max' => 100,
									'sync' => 'live',
								],

							],
						],

					],
				],

				noorgfx_rand_md5() => [
					'title' => __( 'Design', 'noorgfx-component' ),
					'type' => 'tab',
					'options' => [

						'button_swatch_text_color' => [
							'label' => __( 'Text Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],

							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'active' => [
									'color' => '#ffffff',
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
									'inherit' => 'var(--theme-text-color)'
								],

								[
									'title' => __( 'Hover', 'noorgfx-component' ),
									'id' => 'hover',
									'inherit' => 'var(--theme-text-color)'
								],

								[
									'title' => __( 'Active', 'noorgfx-component' ),
									'id' => 'active',
								],
							],
						],

						'button_swatch_border_color' => [
							'label' => __( 'Border Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],

							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => 'var(--theme-palette-color-1)',
								],

								'active' => [
									'color' => 'var(--theme-palette-color-1)',
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
									'inherit' => 'var(--theme-border-color)'
								],

								[
									'title' => __( 'Hover', 'noorgfx-component' ),
									'id' => 'hover',
								],

								[
									'title' => __( 'Active', 'noorgfx-component' ),
									'id' => 'active',
								],
							],
						],

						'button_swatch_background_color' => [
							'label' => __( 'Background Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],

							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'active' => [
									'color' => 'var(--theme-palette-color-1)',
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
									'inherit' => 'rgba(0, 0, 0, 0)'
								],

								[
									'title' => __( 'Hover', 'noorgfx-component' ),
									'id' => 'hover',
									'inherit' => 'rgba(0, 0, 0, 0)'
								],

								[
									'title' => __( 'Active', 'noorgfx-component' ),
									'id' => 'active',
								],
							],
						],

					],
				],

			],
		],


		noorgfx_rand_md5() => [
			'label' => __( 'Mixed Swatches', 'noorgfx-component' ),
			'type' => 'ct-panel',
			'panelSecondLevel' => true,
			'setting' => [ 'transport' => 'postMessage' ],
			'inner-options' => [

				noorgfx_rand_md5() => [
					'title' => __( 'General', 'noorgfx-component' ),
					'type' => 'tab',
					'options' => [

						'mixed_swatch_shape' => [
							'label' => __('Swatch Shape', 'noorgfx-component'),
							'type' => 'ct-radio',
							'value' => 'round',
							'view' => 'text',
							'design' => 'block',
							'choices' => [
								'round' => __('Round', 'noorgfx-component'),
								'square' => __('Square', 'noorgfx-component'),
							],
							'sync' => 'live',
						],

						'single_mixed_swatch_size' => [
							'label' => __('Single Page Swatch Size', 'noorgfx-component'),
							'type' => 'ct-slider',
							'value' => 30,
							'min' => 10,
							'max' => 100,
							'sync' => 'live',
						],

						'filter_widget_mixed_swatch_size' => [
							'label' => __('Widget Swatch Size', 'noorgfx-component'),
							'type' => 'ct-slider',
							'value' => 25,
							'min' => 10,
							'max' => 100,
							'sync' => 'live',
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'woo_card_layout:array-ids:product_swatches:enabled' => '!no' ],
							'values_source' => 'global',
							'options' => [

								'archive_mixed_swatch_size' => [
									'label' => __('Archive Cards Swatch Size', 'noorgfx-component'),
									'type' => 'ct-slider',
									'value' => 25,
									'min' => 10,
									'max' => 100,
									'sync' => 'live',
								],

							],
						],

					],
				],

				noorgfx_rand_md5() => [
					'title' => __( 'Design', 'noorgfx-component' ),
					'type' => 'tab',
					'options' => [

						'mixed_swatch_border_color' => [
							'label' => __( 'Border Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],

							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => 'rgba(0, 0, 0, 0.2)',
								],

								'active' => [
									'color' => 'rgba(0, 0, 0, 0.2)',
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
									'inherit' => 'var(--theme-border-color)'
								],

								[
									'title' => __( 'Hover', 'noorgfx-component' ),
									'id' => 'hover',
								],

								[
									'title' => __( 'Active', 'noorgfx-component' ),
									'id' => 'active',
								],
							],
						],

					],
				],

			],
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-divider',
		],

		'limit_number_of_swatches' => [
			'label' => __('Attribute Terms Limit', 'noorgfx-component'),
			'type' => 'ct-panel',
			'panelSecondLevel' => true,
			'switch' => true,
			'value' => 'no',
			'inner-options' => [

				'archive_limit_number_of_swatches_number' => [
					'label' => __('Archive Limit', 'noorgfx-component'),
					'type' => 'ct-number',
					'design' => 'inline',
					'value' => '',
					'min' => 1,
					'max' => 100,
					'desc' => __('Limit the number of swatches shown on archive pages.', 'noorgfx-component'),
				],

				'single_limit_number_of_swatches_number' => [
					'label' => __('Product Page Limit', 'noorgfx-component'),
					'type' => 'ct-number',
					'design' => 'inline',
					'value' => '',
					'min' => 1,
					'max' => 100,
					'divider' => 'top',
					'desc' => __('Limit the number of swatches shown on single product pages.', 'noorgfx-component'),
				],

				'limit_number_of_swatches_more_button' => [
					'label' => __('Expand Button', 'noorgfx-component'),
					'type' => 'ct-switch',
					'value' => 'no',
					'divider' => 'top',
					'desc' => __('Reveal hidden swatches when the limit is exceeded.', 'noorgfx-component'),
				],
			]
		],

		'has_swatches_url' => [
			'type'  => 'ct-switch',
			'label' => __( 'Generate Variation URL', 'noorgfx-component' ),
			'value' => 'no',
			'disableRevertButton' => true,
			'sync' => 'live',
			'divider' => 'top:full',
			// 'desc' => __( 'Generate a sharable url based on the selected attributes.', 'noorgfx-component' ),
			'desc' => __( 'Generate a shareable single product page URL with pre-selected variation attributes.', 'noorgfx-component' ),
		],

		'out_of_stock_swatch_type' => [
			'label' => __('Out of Stock Swatch Type', 'noorgfx-component'),
			'type' => 'ct-radio',
			'value' => 'faded',
			'view' => 'text',
			'design' => 'block',
			'divider' => 'top:full',
			'choices' => [
				'faded' => __('Faded', 'noorgfx-component'),
				'crossed' => __('Crossed', 'noorgfx-component'),
			],
			'sync' => 'live',
		],

	],
];