<?php

$product = wc_get_product($_GET['product_id']);

$behaviour = blc_theme_functions()->noorgfx_get_theme_mod(
	'size_guide_side_panel_position',
	'right'
) . '-side';

if (isset($_GET['size_guide_side_panel_position'])) {
	$behaviour = $_GET['size_guide_side_panel_position'] . '-side';
}

$close_button_type = blc_theme_functions()->noorgfx_get_theme_mod(
	'size_guide_close_button_type',
	'type-1'
);

$panel_attr = [
	'id' => 'ct-size-guide-modal',
	'class' => 'ct-panel',
	'data-behaviour' => $behaviour
];

$panel_heading = noorgfx_html_tag(
	'div',
	[
		'class' => 'ct-panel-actions'
	],
	noorgfx_html_tag(
		'span',
		[
			'class' => 'ct-panel-heading'
		],
		$product->get_title() . ' - ' . __('Size Guide', 'noorgfx-component')
	) .
	noorgfx_html_tag(
		'button',
		[
			'class' => 'ct-toggle-close',
			'data-type' => $close_button_type,
			'aria-label' => __('Close Sizes Modal', 'noorgfx-component'),
		],
		'<svg class="ct-icon" width="12" height="12" viewBox="0 0 15 15">
		<path d="M1 15a1 1 0 01-.71-.29 1 1 0 010-1.41l5.8-5.8-5.8-5.8A1 1 0 011.7.29l5.8 5.8 5.8-5.8a1 1 0 011.41 1.41l-5.8 5.8 5.8 5.8a1 1 0 01-1.41 1.41l-5.8-5.8-5.8 5.8A1 1 0 011 15z"></path>
		</svg>'
	)
);

$panel_content = noorgfx_html_tag(
	'div',
	[
		'class' => 'ct-panel-content',
	],
	noorgfx_html_tag(
		'div',
		[
			'class' => 'ct-panel-content-inner',
		],
		noorgfx_html_tag(
			'div',
			[
				'class' => 'ct-size-guide-content',
			],
			noorgfx_html_tag(
				'div',
				[
					'class' => 'entry-content is-layout-flow',
				],
				$table_html
			)
		)
	)
);

$panel_content = noorgfx_html_tag(
	'div',
	[
		'class' => 'ct-panel-inner',
	],
	$panel_heading . $panel_content
);

echo noorgfx_html_tag('div', $panel_attr, $panel_content);
