<?php

$products = get_posts([
	'numberposts' => -1,
	'post_type' => 'product',
]);

$choices = [];

$choices[] = [
	'key' => 'all',
	'value' => __('All Products', 'noorgfx-component')
];

foreach ($products as $product) {
	$choices[] = [
		'key' => $product->ID,
		'value' => $product->post_title
	];
}

$options = [
	'conditions' => [
		'label' => __('Display Conditions', 'noorgfx-component'),
		'type' => 'noorgfx-display-condition',
		'filter' => 'product_tabs',
		'sectionAttr' => [ 'class' => 'ct-content-blocks-conditions' ],
		'display' => 'modal',
		'modalTitle' => __('Size Guide Display Conditions', 'noorgfx-component'),
		'modalDescription' => __('Choose where you want this size guide to be displayed.', 'noorgfx-component'),
		'value' => [
			[
				'type' => 'include',
				'rule' => 'singulars',
				'payload' => []
			]
		],

		'value' => [],
		'design' => 'block',
		'divider' => 'bottom:full',
	],
];
