<?php
// Options cloned from Swatches: you can change

$options = [
	'label' => __('Size Guides', 'noorgfx-component'),
	'type' => 'ct-panel',
	'setting' => ['transport' => 'postMessage'],
	'inner-options' => [

		noorgfx_rand_md5() => [
			'title' => __( 'General', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				'size_guide_placement' => [
					'label' => __('Size Guide Placement', 'noorgfx-component'),
					'type' => 'ct-radio',
					'value' => 'modal',
					'view' => 'text',
					'design' => 'block',
					'choices' => [
						'modal' => __('Popup', 'noorgfx-component'),
						'panel' => __('Side Panel', 'noorgfx-component'),
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'size_guide_placement' => 'panel' ],
					'options' => [

						'size_guide_side_panel_position' => [
							'label' => __('Reveal From', 'noorgfx-component'),
							'type' => 'ct-radio',
							'value' => 'right',
							'view' => 'text',
							'design' => 'block',
							'choices' => [
								'left' => __( 'Left Side', 'noorgfx-component' ),
								'right' => __( 'Right Side', 'noorgfx-component' ),
							],
						],

						'size_guide_side_panel_width' => [
							'label' => __( 'Panel Width', 'noorgfx-component' ),
							'type' => 'ct-slider',
							'value' => [
								'desktop' => '700px',
								'tablet' => '65vw',
								'mobile' => '90vw',
							],
							'units' => noorgfx_units_config([
								[ 'unit' => 'px', 'min' => 0, 'max' => 1000 ],
							]),
							'responsive' => true,
							'divider' => 'top',
							'setting' => [ 'transport' => 'postMessage' ],
						],

					],
				],
			],
		],

		noorgfx_rand_md5() => [
			'title' => __( 'Design', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				'size_guide_modal_background' => [
					'label' => [
						__('Popup Background', 'noorgfx-component') => [
							'size_guide_placement' => 'modal'
						],

						__('Panel Background', 'noorgfx-component') => [
							'size_guide_placement' => 'panel'
						]
					],
					'type'  => 'ct-background',
					'design' => 'block:right',
					'responsive' => true,
					'divider' => 'top',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => noorgfx_background_default_value([
						'backgroundColor' => [
							'default' => [
								'color' => 'var(--theme-palette-color-8)'
							],
						],
					])
				],

				'size_guide_modal_backdrop' => [
					'label' => [
						__('Popup Backdrop', 'noorgfx-component') => [
							'size_guide_placement' => 'modal'
						],

						__('Panel Backdrop', 'noorgfx-component') => [
							'size_guide_placement' => 'panel'
						]
					],
					'type'  => 'ct-background',
					'design' => 'block:right',
					'responsive' => true,
					'divider' => 'top',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => noorgfx_background_default_value([
						'backgroundColor' => [
							'default' => [
								'color' => 'rgba(18, 21, 25, 0.8)'
							],
						],
					])
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'size_guide_placement' => 'modal' ],
					'options' => [

						'size_guide_modal_shadow' => [
							'label' => __( 'Popup Shadow', 'noorgfx-component' ),
							'type' => 'ct-box-shadow',
							'responsive' => true,
							'divider' => 'top:full',
							'sync' => 'live',
							'value' => noorgfx_box_shadow_value([
								'enable' => true,
								'h_offset' => 0,
								'v_offset' => 50,
								'blur' => 100,
								'spread' => 0,
								'inset' => false,
								'color' => [
									'color' => 'rgba(18, 21, 25, 0.5)',
								],
							])
						],

						'size_guide_modal_radius' => [
							'label' => __( 'Popup Border Radius', 'noorgfx-component' ),
							'type' => 'ct-spacing',
							'divider' => 'top',
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => noorgfx_spacing_value(),
							'inputAttr' => [
								'placeholder' => '7'
							],
							'min' => 0,
							'responsive' => true
						],

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'size_guide_placement' => 'panel' ],
					'options' => [

						'size_guide_panel_shadow' => [
							'label' => __( 'Panel Shadow', 'noorgfx-component' ),
							'type' => 'ct-box-shadow',
							'design' => 'block',
							'responsive' => true,
							'divider' => 'top',
							'value' => noorgfx_box_shadow_value([
								'enable' => true,
								'h_offset' => 0,
								'v_offset' => 0,
								'blur' => 70,
								'spread' => 0,
								'inset' => false,
								'color' => [
									'color' => 'rgba(0, 0, 0, 0.35)',
								],
							])
						],

					],
				],

				'size_guide_close_button_type' => [
					'label' => __('Close Button Type', 'noorgfx-component'),
					'type' => 'ct-select',
					'value' => 'type-1',
					'view' => 'text',
					'design' => 'inline',
					'divider' => 'top:full',
					'setting' => [ 'transport' => 'postMessage' ],
					'choices' => noorgfx_ordered_keys(
						[
							'type-1' => __( 'Simple', 'noorgfx-component' ),
							'type-2' => __( 'Border', 'noorgfx-component' ),
							'type-3' => __( 'Background', 'noorgfx-component' ),
						]
					),
				],

				'size_guide_close_button_icon_size' => [
					'label' => __( 'Icon Size', 'noorgfx-component' ),
					'type' => 'ct-number',
					'design' => 'inline',
					'value' => 12,
					'min' => 5,
					'max' => 50,
					'divider' => 'top',
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'size_guide_close_button_color' => [
					'label' => __( 'Icon Color', 'noorgfx-component' ),
					'type'  => 'ct-color-picker',
					'design' => 'block',
					'divider' => 'top',
					'responsive' => true,
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => [
						'default' => [
							'color' => 'rgba(0, 0, 0, 0.5)',
						],

						'hover' => [
							'color' => 'rgba(0, 0, 0, 0.8)',
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx-component' ),
							'id' => 'default',
						],

						[
							'title' => __( 'Hover', 'noorgfx-component' ),
							'id' => 'hover',
						],
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'size_guide_close_button_type' => 'type-2' ],
					'options' => [

						'size_guide_close_button_border_color' => [
							'label' => __( 'Border Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'block',
							'divider' => 'top',
							'responsive' => true,
							'setting' => [ 'transport' => 'postMessage' ],

							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
									'inherit' => 'rgba(0, 0, 0, 0.5)'
								],

								[
									'title' => __( 'Hover', 'noorgfx-component' ),
									'id' => 'hover',
									'inherit' => 'rgba(0, 0, 0, 0.5)'
								],
							],
						],

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'size_guide_close_button_type' => 'type-3' ],
					'options' => [

						'size_guide_close_button_shape_color' => [
							'label' => __( 'Background Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'block',
							'divider' => 'top',
							'responsive' => true,
							'setting' => [ 'transport' => 'postMessage' ],

							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
									'inherit' => 'rgba(0, 0, 0, 0.5)'
								],

								[
									'title' => __( 'Hover', 'noorgfx-component' ),
									'id' => 'hover',
									'inherit' => 'rgba(0, 0, 0, 0.5)'
								],
							],
						],

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'size_guide_close_button_type' => '!type-1' ],
					'options' => [

						'size_guide_close_button_border_radius' => [
							'label' => __( 'Border Radius', 'noorgfx-component' ),
							'type' => 'ct-number',
							'design' => 'inline',
							'value' => 5,
							'min' => 0,
							'max' => 100,
							'divider' => 'top',
							'setting' => [ 'transport' => 'postMessage' ],
						],

					],
				],

			],
		],

	],
];
