<?php

$options = [
	'woocommerce_related_products_slideshow' => [
		'label' => __('Type', 'noorgfx-component'),
		'type' => 'ct-radio',
		'value' => 'default',
		'view' => 'text',
		'design' => 'block',
		'divider' => 'bottom',
		'choices' => [
			'default' => __('Default', 'noorgfx-component'),
			'slider' => __('Slider', 'noorgfx-component'),
		],
		'sync' => noorgfx_sync_whole_page([
			'prefix' => 'product',
			'loader_selector' => '[class*="post"] .products',
		]),
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [
			'woocommerce_related_products_slideshow' => 'slider',
		],
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-group',
				'label' => __('Columns & Products', 'noorgfx-component'),
				'attr' => ['data-columns' => '2:medium'],
				'responsive' => true,
				'hasGroupRevertButton' => true,
				'options' => [

					'woocommerce_related_products_slideshow_columns' => [
						'label' => false,
						'desc' => __('Number of columns', 'noorgfx-component'),
						'type' => 'ct-number',
						'value' => [
							'desktop' => 4,
							'tablet' => 3,
							'mobile' => 1,
							'__changed' => ['tablet', 'mobile']
						],
						'min' => 1,
						'max' => 6,
						'design' => 'block',
						'attr' => ['data-width' => 'full'],
						'responsive' => true,
						'skipResponsiveControls' => true,
						'sync' => 'live',
					],

					'woocommerce_related_products_slideshow_number_of_items' => [
						'label' => false,
						'desc' => __('Number of products', 'noorgfx-component'),
						'type' => 'ct-number',
						'value' => 6,
						'min' => 1,
						'max' => 50,
						'design' => 'block',
						'attr' => ['data-width' => 'full'],
						'markAsAutoFor' => ['tablet', 'mobile'],
						'sync' => noorgfx_sync_whole_page([
							'prefix' => 'product',
							'loader_selector' => '[class*="post"] .products',
						]),
					],
				],
			],

			'woocommerce_related_products_slideshow_autoplay' => [
				'type' => 'ct-switch',
				'label' => __('Autoplay', 'noorgfx-component'),
				'value' => 'no',
				'divider' => 'top',
				'sync' => noorgfx_sync_whole_page([
					'prefix' => 'product',
					'loader_selector' => '[class*="post"] .products',
				]),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'woocommerce_related_products_slideshow_autoplay' => 'yes',
				],
				'options' => [
					'woocommerce_related_products_slideshow_autoplay_speed' => [
						'label' => __('Delay (Seconds)', 'noorgfx-component'),
						'desc' => __('Specify the amount of time (in seconds) to delay between automatically cycling an item.', 'noorgfx-component'),
						'type' => 'ct-number',
						'value' => 3,
						'min' => 1,
						'max' => 10,
						'design' => 'inline',
						'sync' => noorgfx_sync_whole_page([
							'prefix' => 'product',
							'loader_selector' => '[class*="post"] .products',
						]),
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],
		],
	],
];
