<?php

$woocommerce_related_products_slideshow = blc_theme_functions()->noorgfx_get_theme_mod(
	'woocommerce_related_products_slideshow',
	'default'
);

// related slideshow columns
if ($woocommerce_related_products_slideshow === 'slider') {
	$columns = noorgfx_expand_responsive_value(
		blc_theme_functions()->noorgfx_get_theme_mod(
			'woocommerce_related_products_slideshow_columns',
			[
				'desktop' => 4,
				'tablet' => 3,
				'mobile' => 1,
			]
		)
	);

	$columns_selectors = [
		'desktop' => '',
		'tablet' => '',
		'mobile' => ''
	];

	foreach ($columns_selectors as $device => $selector) {
		$columns_selectors[$device] = noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => noorgfx_mutate_selector([
					'selector' => [':is(.related, .upsells)'],
					'operation' => 'suffix',
					'to_add' => '[data-flexy="no"] [data-products]'
				]),
				'operation' => 'suffix',
				'to_add' => '.flexy-item:nth-child(n + ' . (intval($columns[$device]) + 1) . ')'
			])
		);
	}

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'selector' => $columns_selectors,

		'variableName' => 'height',
		'variableType' => 'property',
		'value' => '1'
	]);

	$columns['desktop'] = 'calc(100% / ' . $columns['desktop'] . ')';
	$columns['tablet'] = 'calc(100% / ' . $columns['tablet'] . ')';
	$columns['mobile'] = 'calc(100% / ' . $columns['mobile'] . ')';

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => '.related [data-products], .upsells [data-products]',
		'variableName' => 'grid-columns-width',
		'value' => $columns,
		'unit' => ''
	]);
}
