<?php

namespace Noorgfx\Extensions\WoocommerceExtra;

$waitlist = ProductWaitlistDb::get_waitlist('', '', true);

if (empty($waitlist)) {
    echo noorgfx_html_tag(
        'div',
        [
            'class' => 'woocommerce-Message woocommerce-Message--info woocommerce-info'
        ],
        noorgfx_html_tag(
            'a',
            [
                'class' => 'woocommerce-Button button',
                'href' => esc_url(apply_filters('woocommerce_return_to_shop_redirect', wc_get_page_permalink('shop')))
            ],
            __('Browse products', 'noorgfx-component')
        ) .
        __("You don't have any products in your waitlist yet.", 'noorgfx-component')
    );

    return;
}

?>

<div class="ct-woocommerce-waitlist-table">
	<table class="shop_table">
		<thead>
			<tr>
                <th colspan="2">
                    <?php _e('Product', 'noorgfx-component') ?>
                </th>

                <th class="waitlist-product-status">
                    <?php _e('Stock Status', 'noorgfx-component') ?>
                </th>

                <th class="waitlist-subscription-status">
                    <?php _e('Confirmed', 'noorgfx-component') ?>
                </th>

                <th class="waitlist-product-actions">
                    <?php _e('Actions', 'noorgfx-component') ?>
                </th>
			</tr>
		</thead>

		<tbody>
            <?php
                foreach ($waitlist as $key => $entry) {
                    echo noorgfx_render_view(
						dirname(__FILE__) . '/table-single-product-row.php',
						[
							'entry' => $entry,
						]
					);
                }
            ?>
        </tbody>

    </table>
</div>
