<?php

$options = [
	'label' => __('Waitlist', 'noorgfx-component'),
	'type' => 'ct-panel',
	'setting' => ['transport' => 'postMessage'],
	'inner-options' => [

		noorgfx_rand_md5() => [
			'title' => __('General', 'noorgfx-component'),
			'type' => 'tab',
			'options' => [

				'waitlist_type' => [
					'label' => __('Form Type', 'noorgfx-component'),
					'type' => 'ct-radio',
					'value' => 'boxed',
					'view' => 'text',
					'design' => 'block',
					'divider' => 'top:full',
					'choices' => [
						'boxed' => __('Boxed', 'noorgfx-component'),
						'simple' => __('Simple', 'noorgfx-component'),
					],
					'sync' => 'live',
				],

				'waitlist_container_max_width' => [
					'label' => __('Form Max Width', 'noorgfx-component'),
					'type' => 'ct-slider',
					'value' => 100,
					'min' => 10,
					'max' => 100,
					'defaultUnit' => '%',
					'responsive' => true,
					'divider' => 'top',
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'waitlist_allow_backorders' => [
					'label' => __('Enable For Backorders', 'noorgfx-component'),
					'desc' => __('Allow users to join the waitlist even if the product is on backorder.', 'noorgfx-component'),
					'type'  => 'ct-switch',
					'value' => 'no',
					'divider' => 'top:full',
					'sync' => [
						noorgfx_sync_whole_page([
							'prefix' => 'product',
							'loader_selector' => '.entry-summary-items'
						]),
					],
				],

				'waitlist_show_users_number' => [
					'label' => __('Show Users Count', 'noorgfx-component'),
					'desc' => __('Display a counter that reflects the current number of users on the waitlist.', 'noorgfx-component'),
					'type'  => 'ct-switch',
					'value' => 'no',
					'divider' => 'top',
					'sync' => [
						noorgfx_sync_whole_page([
							'prefix' => 'product',
							'loader_selector' => '.entry-summary-items'
						]),
					],
				],

				'waitlist_user_visibility' => [
					'label' => __('Logged In Users Only', 'noorgfx-component'),
					'desc' => __('Display the waitlist feature exclusively to users who are logged in.', 'noorgfx-component'),
					'type'  => 'ct-switch',
					'value' => 'no',
					'divider' => 'top',
					'sync' => [
						noorgfx_sync_whole_page([
							'prefix' => 'product',
							'loader_selector' => '.entry-summary-items'
						]),
					],
				],

				'waitlist_user_confirmation' => [
					'label' => __('Subscription Confirmation', 'noorgfx-component'),
					'desc' => __('Specify which users should verify their waitlist subscription through email confirmation.', 'noorgfx-component'),
					'type' => 'ct-checkboxes',
					'design' => 'block',
					'view' => 'text',
					'allow_empty' => true,
					'value' => [
						'logged_in' => true,
						'logged_out' => true,
					],
					'divider' => 'top:full',
					'choices' => noorgfx_ordered_keys([
						'logged_in' => __('Logged In', 'noorgfx-component'),
						'logged_out' => __('Logged Out', 'noorgfx-component'),
					]),
					'sync' => 'live',
				],

				'waitlist_conditions' => [
					'label' => __('Display Conditions', 'noorgfx-component'),
					'type' => 'noorgfx-display-condition',
					'filter' => 'product_waitlist',
					'sectionAttr' => [ 'class' => 'ct-content-blocks-conditions' ],
					'display' => 'modal',
					'modalTitle' => __('Waitlist Form Display Conditions', 'noorgfx-component'),
					'modalDescription' => __('Choose where you want this Waitlist Form to be displayed.', 'noorgfx-component'),
					'value' => [
						[
							'type' => 'include',
							'rule' => 'everywhere',
							'payload' => []
						]
					],
					'design' => 'block',
					'divider' => 'top:full',
				],

			],
		],

		noorgfx_rand_md5() => [
			'title' => __('Design', 'noorgfx-component'),
			'type' => 'tab',
			'options' => [

				'waitlist_title_font' => [
					'type' => 'ct-typography',
					'label' => __('Title Font', 'noorgfx-component'),
					'value' => noorgfx_typography_default_values([
						'size' => '16px',
					]),
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'waitlist_title_color' => [
					'label' => __('Title Color', 'noorgfx-component'),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'divider' => 'bottom',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __('Initial', 'noorgfx-component'),
							'id' => 'default',
							'inherit' => 'var(--theme-heading-5-color, var(--theme-headings-color))'
						],
					],
				],

				'waitlist_message_font' => [
					'type' => 'ct-typography',
					'label' => __('Message Font', 'noorgfx-component'),
					'value' => noorgfx_typography_default_values([
						'size' => '15px',
					]),
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'waitlist_message_color' => [
					'label' => __('Message Color', 'noorgfx-component'),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __('Initial', 'noorgfx-component'),
							'id' => 'default',
							'inherit' => 'var(--theme-text-color)'
						],
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'waitlist_type' => 'boxed' ],
					'options' => [

						'waitlist_form_border' => [
							'label' => __('Container Border', 'noorgfx-component'),
							'type' => 'ct-border',
							'sync' => 'live',
							'design' => 'block',
							'divider' => 'top:full',
							'value' => [
								'width' => 2,
								'style' => 'solid',
								'color' => [
									'color' => 'var(--theme-border-color)',
								],
							],
							'responsive' => true,
						],

						'waitlist_form_background' => [
							'label' => __('Container Background', 'noorgfx-component'),
							'type' => 'ct-background',
							'design' => 'block:right',
							'responsive' => true,
							'divider' => 'top',
							'sync' => 'live',
							'value' => noorgfx_background_default_value([
								'backgroundColor' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],
							])
						],

						'waitlist_form_padding' => [
							'label' => __('Container Padding', 'noorgfx-component'),
							'type' => 'ct-spacing',
							'divider' => 'top',
							'value' => noorgfx_spacing_value(),
							'inputAttr' => [
								'placeholder' => '30'
							],
							'min' => 0,
							'responsive' => true,
							'setting' => [ 'transport' => 'postMessage' ],
						],

						'waitlist_form_border_radius' => [
							'label' => __('Container Border Radius', 'noorgfx-component'),
							'sync' => 'live',
							'type' => 'ct-spacing',
							'divider' => 'top',
							'value' => noorgfx_spacing_value(),
							'inputAttr' => [
								'placeholder' => '7'
							],
							'min' => 0,
							'responsive' => true,
							'setting' => [ 'transport' => 'postMessage' ],
						],

					],
				],

			],
		],
	]
];