<?php

namespace Noorgfx\Extensions\WoocommerceExtra;

class CustomTabs {
	private $post_type = 'ct_product_tab';

	public function __construct() {
		add_action('init', [$this, 'register_post_type']);

		add_filter('noorgfx:frontend:dynamic-js-chunks', function ($chunks) {
			if (!class_exists('WC_AJAX')) {
				return $chunks;
			}

			$matching_tabs = $this->get_matching_tabs();

			if (! $matching_tabs) {
				return $chunks;
			}

			$chunks[] = [
				'id' => 'noorgfx_ext_woo_extra_scroll_to_ct',
				'selector' => '.single-product li[id*="tab-title"][class*="_tab"]',
				'url' => noorgfx_cdn_url(
					NOORGFX_URL .
						'framework/premium/extensions/woocommerce-extra/static/bundle/scroll-to-custom-tab.js'
				),
			];

			return $chunks;
		});

		add_action(
			'wp',
			function () {
				$matching_tabs = $this->get_matching_tabs();

				foreach ($matching_tabs as $tab) {
					$renderer = new \Noorgfx\CustomPostTypeRenderer($tab->ID);
					$renderer->pre_output();
				}
			}
		);

		add_filter(
			'woocommerce_product_tabs',
			[$this, 'custom_product_tab']
		);

		add_filter(
			'noorgfx:editor:post_types_for_rest_field',
			function ($post_types) {
				$post_types[] = $this->post_type;
				return $post_types;
			}
		);

		add_filter('noorgfx:editor:post_meta_options', function ($options, $post_type) {
			if ($post_type !== $this->post_type) {
				return $options;
			}

			global $post;

			$post_id = $post->ID;

			return noorgfx_akg(
				'options',
				blc_theme_functions()->noorgfx_get_variables_from_file(
					dirname(
						__FILE__
					) . '/options.php',
					['options' => []]
				)
			);
		}, 10, 2);

		add_filter('manage_ct_product_tab_posts_columns', function ($columns) {
			$columns['conditions'] = __('Conditions', 'noorgfx-component');

			return $columns;
		});

		add_action(
			'manage_ct_product_tab_posts_custom_column',
			function ($column, $post_id) {
				$atts = noorgfx_get_post_options($post_id);

				if ($column === 'conditions') {
					$conditions = noorgfx_default_akg('conditions', $atts, []);

					$conditions_manager = new \Noorgfx\ConditionsManager();

					echo implode(
						'<br>',
						$conditions_manager->humanize_conditions($conditions)
					);
				}
			}, 10, 2
		);
	}

	public function register_post_type() {
		$actions = [
			'edit_post',
			'read_post',
			'delete_post',
			'edit_posts',
			'edit_others_posts',
			'publish_posts',
			'read_private_posts',
			'read',
			'delete_posts',
			'delete_private_posts',
			'delete_published_posts',
			'delete_others_posts',
			'edit_private_posts',
			'edit_published_posts'
		];

		$capabilities = [];

		foreach ($actions as $action) {
			$capabilities[$action] = blc_get_capabilities()->get_wp_capability_by(
				'custom_post_type',
				[
					'post_type' => $this->post_type,
					'action' => $action
				]
			);
		}

		register_post_type($this->post_type, [
			'labels' => [
				'name' => __('Product Tabs', 'noorgfx-component'),
				'singular_name' => __('Product Tab', 'noorgfx-component'),
				'add_new' => __('Add New', 'noorgfx-component'),
				'add_new_item' => __('Add New Product Tab', 'noorgfx-component'),
				'edit_item' => __('Edit Product Tab', 'noorgfx-component'),
				'new_item' => __('New Product Tab', 'noorgfx-component'),
				'all_items' => __('Product Tabs', 'noorgfx-component'),
				'view_item' => __('View Product Tab', 'noorgfx-component'),
				'search_items' => __('Search Product Tabs', 'noorgfx-component'),
				'not_found' => __('Nothing found', 'noorgfx-component'),
				'not_found_in_trash' => __('Nothing found in Trash', 'noorgfx-component'),
				'parent_item_colon' => '',
			],

			'show_in_admin_bar' => false,
			'public' => true,
			'show_ui' => true,
			'show_in_menu' => 'edit.php?post_type=product',
			'publicly_queryable' => true,
			'can_export' => true,
			'query_var' => true,
			'has_archive' => false,
			'hierarchical' => false,
			'show_in_rest' => true,
			'exclude_from_search' => true,

			'supports' => [
				'title',
				'editor',
				'revisions',
				'custom-fields'
			],

			'capabilities' => $capabilities
		]);
	}

	private function get_matching_tabs() {
		$all_products_tabs = get_posts([
			'numberposts' => -1,
			'post_type' => $this->post_type,
			'suppress_filters' => false,
		]);

		$conditions_manager = new \Noorgfx\ConditionsManager();

		$matching_tabs = [];

		foreach ($all_products_tabs as $tab) {
			$values = noorgfx_get_post_options($tab->ID);

			$conditions = noorgfx_default_akg(
				'conditions',
				$values,
				[]
			);

			if (
				! $conditions_manager->condition_matches(
					$conditions,
					['relation' => 'OR']
				)
			) {
				continue;
			}

			$matching_tabs[] = $tab;
		}

		return $matching_tabs;
	}

	public function custom_product_tab($tabs) {
		global $product;

		foreach ($this->get_matching_tabs() as $tab) {
			$values = noorgfx_get_post_options($tab->ID);
			$order = noorgfx_default_akg('custom_tab_order', $values, 40);

			$tabs[$tab->ID] = array(
				'title' => get_the_title($tab->ID),
				'priority' => $order,
				'callback' => function() use ($tab) {
					$this->custom_product_tab_render($tab->ID);
				}
			);
		}

		return $tabs;
	}

	public function custom_product_tab_render($tab_id) {
		$output = '';

		$tabs_type = blc_theme_functions()->noorgfx_get_theme_mod('woo_tabs_type', 'type-1');

		if ($tabs_type === 'type-4') {
			$output .= noorgfx_html_tag(
				'h2',
				[],
				get_the_title($tab_id)
			);
		}

		$renderer = new \Noorgfx\CustomPostTypeRenderer($tab_id);
		$output .= $renderer->get_content();

		echo $output;
	}
}
