<?php

if (!function_exists('noorgfx_assemble_selector')) {
	return;
}

// Icon size
$icon_size = noorgfx_akg('compare_icon_size', $atts, 15);

if ($icon_size !== 15) {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'variableName' => 'theme-icon-size',
		'value' => $icon_size,
	]);
}

noorgfx_output_font_css([
	'font_value' => noorgfx_akg(
		'compare_label_font',
		$atts,
		noorgfx_typography_default_values([
			'size' => '12px',
			'variation' => 'n6',
			'text-transform' => 'uppercase',
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector(
			[
				'selector' => [$root_selector[0]],
				'operation' => 'suffix',
				'to_add' => '.ct-header-compare .ct-label',
			]
		)
	),
]);

// Margin
noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'important' => true,
	'value' => noorgfx_default_akg(
		'header_compare_margin',
		$atts,
		noorgfx_spacing_value()
	),
]);

// default state
noorgfx_output_colors([
	'value' => noorgfx_akg('header_compare_font_color', $atts),
	'default' => [
		'default' => [
			'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
		],
		'hover' => [
			'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
		],
	],
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'theme-link-initial-color',
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'theme-link-hover-color',
		],
	],
	'responsive' => true,
]);

noorgfx_output_colors([
	'value' => noorgfx_akg('header_compare_icon_color', $atts),
	'default' => [
		'default' => [
			'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
		],
		'hover' => [
			'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
		],
	],
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'theme-icon-color',
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'theme-icon-hover-color',
		],
	],
	'responsive' => true,
]);

noorgfx_output_colors([
	'value' => noorgfx_akg('header_compare_badge_color', $atts),
	'default' => [
		'background' => [
			'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
		],
		'text' => [
			'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
		],
	],
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'variables' => [
		'background' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'theme-cart-badge-background',
		],

		'text' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'theme-cart-badge-text',
		],
	],
	'responsive' => true,
]);

// transparent state
if (isset($has_transparent_header) && $has_transparent_header) {
	noorgfx_output_colors([
		'value' => noorgfx_akg('transparent_header_compare_font_color', $atts),
		'default' => [
			'default' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(
					'DEFAULT'
				),
			],
			'hover' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(
					'DEFAULT'
				),
			],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]',
					])
				),
				'variable' => 'theme-link-initial-color',
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]',
					])
				),
				'variable' => 'theme-link-hover-color',
			],
		],
		'responsive' => true,
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('transparent_header_compare_icon_color', $atts),
		'default' => [
			'default' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(
					'DEFAULT'
				),
			],
			'hover' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(
					'DEFAULT'
				),
			],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]',
					])
				),
				'variable' => 'theme-icon-color',
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]',
					])
				),
				'variable' => 'theme-icon-hover-color',
			],
		],
		'responsive' => true,
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('transparent_header_compare_badge_color', $atts),
		'default' => [
			'background' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(
					'DEFAULT'
				),
			],
			'text' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(
					'DEFAULT'
				),
			],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'background' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]',
					])
				),
				'variable' => 'theme-cart-badge-background',
			],

			'text' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]',
					])
				),
				'variable' => 'theme-cart-badge-text',
			],
		],
		'responsive' => true,
	]);
}

// sticky state
if (isset($has_sticky_header) && $has_sticky_header) {
	noorgfx_output_colors([
		'value' => noorgfx_akg('sticky_header_compare_font_color', $atts),
		'default' => [
			'default' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(
					'DEFAULT'
				),
			],
			'hover' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(
					'DEFAULT'
				),
			],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]',
					])
				),
				'variable' => 'theme-link-initial-color',
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]',
					])
				),
				'variable' => 'theme-link-hover-color',
			],
		],
		'responsive' => true,
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('sticky_header_compare_icon_color', $atts),
		'default' => [
			'default' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(
					'DEFAULT'
				),
			],
			'hover' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(
					'DEFAULT'
				),
			],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]',
					])
				),
				'variable' => 'theme-icon-color',
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]',
					])
				),
				'variable' => 'theme-icon-hover-color',
			],
		],
		'responsive' => true,
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('sticky_header_compare_badge_color', $atts),
		'default' => [
			'background' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(
					'DEFAULT'
				),
			],
			'text' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(
					'DEFAULT'
				),
			],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'background' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]',
					])
				),
				'variable' => 'theme-cart-badge-background',
			],

			'text' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]',
					])
				),
				'variable' => 'theme-cart-badge-text',
			],
		],
		'responsive' => true,
	]);
}
