<?php

$options = [
	'noorgfx_has_image_toggle' => [
		'label' => __( 'Product Image', 'noorgfx-component' ),
		'type' => 'ct-switch',
		'value' => 'no',
		'sync' => noorgfx_sync_whole_page([
			'prefix' => 'single_page',
			'loader_selector' => '.ct-order-review'
		]),
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'noorgfx_has_image_toggle' => 'yes' ],
		'options' => [

			'checkout_image_ratio' => [
				'label' => __('Image Ratio', 'noorgfx-component'),
				'type' => 'ct-ratio',
				'view' => 'inline',
				'value' => '1/1',
				'divider' => 'top',
				'sync' => noorgfx_sync_whole_page([
					'prefix' => 'single_page',
					'loader_selector' => '.ct-order-review'
				]),
			],

			'checkout_image_size' => [
				'label' => __('Image Size', 'noorgfx-component'),
				'type' => 'ct-select',
				'value' => 'woocommerce_thumbnail',
				'view' => 'text',
				'design' => 'inline',
				'divider' => 'top',
				'choices' => noorgfx_ordered_keys(
					noorgfx_get_all_image_sizes()
				),
				'sync' => noorgfx_sync_whole_page([
					'prefix' => 'single_page',
					'loader_selector' => '.ct-order-review'
				]),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],
		],
	],

	'noorgfx_has_quantity_toggle' => [
		'label' => __( 'Quantity Input', 'noorgfx-component' ),
		'type' => 'ct-switch',
		'value' => 'no',
		'divider' => 'bottom:full',
		'sync' => noorgfx_sync_whole_page([
			'prefix' => 'single_page',
			'loader_selector' => '.ct-order-review'
		]),
	],
];
