<?php

$added_to_cart_options =  [];

$mini_cart_options =  noorgfx_get_options(
	dirname(__FILE__) . '/generic.php',
	[
		'prefix' => 'mini_cart_suggested_'
	],
	false
);

$cart_options =  noorgfx_get_options(
	dirname(__FILE__) . '/generic.php',
	[
		'prefix' => 'cart_suggested_'
	],
	false
);

$checkout_options =  noorgfx_get_options(
	dirname(__FILE__) . '/generic.php',
	[
		'prefix' => 'checkout_suggested_'
	],
	false
);

$storage = new \Noorgfx\Extensions\WoocommerceExtra\Storage();
$settings = $storage->get_settings();

if (
	isset($settings['features']['added-to-cart-popup']) &&
	$settings['features']['added-to-cart-popup']
) {
	$added_to_cart_options =  noorgfx_get_options(
		dirname(__FILE__) . '/generic.php',
		[
			'prefix' => 'cart_popup_suggested_'
		],
		false
	);
}

$options = [
	'label' => __('Suggested Products', 'noorgfx-component'),
	'type' => 'ct-panel',
	'setting' => ['transport' => 'postMessage'],
	'inner-options' => [

		! empty($added_to_cart_options) ? [
			'cart_popup_suggested_products' => [
				'label' => __( 'Added to Cart Popup', 'noorgfx-component' ),
				'type' => 'ct-panel',
				'panelSecondLevel' => true,
				'switch' => true,
				'value' => 'yes',
				'inner-options' => $added_to_cart_options,
				'sync' => noorgfx_sync_whole_page([
					'prefix' => 'single_page',
					'loader_selector' => '.ct-suggested-products--cart-popup'
				]),
			]
		] : [],

		'mini_cart_suggested_products' => [
			'label' => __( 'Mini Cart', 'noorgfx-component' ),
			'type' => 'ct-panel',
			'panelSecondLevel' => true,
			'switch' => true,
			'value' => 'yes',
			'inner-options' => $mini_cart_options,
			'sync' => noorgfx_sync_whole_page([
				'prefix' => 'single_page',
				'loader_selector' => '.ct-suggested-products--mini-cart'
			]),
		],

		'cart_suggested_products' => [
			'label' => __( 'Cart Page', 'noorgfx-component' ),
			'type' => 'ct-panel',
			'panelSecondLevel' => true,
			'switch' => true,
			'value' => 'yes',
			'inner-options' => $cart_options,
			'sync' => noorgfx_sync_whole_page([
				'prefix' => 'single_page',
				'loader_selector' => '.ct-suggested-products--cart'
			]),
		],

		'checkout_suggested_products' => [
			'label' => __( 'Checkout Page', 'noorgfx-component' ),
			'type' => 'ct-panel',
			'panelSecondLevel' => true,
			'switch' => true,
			'value' => 'yes',
			'inner-options' => $checkout_options,
			'sync' => noorgfx_sync_whole_page([
				'prefix' => 'single_page',
				'loader_selector' => '.ct-suggested-products--checkout'
			]),
		],
	]
];
