<?php


$options = [
	'label' => __('Advanced Reviews', 'noorgfx-component'),
	'type' => 'ct-panel',
	'setting' => ['transport' => 'postMessage'],
	'inner-options' => [

		'woo_advanced_reviews_order' => [
			'label' => __('Reviews Order', 'noorgfx-component'),
			'type' => 'ct-select',
			'value' => 'old',
			'design' => 'block',
			'setting' => [ 'transport' => 'postMessage' ],
			'choices' => noorgfx_ordered_keys(
				[
					'old' => __('Oldest First', 'noorgfx-component'),
					'new' => __('Newest First', 'noorgfx-component'),
					'rating_low' => __('Low Rating First', 'noorgfx-component'),
					'rating_high' => __('High Rating First', 'noorgfx-component'),
					'most_relevant' => __('Most Relevant', 'noorgfx-component'),
				]
			),
			'sync' => noorgfx_sync_whole_page([
				'prefix' => 'product',
				'loader_selector' => '.woocommerce-Reviews'
			]),
		],

		'woo_advanced_reviews_summary' => [
			'label' => __('Average Score', 'noorgfx-component'),
			'desc' => __('Display an average score for all reviews.', 'noorgfx-component'),
			'type' => 'ct-switch',
			'value' => 'no',
			'divider' => 'top:full',
			'sync' => noorgfx_sync_whole_page([
				'prefix' => 'product',
				'loader_selector' => '.woocommerce-Reviews'
			]),
		],

		'woo_advanced_reviews_title' => [
			'label' => __('Review Title', 'noorgfx-component'),
			'desc' => __('Allow users to add a title when leaving a review.', 'noorgfx-component'),
			'type' => 'ct-switch',
			'value' => 'no',
			'divider' => 'top:full',
			'sync' => noorgfx_sync_whole_page([
				'prefix' => 'product',
				'loader_selector' => '.woocommerce-Reviews'
			]),
		],

		'woo_advanced_reviews_images' => [
			'label' => __('Image Upload', 'noorgfx-component'),
			'desc' => __('Allow users to upload images when leaving a review.', 'noorgfx-component'),
			'type' => 'ct-switch',
			'value' => 'no',
			'divider' => 'top:full',
			'sync' => noorgfx_sync_whole_page([
				'prefix' => 'product',
				'loader_selector' => '.woocommerce-Reviews'
			]),
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [ 'woo_advanced_reviews_images' => 'yes' ],
			'options' => [

				'woo_advanced_reviews_lightbox' => [
					'label' => __('Image Lightbox', 'noorgfx-component'),
					'desc' => __('Allow users to open attached review images in lightbox.', 'noorgfx-component'),
					'type' => 'ct-switch',
					'value' => 'no',
					'divider' => 'top',
					'sync' => noorgfx_sync_whole_page([
						'prefix' => 'product',
						'loader_selector' => '.woocommerce-Reviews'
					]),
				],

			],
		],

		'woo_advanced_reviews_votes' => [
			'label' => __('Review Voting', 'noorgfx-component'),
			'desc' => __('Allow users to upvote reviews.', 'noorgfx-component'),
			'type' => 'ct-switch',
			'value' => 'no',
			'divider' => 'top:full',
			'sync' => noorgfx_sync_whole_page([
				'prefix' => 'product',
				'loader_selector' => '.woocommerce-Reviews'
			]),
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [ 'woo_advanced_reviews_votes' => 'yes' ],
			'options' => [

				'woo_advanced_reviews_votes_allowed_roles' => [
					'label' => __( 'Allowed Users', 'noorgfx-component' ),
					'desc' => __( 'Set which users are allowed to vote.', 'noorgfx-component' ),
					'type' => 'ct-checkboxes',
					'design' => 'block',
					'view' => 'text',
					'divider' => 'top',
					'value' => [
						'logged_in' => true,
						'logged_out' => false,
					],
					'choices' => noorgfx_ordered_keys([
						'logged_in' => __( 'Logged In', 'noorgfx-component' ),
						'logged_out' => __( 'Logged Out', 'noorgfx-component' ),
					]),
					'sync' => noorgfx_sync_whole_page([
						'prefix' => 'product',
						'loader_selector' => '.woocommerce-Reviews'
					]),
				],

			],
		],

	],
];