<?php

$options = [
	'label' => __('Added to Cart Popup', 'noorgfx-component'),
	'type' => 'ct-panel',
	'setting' => ['transport' => 'postMessage'],
	'inner-options' => [

		noorgfx_rand_md5() => [
			'title' => __( 'General', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				'added_to_cart_popup_trigger' => [
					'label' => __( 'Trigger Popup On', 'noorgfx-component' ),
					'type' => 'ct-checkboxes',
					'design' => 'block',
					'view' => 'text',
					'allow_empty' => true,
					'value' => [
						'archive' => true,
						'single' => true,
					],
					'choices' => noorgfx_ordered_keys([
						'archive' => __( 'Archive Page', 'noorgfx-component' ),
						'single' => __( 'Product Page', 'noorgfx-component' ),
					]),
				],

				'added_to_cart_popup_show_image' => [
					'label' => __('Image', 'noorgfx-component'),
					'type' => 'ct-switch',
					'value' => 'yes',
					'view' => 'text',
					'design' => 'inline',
					'divider' => 'top:full',
					'setting' => [ 'transport' => 'postMessage' ],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'added_to_cart_popup_show_image' => 'yes' ],
					'options' => [

						'added_to_cart_popup_image_ratio' => [
							'label' => __('Image Ratio', 'noorgfx-component'),
							'type' => 'ct-ratio',
							'view' => 'inline',
							'value' => '3/4',
							'divider' => 'bottom',
							'sync' => 'live'
						],

						'added_to_cart_popup_image_size' => [
							'label' => __('Image Size', 'noorgfx-component'),
							'type' => 'ct-select',
							'value' => 'medium',
							'view' => 'text',
							'design' => 'block',
							'divider' => 'bottom',
							'choices' => noorgfx_ordered_keys(
								noorgfx_get_all_image_sizes()
							),
							'setting' => [ 'transport' => 'postMessage' ],
						],

						'added_to_cart_popup_image_width' => [
							'label' => __( 'Image Width', 'noorgfx-component' ),
							'type' => 'ct-slider',
							'value' => 20,
							'min' => 10,
							'max' => 50,
							'defaultUnit' => '%',
							'divider' => 'bottom',
							'setting' => [ 'transport' => 'postMessage' ],
						],

					],
				],

				'added_to_cart_popup_show_price' => [
					'label' => __('Price', 'noorgfx-component'),
					'type' => 'ct-switch',
					'value' => 'yes',
					'view' => 'text',
					'design' => 'inline',
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'added_to_cart_popup_show_description' => [
					'label' => __('Description', 'noorgfx-component'),
					'type' => 'ct-switch',
					'value' => 'no',
					'view' => 'text',
					'design' => 'inline',
					'setting' => [ 'transport' => 'postMessage' ],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'added_to_cart_popup_show_description' => 'yes' ],
					'options' => [
						'added_to_cart_popup_description_length' => [
							'label' => __('Description Length', 'noorgfx-component'),
							'type' => 'ct-number',
							'design' => 'inline',
							'value' => 20,
							'min' => 1,
							'max' => 300,
						],
					]
				],

				'added_to_cart_popup_show_cart' => [
					'label' => __('Cart Button', 'noorgfx-component'),
					'type' => 'ct-switch',
					'value' => 'yes',
					'view' => 'text',
					'design' => 'inline',
					'divider' => 'top',
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'added_to_cart_popup_show_checkout' => [
					'label' => __('Checkout Button', 'noorgfx-component'),
					'type' => 'ct-switch',
					'value' => 'no',
					'view' => 'text',
					'design' => 'inline',
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'added_to_cart_popup_show_continue' => [
					'label' => __('Continue Shopping Button', 'noorgfx-component'),
					'type' => 'ct-switch',
					'value' => 'yes',
					'view' => 'text',
					'design' => 'inline',
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'added_to_cart_popup_show_attributes' => [
					'label' => __('Attributes', 'noorgfx-component'),
					'type' => 'ct-switch',
					'value' => 'yes',
					'view' => 'text',
					'design' => 'inline',
					'divider' => 'top',
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'added_to_cart_popup_show_shipping' => [
					'label' => __('Shipping Info', 'noorgfx-component'),
					'type' => 'ct-switch',
					'value' => 'yes',
					'view' => 'text',
					'design' => 'inline',
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'added_to_cart_popup_show_tax' => [
					'label' => __('Tax Info', 'noorgfx-component'),
					'type' => 'ct-switch',
					'value' => 'no',
					'view' => 'text',
					'design' => 'inline',
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'added_to_cart_popup_show_total' => [
					'label' => __('Total Info', 'noorgfx-component'),
					'type' => 'ct-switch',
					'value' => 'yes',
					'view' => 'text',
					'design' => 'inline',
					'setting' => [ 'transport' => 'postMessage' ],
				],
			],
		],

		noorgfx_rand_md5() => [
			'title' => __( 'Design', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				'added_to_cart_popup_title_font' => [
					'type' => 'ct-typography',
					'label' => __( 'Title Font', 'noorgfx-component' ),
					'value' => noorgfx_typography_default_values([
						'size' => '16px',
					]),
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'added_to_cart_popup_title_color' => [
					'label' => __( 'Title Color', 'noorgfx-component' ),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'divider' => 'bottom',
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx-component' ),
							'id' => 'default',
							'inherit' => 'var(--theme-heading-2-color, var(--theme-headings-color))'
						],
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'added_to_cart_popup_show_price' => 'yes' ],
					'options' => [

						'added_to_cart_popup_price_font' => [
							'type' => 'ct-typography',
							'label' => __( 'Price Font', 'noorgfx-component' ),
							'value' => noorgfx_typography_default_values([
								'size' => '15px',
								'variation' => 'n7',
							]),
							'setting' => [ 'transport' => 'postMessage' ],
						],

						'added_to_cart_popup_price_color' => [
							'label' => __( 'Price Color', 'noorgfx-component' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'divider' => 'bottom',
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx-component' ),
									'id' => 'default',
									'inherit' => 'var(--theme-text-color)'
								],
							],
						],

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'added_to_cart_popup_show_image' => 'yes' ],
					'options' => [

						'added_to_cart_popup_image_radius' => [
							'label' => __( 'Image Border Radius', 'noorgfx-component' ),
							'type' => 'ct-spacing',
							'value' => noorgfx_spacing_value(),
							'inputAttr' => [
								'placeholder' => '3'
							],
							'min' => 0,
							'sync' => 'live',
						],

					],
				],

			],
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-title',
			'label' => __( 'Popup Options', 'noorgfx-component' ),
		],

		noorgfx_rand_md5() => [
			'title' => __( 'General', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				'added_to_cart_popup_open_animation' => [
					'label' => __('Popup Animation', 'noorgfx-component' ),
					'type' => 'ct-select',
					'value' => 'slide-right',
					'design' => 'block',
					'divider' => 'top:full',
					'choices' => noorgfx_ordered_keys([
						'fade-in' => __('Fade in fade out', 'noorgfx-component'),
						'zoom-in' => __('Zoom in zoom out', 'noorgfx-component'),
						'slide-left' => __('Slide in from left', 'noorgfx-component'),
						'slide-right' => __('Slide in from right', 'noorgfx-component'),
						'slide-top' => __('Slide in from top', 'noorgfx-component'),
						'slide-bottom' => __('Slide in from bottom', 'noorgfx-component'),
					]),
					'sync' => 'live'
				],

				'added_to_cart_popup_entrance_speed' => [
					'label' => __( 'Animation Speed', 'noorgfx-component' ),
					'type' => 'ct-number',
					'design' => 'inline',
					'value' => 0.2,
					'min' => 0,
					'max' => 10,
					'step' => 0.1,
					'sync' => 'live'
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'added_to_cart_popup_open_animation' => 'slide-left|slide-right|slide-top|slide-bottom',
					],
					'options' => [

						'added_to_cart_popup_entrance_value' => [
							'label' => __( 'Entrance Value', 'noorgfx-component' ),
							'type' => 'ct-number',
							'design' => 'inline',
							'value' => 50,
							'min' => 0,
							'max' => 500,
							'sync' => 'live'
						],

					],
				],

				'added_to_cart_popup_size' => [
					'label' => __('Popup Size', 'noorgfx-component' ),
					'type' => 'ct-select',
					'value' => 'medium',
					'design' => 'block',
					'divider' => 'top:full',
					'sync' => 'live',
					'choices' => noorgfx_ordered_keys([
						'small' => __('Small Size', 'noorgfx-component'),
						'medium' => __('Medium Size', 'noorgfx-component'),
						'large' => __('Large Size', 'noorgfx-component'),
						'custom' => __('Custom Size', 'noorgfx-component'),
					]),
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => ['added_to_cart_popup_size' => 'custom'],
					'options' => [

						'added_to_cart_popup_max_width' => [
							'label' => __( 'Max Width', 'noorgfx-component' ),
							'type' => 'ct-slider',
							'value' => '900px',
							'design' => 'block',
							'units' => [
								[ 'unit' => 'px','min' => 0, 'max' => 1500 ],
								[ 'unit' => 'vw', 'min' => 0, 'max' => 100 ],
								[ 'unit' => 'vh', 'min' => 0, 'max' => 100 ],
								[ 'unit' => 'em', 'min' => 0, 'max' => 100 ],
								[ 'unit' => 'rem', 'min' => 0, 'max' => 100 ],
							],
							'responsive' => true,
							'sync' => 'live'
						],

						'added_to_cart_popup_max_height' => [
							'label' => __( 'Max Height', 'noorgfx-component' ),
							'type' => 'ct-slider',
							'value' => '700px',
							'design' => 'block',
							'units' => [
								[ 'unit' => 'px','min' => 0, 'max' => 1500 ],
								[ 'unit' => 'vw', 'min' => 0, 'max' => 100 ],
								[ 'unit' => 'vh', 'min' => 0, 'max' => 100 ],
								[ 'unit' => 'em', 'min' => 0, 'max' => 100 ],
								[ 'unit' => 'rem', 'min' => 0, 'max' => 100 ],
							],
							'responsive' => true,
							'sync' => 'live'
						],

					]
				],

				'added_to_cart_popup_position' => [
					'label' => __('Popup Position', 'noorgfx-component' ),
					'type' => 'noorgfx-position',
					'value' => 'bottom:right',
					'design' => 'block',
					'sync' => 'live',
					'divider' => 'top',
				],

				'added_to_cart_popup_visibility' => [
					'label' => __('Popup Visibility', 'noorgfx-component'),
					'type' => 'ct-visibility',
					'design' => 'block',
					'divider' => 'top',
					'setting' => ['transport' => 'postMessage'],
					'allow_empty' => true,

					'value' => noorgfx_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => true,
					]),

					'choices' => noorgfx_ordered_keys([
						'desktop' => __( 'Desktop', 'noorgfx-component' ),
						'tablet' => __( 'Tablet', 'noorgfx-component' ),
						'mobile' => __( 'Mobile', 'noorgfx-component' ),
					]),
				],

			],
		],

		noorgfx_rand_md5() => [
			'title' => __( 'Design', 'noorgfx-component' ),
			'type' => 'tab',
			'options' => [

				'added_to_cart_popup_edges_offset' => [
					'label' => __( 'Popup Offset', 'noorgfx-component' ),
					'type' => 'ct-slider',
					'min' => 0,
					'max' => 300,
					'value' => 25,
					'responsive' => true,
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'added_to_cart_popup_padding' => [
					'label' => __( 'Padding', 'noorgfx-component' ),
					'type' => 'ct-spacing',
					'divider' => 'top',
					'value' => noorgfx_spacing_value(),
					'inputAttr' => [
						'placeholder' => '30'
					],
					'responsive' => true,
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'added_to_cart_popup_border_radius' => [
					'label' => __( 'Border Radius', 'noorgfx-component' ),
					'sync' => 'live',
					'type' => 'ct-spacing',
					'divider' => 'top',
					'value' => noorgfx_spacing_value(),
					'inputAttr' => [
						'placeholder' => '7'
					],
					'responsive' => true,
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'added_to_cart_popup_shadow' => [
					'label' => __( 'Shadow', 'noorgfx-component' ),
					'type' => 'ct-box-shadow',
					'divider' => 'top',
					'responsive' => true,
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => noorgfx_box_shadow_value([
						'enable' => true,
						'h_offset' => 0,
						'v_offset' => 10,
						'blur' => 20,
						'spread' => 0,
						'inset' => false,
						'color' => [
							'color' => 'rgba(41, 51, 61, 0.1)',
						],
					])
				],

				'added_to_cart_popup_background' => [
					'label' => __( 'Popup Background', 'noorgfx-component' ),
					'type'  => 'ct-background',
					'design' => 'block:right',
					'divider' => 'top',
					'responsive' => true,
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => noorgfx_background_default_value([
						'backgroundColor' => [
							'default' => [
								'color' => 'var(--theme-palette-color-8)'
							],
						],
					])
				],

				'added_to_cart_popup_backdrop_background' => [
					'label' => __( 'Popup Backdrop', 'noorgfx-component' ),
					'type'  => 'ct-background',
					'design' => 'block:right',
					'divider' => 'top',
					'responsive' => true,
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => noorgfx_background_default_value([
						'backgroundColor' => [
							'default' => [
								'color' => 'rgba(18, 21, 25, 0.5)'
							],
						],
					])
				],

				'added_to_cart_popup_backdrop_background' => [
					'label' => __( 'Popup Backdrop', 'noorgfx-component' ),
					'type'  => 'ct-background',
					'design' => 'block:right',
					'divider' => 'top',
					'responsive' => true,
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => noorgfx_background_default_value([
						'backgroundColor' => [
							'default' => [
								'color' => 'rgba(18, 21, 25, 0.8)'
							],
						],
					])
				],

				'added_to_cart_popup_close_button_icon_size' => [
					'label' => __( 'Close Icon Size', 'noorgfx-component' ),
					'type' => 'ct-number',
					'design' => 'inline',
					'value' => 12,
					'min' => 5,
					'max' => 50,
					'divider' => 'top',
					'setting' => [ 'transport' => 'postMessage' ],
				],

				'added_to_cart_popup_close_button_color' => [
					'label' => __( 'Close Icon Color', 'noorgfx-component' ),
					'type'  => 'ct-color-picker',
					'design' => 'block',
					'divider' => 'top',
					'responsive' => true,
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => [
						'default' => [
							'color' => 'rgba(0, 0, 0, 0.5)',
						],

						'hover' => [
							'color' => 'rgba(0, 0, 0, 0.8)',
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx-component' ),
							'id' => 'default',
						],

						[
							'title' => __( 'Hover', 'noorgfx-component' ),
							'id' => 'hover',
						],
					],
				],

			],
		],

	],
];
