import { __ } from 'ct-i18n'
import { createElement, createRoot } from '@wordpress/element'
import { onDocumentLoaded } from 'noorgfx-options'
import $ from 'jquery'
import SettingsManager from './SettingsManager'

import ctEvents from 'ct-events'

onDocumentLoaded(() => {
	const div = document.createElement('div')
	document.body.appendChild(div)

	const root = createRoot(div)
	root.render(<SettingsManager />)
})

$(document).on('click.ctMegaMenu', '.noorgfx-mega-menu-trigger', (e) => {
	e.preventDefault()

	const el = e.target.closest('.noorgfx-mega-menu-trigger')

	ctEvents.trigger('noorgfx:mega-menu:edit-item-settings', {
		el,

		depth: parseFloat(
			[...e.target.closest('.menu-item').classList]
				.find((c) => c.indexOf('menu-item-depth') > -1)
				.replace('menu-item-depth-', '')
		),

		itemTitle: e.target
			.closest('.menu-item')
			.querySelector('.edit-menu-item-title').value,
		itemId: el.dataset.itemId,
	})
})
