<?php

$options = [
	noorgfx_rand_md5() => [
		'type' => 'tab',
		'title' => __('General', 'noorgfx-component'),
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'menu_item_level' => '1' ],
				'options' => [

					'has_mega_menu' => [
						'type' => 'ct-switch',
						'label' => __('Mega Menu Settings', 'noorgfx-component'),
						'value' => 'no',
						'wrapperAttr' => ['data-label' => 'heading-label'],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => ['has_mega_menu' => 'yes'],
						'options' => [


							'mega_menu_width' => [
								'label' => __( 'Dropdown Width', 'noorgfx-component' ),
								'type' => 'ct-select',
								'value' => 'content',
								'view' => 'text',
								'design' => 'inline',
								'divider' => 'top',
								'choices' => noorgfx_ordered_keys(
									[
										'content' => __( 'Content Width', 'noorgfx-component' ),
										'full_width' => __( 'Full Width', 'noorgfx-component' ),
										'custom' => __( 'Custom Width', 'noorgfx-component' ),
									]
								),
							],

							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => [ 'mega_menu_width' => 'full_width' ],
								'options' => [

									'mega_menu_content_width' => [
										'label' => __( 'Content Width', 'noorgfx-component' ),
										'type' => 'ct-select',
										'value' => 'default',
										'view' => 'text',
										'design' => 'inline',
										'divider' => 'top',
										'choices' => noorgfx_ordered_keys(
											[
												'default' => __( 'Default Width', 'noorgfx-component' ),
												'full_width' => __( 'Full Width', 'noorgfx-component' ),
											]
										),
									],

								],
							],

							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => [ 'mega_menu_width' => 'custom' ],
								'options' => [

									'mega_menu_custom_width' => [
										'label' => __( 'Dropdown Custom Width', 'noorgfx-component' ),
										'type' => 'ct-slider',
										'value' => '400px',
										'units' => noorgfx_units_config([
											[ 'unit' => 'px', 'min' => 0, 'max' => 1500 ],
										]),
										'divider' => 'top',
										'design' => 'inline',
									],

								],
							],

							'mega_menu_columns' => [
								'label' => __( 'Columns', 'noorgfx-component' ),
								'type' => 'ct-radio',
								'value' => '4',
								'view' => 'text',
								'design' => 'inline',
								'allow_empty' => true,
								'divider' => 'top',
								'choices' => [
									'1' => 1,
									'2' => 2,
									'3' => 3,
									'4' => 4,
									'5' => 5,
									'6' => 6,
								],
							],

							// 2 columns
							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => [ 'mega_menu_columns' => '2' ],
								'options' => [

									'2_columns_layout' => [
										'label' => false,
										'type' => 'ct-image-picker',
										'attr' => ['data-ratio' => '2:1'],
										'value' => 'repeat(2, 1fr)',
										'divider' => 'top',
										'design' => 'block',
										'disableRevertButton' => true,
										'wrapperAttr' => [ 'className' => 'full-width' ],
										'setting' => [ 'transport' => 'postMessage' ],
										'choices' => [
											'repeat(2, 1fr)' => [
												'src' => noorgfx_image_picker_file( '1-1' ),
											],

											'2fr 1fr' => [
												'src' => noorgfx_image_picker_file( '2-1' ),
											],

											'1fr 2fr' => [
												'src' => noorgfx_image_picker_file( '1-2' ),
											],

											'3fr 1fr' => [
												'src' => noorgfx_image_picker_file( '3-1' ),
											],

											// '1fr 3fr' => [
											// 	'src' => noorgfx_image_picker_file( '1-3' ),
											// ],
										],
									],

								],
							],

							// 3 columns
							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => [ 'mega_menu_columns' => '3' ],
								'options' => [

									'3_columns_layout' => [
										'label' => false,
										'type' => 'ct-image-picker',
										'attr' => ['data-ratio' => '2:1'],
										'value' => 'repeat(3, 1fr)',
										'divider' => 'top',
										'design' => 'block',
										'disableRevertButton' => true,
										'wrapperAttr' => [ 'className' => 'full-width' ],
										'setting' => ['transport' => 'postMessage'],
										'choices' => [
											'repeat(3, 1fr)' => [
												'src' => noorgfx_image_picker_file( '1-1-1' ),
											],

											'1fr 2fr 1fr' => [
												'src' => noorgfx_image_picker_file( '1-2-1' ),
											],

											'2fr 1fr 1fr' => [
												'src' => noorgfx_image_picker_file( '2-1-1' ),
											],

											'1fr 1fr 2fr' => [
												'src' => noorgfx_image_picker_file( '1-1-2' ),
											],
										],
									],

								],
							],

							// 4 columns
							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => [
									'any' => [
										'mega_menu_columns' => '4',
										'mega_menu_columns:truthy' => 'no'
									]
								],
								'options' => [

									'4_columns_layout' => [
										'label' => false,
										'type' => 'ct-image-picker',
										'attr' => ['data-ratio' => '2:1'],
										'value' => 'repeat(4, 1fr)',
										'divider' => 'top',
										'design' => 'block',
										'disableRevertButton' => true,
										'wrapperAttr' => [ 'className' => 'full-width' ],
										'setting' => [ 'transport' => 'postMessage' ],
										'choices' => [
											'repeat(4, 1fr)' => [
												'src'   => noorgfx_image_picker_file( '1-1-1-1' ),
											],

											'1fr 2fr 2fr 1fr' => [
												'src'   => noorgfx_image_picker_file( '1-2-2-1' ),
											],

											'2fr 1fr 1fr 1fr' => [
												'src'   => noorgfx_image_picker_file( '2-1-1-1' ),
											],

											'1fr 1fr 1fr 2fr' => [
												'src'   => noorgfx_image_picker_file( '1-1-1-2' ),
											],
										],
									],

								],
							],

							// 5 columns
							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => [ 'mega_menu_columns' => '5' ],
								'options' => [

									'5_columns_layout' => [
										'label' => false,
										'type' => 'ct-image-picker',
										'attr' => ['data-ratio' => '2:1'],
										'value' => 'repeat(5, 1fr)',
										'divider' => 'top',
										'design' => 'block',
										'disableRevertButton' => true,
										'wrapperAttr' => [ 'className' => 'full-width' ],
										'setting' => [ 'transport' => 'postMessage' ],
										'choices' => [
											'repeat(5, 1fr)' => [
												'src'   => noorgfx_image_picker_file( '1-1-1-1-1' ),
											],

											'2fr 1fr 1fr 1fr 1fr' => [
												'src'   => noorgfx_image_picker_file( '2-1-1-1-1' ),
											],

											'1fr 1fr 1fr 1fr 2fr' => [
												'src'   => noorgfx_image_picker_file( '1-1-1-1-2' ),
											],

											'1fr 1fr 2fr 1fr 1fr' => [
												'src'   => noorgfx_image_picker_file( '1-1-2-1-1' ),
											],
										],
									],

								],
							],

							// 6 columns
							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => [ 'mega_menu_columns' => '6' ],
								'options' => [

									'6_columns_layout' => [
										'label' => false,
										'type' => 'ct-image-picker',
										'attr' => ['data-ratio' => '2:1'],
										'value' => 'repeat(6, 1fr)',
										'divider' => 'top',
										'design' => 'block',
										'disableRevertButton' => true,
										'wrapperAttr' => [ 'className' => 'full-width' ],
										'setting' => [ 'transport' => 'postMessage' ],
										'choices' => [
											'repeat(6, 1fr)' => [
												'src'   => noorgfx_image_picker_file( '1-1-1-1-1-1' ),
											],

											'2fr 1fr 1fr 1fr 1fr 1fr' => [
												'src'   => noorgfx_image_picker_file( '2-1-1-1-1-1' ),
											],

											'1fr 1fr 1fr 1fr 1fr 2fr' => [
												'src'   => noorgfx_image_picker_file( '1-1-1-1-1-2' ),
											],

											'1fr 1fr 2fr 2fr 1fr 1fr' => [
												'src'   => noorgfx_image_picker_file( '1-1-2-2-1-1' ),
											],
										],
									],

								],
							],

							noorgfx_rand_md5() => [
								'type' => 'ct-divider',
								'attr' => [ 'data-type' => 'full-modal' ],
							],

							'has_ajax_loading' => [
								'type' => 'ct-switch',
								'label' => __('AJAX Content Loading', 'noorgfx-component'),
								'value' => 'no',
								'wrapperAttr' => [ 'data-label' => 'heading-label' ],
								'desc' => __('If you have complex data inside your mega menu you can enable this option in order to load the dropdown content with AJAX and improve the website loading time.', 'noorgfx-component'),
							],
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
						'attr' => [ 'data-type' => 'full-modal' ],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'menu_item_level' => '!1' ],
				'options' => [

					noorgfx_rand_md5() => [
						'type' => 'ct-title',
						'variation' => 'no-border',
						'label' => __( 'Custom Content', 'noorgfx-component' ),
					],

					'mega_menu_content_type' => [
						'label' => __( 'Content Type', 'noorgfx-component' ),
						'type' => 'ct-select',
						'value' => 'default',
						'view' => 'text',
						'design' => 'inline',
						'choices' => noorgfx_ordered_keys(
							[
								'default' => __( 'Default (Menu Item)', 'noorgfx-component' ),
								'text' => __( 'Custom Text', 'noorgfx-component' ),
								'hook' => __( 'Content Block', 'noorgfx-component' ),
							]
						),
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'mega_menu_content_type' => 'text' ],
						'options' => [
							'mega_menu_text' => [
								'label' => false,
								'type' => 'wp-editor',
								'value' => '',
								'disableRevertButton' => true,
								'wrapperAttr' => [ 'className' => 'full-width' ],
								'quicktags' => false,
								'mediaButtons' => false,
								'tinymce' => [
									'toolbar1' => 'bold,italic,link,alignleft,aligncenter,alignright,undo,redo',
								],
							],
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => ['mega_menu_content_type' => 'hook'],
						'options' => empty(blc_get_content_blocks()) ? [

							noorgfx_rand_md5() => [
								'type' => 'html',
								'label' => __('Select Content Block', 'noorgfx-component'),
								'value' => '',
								'design' => 'inline',
								'html' => '<a href="' . admin_url('/edit.php?post_type=ct_content_block') .'" target="_blank" class="button" style="width: 100%; text-align: center;">' . __('Create a new content Block/Hook', 'noorgfx-component') . '</a>',
							],

						] : [
							'mega_menu_hook' => [
								'label' => __('Select Content Block', 'noorgfx-component'),
								'type' => 'ct-select',
								'value' => '',
								'design' => 'inline',
								'search' => true,
								'defaultToFirstItem' => false,
								'placeholder' => __('None'),
								'choices' => noorgfx_ordered_keys(blc_get_content_blocks()),
							],
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'mega_menu_content_type' => 'text|hook' ],
						'options' => [

							'menu_custom_content_visibility' => [
								'label' => __( 'Content Visibility', 'noorgfx-component' ),
								'type' => 'ct-checkboxes',
								'design' => 'inline',
								'view' => 'text',
								'allow_empty' => true,
								'value' => [
									'desktop_visible' => true,
									'mobile_visible' => false,
								],
								'choices' => noorgfx_ordered_keys([
									'desktop_visible' => __( 'Desktop', 'noorgfx-component' ),
									'mobile_visible' => __( 'Mobile', 'noorgfx-component' ),
								]),
							],

						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
						'attr' => [ 'data-type' => 'full-modal' ],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-title',
				'variation' => 'no-border',
				'label' => __( 'Item Label Settings', 'noorgfx-component' ),
			],

			'mega_menu_label' => [
				'type' => 'ct-radio',
				'label' => __( 'Item Label', 'noorgfx-component' ),
				'value' => 'default',
				'view' => 'text',
				'design' => 'inline',
				'conditions' => [
					'heading' => [
						'menu_item_level' => '!1',
						'parentData/has_mega_menu' => 'yes'
					],
				],
				'choices' => [
					'default' => __('Enabled', 'noorgfx-component'),
					'disabled' => __('Disabled', 'noorgfx-component'),
					'heading' => __('Heading', 'noorgfx-component'),
				],
			],

			'has_menu_item_link' => [
				'type' => 'ct-switch',
				'label' => __('Label Link', 'noorgfx-component'),
				'value' => 'yes',
				'divider' => 'top',
			],

			'menu_item_icon' => [
				'type' => 'icon-picker',
				'label' => __('Icon', 'noorgfx-component'),
				'design' => 'inline',
				'divider' => 'top',
				'value' => [
					'icon' => ''
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'menu_item_icon/icon:truthy' => 'yes',
						'menu_item_icon/url:truthy' => 'yes'
					]
				],
				'options' => [

					'menu_item_icon_size' => [
						'label' => __( 'Icon Size', 'noorgfx-component' ),
						'type' => 'ct-slider',
						'design' => 'inline',
						'divider' => 'top',
						'min' => 5,
						'max' => 50,
						'value' => 15,
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'all' => [
						'mega_menu_label' => '!disabled',
						'any' => [
							'menu_item_icon/icon:truthy' => 'yes',
							'menu_item_icon/url:truthy' => 'yes'
						]
					]
				],
				'options' => [

					'menu_item_position' => [
						'type' => 'ct-radio',
						'label' => __( 'Icon Position', 'noorgfx-component' ),
						'value' => 'left',
						'view' => 'text',
						'design' => 'inline',
						'divider' => 'top',

						'choices' => [
							'left' => __( 'Left', 'noorgfx-component' ),
							'right' => __( 'Right', 'noorgfx-component' ),
						],
					],

				],
			],


			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
				'attr' => [ 'data-type' => 'full-modal' ],
			],

			'has_menu_badge' => [
				'type' => 'ct-switch',
				'label' => __('Badge Settings', 'noorgfx-component'),
				'value' => 'no',
				'wrapperAttr' => [ 'data-label' => 'heading-label' ],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'has_menu_badge' => 'yes' ],
				'options' => [

					'menu_badge_text' => [
						'type' => 'text',
						'label' => __('Text', 'noorgfx-component'),
						'design' => 'inline',
						'value' => '',
					],

					'menu_badge_vertical_alignment' => [
						'label' => __( 'Vertical Alignment', 'noorgfx-component' ),
						'type' => 'ct-slider',
						'design' => 'inline',
						'value' => 0,
						'min' => -20,
						'max' => 20,
						'steps' => 'half',
					],

				],
			],

		]
	],

	noorgfx_rand_md5() => [
		'type' => 'tab',
		'title' => __('Design', 'noorgfx-component'),
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'menu_item_level' => '1',
					'has_mega_menu' => 'yes',
				],
				'options' => [

					noorgfx_rand_md5() => [
						'type' => 'ct-title',
						'variation' => 'no-border',
						'label' => __( 'Mega Menu Settings', 'noorgfx-component' ),
					],

					'mega_menu_background' => [
						'label' => __( 'Background', 'noorgfx-component' ),
						'type' => 'ct-background',
						'design' => 'inline',
						'divider' => 'bottom',
						'value' => noorgfx_background_default_value([
							'backgroundColor' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT')
								],
							],
						])
					],

					'menu_items_links' => [
						'label' => __( 'Link Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'divider' => 'bottom',
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'bg_hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Link Initial', 'noorgfx-component' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Link Hover/Active', 'noorgfx-component' ),
								'id' => 'hover',
							],

							[
								'title' => __( 'Background Hover', 'noorgfx-component' ),
								'id' => 'bg_hover',
							],
						],
					],

					'menu_items_heading_font' => [
						'type' => 'ct-typography',
						'label' => __( 'Heading Font', 'noorgfx-component' ),
						'design' => 'inline',
						'value' => noorgfx_typography_default_values([
							'size' => '15px',
							'variation' => 'n7',
						]),
					],

					'menu_items_heading' => [
						'label' => __( 'Heading Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'divider' => 'bottom',
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial Color', 'noorgfx-component' ),
								'id' => 'default',
							],
						],
					],

					'menu_items_text' => [
						'label' => __( 'Text Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'divider' => 'bottom',
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial Color', 'noorgfx-component' ),
								'id' => 'default',
							],
						],
					],

					'mega_menu_items_divider' => [
						'label' => __( 'Items Divider', 'noorgfx-component' ),
						'type' => 'ct-border',
						'design' => 'inline',
						'divider' => 'bottom',
						'value' => [
							'inherit' => true,
							'width' => 1,
							'style' => 'dashed',
							'color' => [
								'color' => 'rgba(255, 255, 255, 0.1)',
							],
						]
					],

					'mega_menu_columns_divider' => [
						'label' => __( 'Columns Divider', 'noorgfx-component' ),
						'type' => 'ct-border',
						'design' => 'inline',
						'divider' => 'bottom',
						'value' => [
							// 'inherit' => true,
							'width' => 1,
							'style' => 'solid',
							'color' => [
								'color' => 'rgba(255, 255, 255, 0.1)',
							],
						]
					],

					'mega_menu_shadow' => [
						'label' => __( 'Dropdown Shadow', 'noorgfx-component' ),
						'type' => 'ct-box-shadow',
						'design' => 'inline',
						'value' => noorgfx_box_shadow_value([
							'inherit' => true,
							'enable' => false,
							'h_offset' => 0,
							'v_offset' => 10,
							'blur' => 20,
							'spread' => 0,
							'inset' => false,
							'color' => [
								'color' => 'rgba(41, 51, 61, 0.1)',
							],
						])
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
						'attr' => [ 'data-type' => 'full-modal' ],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'menu_item_level' => '2' ],
				'options' => [
					noorgfx_rand_md5() => [
						'type' => 'ct-title',
						'variation' => 'no-border',
						'label' => __( 'Column Settings', 'noorgfx-component' ),
					],

					'menu_column_padding' => [
						'label' => __( 'Column Spacing', 'noorgfx-component' ),
						'type' => 'ct-spacing',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],
						'wrapperAttr' => ['class' => 'ct-control ct-option-spacing-wrapper'],
						'value' => noorgfx_spacing_value()
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'parentData/mega_menu_width' => '!full_width' ],
						'options' => [

							'mega_menu_column_background' => [
								'label' => __( 'Column Background', 'noorgfx-component' ),
								'type' => 'ct-background',
								'design' => 'inline',
								'divider' => 'top',
								'value' => noorgfx_background_default_value([
									'backgroundColor' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT')
										],
									],
								])
							],

						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
						'attr' => [ 'data-type' => 'full-modal' ],
					],
				],
			],


			noorgfx_rand_md5() => [
				'type' => 'ct-title',
				'variation' => 'no-border',
				'label' => __( 'Item Label Settings', 'noorgfx-component' ),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'menu_item_level' => '!1',
					'mega_menu_label' => 'heading'
				],
				'options' => [

					'menu_item_heading' => [
						'label' => __( 'Heading Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'divider' => 'bottom',
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial Color', 'noorgfx-component' ),
								'id' => 'default',
							],
						],
					],

				],
			],

			'menu_item_icon_color' => [
				'label' => __( 'Icon Color', 'noorgfx-component' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',

				'value' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'active' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx-component' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Hover', 'noorgfx-component' ),
						'id' => 'hover',
					],

					[
						'title' => __( 'Active', 'noorgfx-component' ),
						'id' => 'active',
						'inherit' => 'self:hover'
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'has_menu_badge' => 'yes' ],
				'options' => [

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
						'attr' => [ 'data-type' => 'full-modal' ],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-title',
						'variation' => 'no-border',
						'label' => __('Badge Settings', 'noorgfx-component'),
					],

					'menu_badge_font_color' => [
						'label' => __( 'Font Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'divider' => 'bottom',

						'value' => [
							'default' => [
								'color' => '#ffffff',
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],
						],
					],

					'menu_badge_background' => [
						'label' => __( 'Background Color', 'noorgfx-component' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',

						'value' => [
							'default' => [
								'color' => 'var(--theme-palette-color-1)',
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx-component' ),
								'id' => 'default',
							],
						],
					],

				],
			],


		]
	]
];

