<?php
/*
Plugin Name: نوبت پلاس
Description: سریع ترین راه حل، آسان ترین و پرکاربردترین افزونه ایجاد نوبت دهی آنلاین 
Version: 2.2.7
Author: RTL-THEME
Author URI: https://www.rtl-theme.com/author/masoud_afkani/products/
*/

require_once plugin_dir_path(__FILE__) . 'settings.php';
require_once plugin_dir_path(__FILE__) . 'includes/providers.php';
require_once plugin_dir_path(__FILE__) . 'includes/init.php';
require_once plugin_dir_path(__FILE__) . 'includes/data.php';
require_once plugin_dir_path(__FILE__) . 'includes/form.php';

function sab_main_page() {
	include plugin_dir_path(__FILE__) . 'changelog.php'; 
}

function sab_enqueue_scripts() {
    $has_shortcode = is_page() && has_shortcode(get_post()->post_content, 'nobat_plus_form');
    if ($has_shortcode) {
        wp_enqueue_style('sab-style', plugin_dir_url(__FILE__) . 'assets/css/sab-style.css');
        wp_enqueue_style('sweetalert2-style', plugin_dir_url(__FILE__) . 'assets/css/sweetalert2.css');
        wp_enqueue_script('sweetalert2-script', plugin_dir_url(__FILE__) . 'assets/js/sweetalert2.js', array('jquery'), null, true);
        wp_localize_script('sab-script', 'sab_ajax_object', array('ajax_url' => admin_url('admin-ajax.php')));
    }
}
add_action('wp_enqueue_scripts', 'sab_enqueue_scripts');

function sab_enqueue_admin_scripts() {
    wp_enqueue_script('sab-popup-js', plugins_url('assets/js/sab-popup.js', __FILE__), array('jquery'), null, true);
    wp_enqueue_style('sab-popup-css', plugins_url('assets/css/sab-popup.css', __FILE__));
}
add_action('admin_enqueue_scripts', 'sab_enqueue_admin_scripts');

function sab_enqueue_admin_styles($hook) {
    if (strpos($hook, 'sab-') !== false) {
        wp_enqueue_style('sab-admin-styles', plugin_dir_url(__FILE__) . 'assets/css/admin-style.css');
        wp_enqueue_script('jquery-ui-sortable');
    }
}
add_action('admin_enqueue_scripts', 'sab_enqueue_admin_styles');

function sab_enqueue_persian_datepicker() {
    wp_enqueue_style('persian-datepicker-css', plugin_dir_url(__FILE__) . 'assets/css/jalalidatepicker.min.css');
    wp_enqueue_script('persian-datepicker-js', plugins_url('assets/js/jalalidatepicker.min.js', __FILE__), array('jquery'), null, true);
}
add_action('admin_enqueue_scripts', 'sab_enqueue_persian_datepicker');

function sab_create_role_on_activation() {
    add_role(
        'nobat_plus_operator',
        'متصدی نوبت پلاس',
        array(
            'read' => true,
            'manage_options' => true 
        )
    );
}
register_activation_hook(__FILE__, 'sab_create_role_on_activation');

function sab_remove_role_on_deactivation() {
    remove_role('nobat_plus_operator');
}
register_deactivation_hook(__FILE__, 'sab_remove_role_on_deactivation');

function sab_fix_menu_access() {
    $role = get_role('nobat_plus_operator');
    if ($role) {
        $role->add_cap('manage_options');
        $role->add_cap('edit_pages');
        $role->add_cap('publish_posts');
    }
}
add_action('init', 'sab_fix_menu_access', 15);

function sab_restrict_admin_menu() {
    $user = wp_get_current_user();
    if (in_array('nobat_plus_operator', (array) $user->roles)) {
        global $menu, $submenu;
        
        $allowed_menus = array(
            'sab-main', 
            'separator1', 
            'index.php', 
        );
        foreach ($menu as $key => $item) {
            if (!in_array($item[2], $allowed_menus)) {
                unset($menu[$key]);
            }
        }
        if (isset($submenu['sab-main'])) {
            $allowed_submenus = array(
                'sab-main', 
                'sab-services',
                'sab-doctors',
                'sab-availability',
                'sab-appointments',
                'sab-email-settings'
            );
            foreach ($submenu['sab-main'] as $key => $sub_item) {
                if (!in_array($sub_item[2], $allowed_submenus)) {
                    unset($submenu['sab-main'][$key]);
                }
            }
        }
    }
}
add_action('admin_menu', 'sab_restrict_admin_menu', 999);

function sab_enable_admin_access() {
    $user = wp_get_current_user();
    if (in_array('nobat_plus_operator', (array) $user->roles)) {
        if (!defined('DONOTCACHEPAGE')) define('DONOTCACHEPAGE', true);
        remove_action('admin_init', 'wp_safe_redirect');
        remove_filter('admin_url', 'wc_admin_redirect');
    }
}
add_action('admin_init', 'sab_enable_admin_access', 1);

function sab_disable_all_woo_redirects() {
    $user = wp_get_current_user();
    if (in_array('nobat_plus_operator', (array) $user->roles)) {
        remove_filter('woocommerce_login_redirect', [WC()->query, 'redirect_to_checkout']);
        remove_filter('woocommerce_registration_redirect', [WC()->query, 'redirect_to_checkout']);
        remove_action('template_redirect', 'wc_redirect_non_admin_users');
        remove_action('admin_init', 'wc_redirect_non_admin_users');
        if (function_exists('wps_hide_login_redirect')) {
            remove_filter('login_redirect', 'wps_hide_login_redirect', 10, 3);
        }
    }
}
add_action('init', 'sab_disable_all_woo_redirects', 999);

function sab_force_admin_access() {
    $user = wp_get_current_user();
    
    if (in_array('nobat_plus_operator', (array) $user->roles)) {
        add_filter('login_redirect', function($redirect_to, $request, $user) {
            return admin_url();
        }, 9999, 3);
        add_filter('site_url', function($url, $path, $scheme, $blog_id) {
            if ($path === 'wp-login.php') {
                $url = admin_url();
            }
            return $url;
        }, 9999, 4);
    }
}
add_action('plugins_loaded', 'sab_force_admin_access');

function sab_final_access_fix() {
    $role = get_role('nobat_plus_operator');
    if ($role) {
        $role->add_cap('view_admin_dashboard');
        $role->add_cap('access_admin_panel');
        $role->remove_cap('edit_others_posts');
        $role->remove_cap('manage_categories');
        $role->add_cap('bypass_wps_hide_login');
    }
    if (class_exists('WPS_Hide_Login')) {
        add_filter('wps_hide_login_admin_only', '__return_false');
    }
}
add_action('admin_init', 'sab_final_access_fix', 9999);