<?php
if (!defined("ABSPATH")) {
    exit();
}

// Services Page
function sab_services_page()
{
    global $wpdb;
    $table_name = $wpdb->prefix . "sab_services";
    if (isset($_POST["add_service"])) {
        $service_name = sanitize_text_field($_POST["service_name"]);
        $service_price = intval($_POST["service_price"]);
        $wpdb->insert($table_name, [
            "name" => $service_name,
            "price" => $service_price,
        ]);
    }
    if (isset($_POST["delete_services"])) {
        $service_ids = isset($_POST["service_ids"])
            ? array_map("intval", $_POST["service_ids"])
            : [];
        if (!empty($service_ids)) {
            $ids_string = implode(",", $service_ids);
            $wpdb->query("DELETE FROM $table_name WHERE id IN ($ids_string)");
        }
    }
    $services = $wpdb->get_results("SELECT * FROM $table_name");
    ?>
    <div class="nobat-page">
        <div class="nobat-head">مدیریت خدمات</div>
        <h2>افزودن خدمات جدید</h2>
        <form class="phone-form" method="post">
            <input class="example-field" type="text" name="service_name" placeholder="مثال: لیزر پوست یا مشاوره حقوقی" required>
            <input class="example-field" type="number" name="service_price" placeholder="قیمت (تومان)" required>			
            <input type="submit" name="add_service" class="save-btn button button-primary" value="افزودن خدمات">
        </form>
        <h2>لیست خدمات</h2>
        <form class="formandtable" method="post">
			<input type="text" id="table-filter" placeholder="جستجو...">
            <table class="nobat-table wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th class="selection-col"><input type="checkbox" id="select-all-services"></th>
                        <th class="id-col">شناسه</th>
                        <th>خدمات</th>
						<th>قیمت</th>
						<th>ویرایش</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($services as $service): ?>
                        <tr>
                            <td><input type="checkbox" name="service_ids[]" value="<?php echo $service->id; ?>"></td>
                            <td><?php echo $service->id; ?></td>
                            <td><?php echo $service->name; ?></td>
							<td><?php echo $service->price; ?></td>
							<td><a href="<?php echo admin_url(
           "admin.php?page=sab-edit-service&service_id=" . $service->id
       ); ?>" class="button">ویرایش</a></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <input type="submit" name="delete_services" class="button-secondary" value="حذف موارد انتخاب شده" onclick="return confirm('آیا از حذف موارد انتخاب شده اطمینان دارید؟');">
        </form>
    </div>
    <script>
    jQuery(document).ready(function($) {
        $('#select-all-services').change(function() {
            $('input[name="service_ids[]"]').prop('checked', this.checked);
        });
    });
	jQuery(document).ready(function($) {
    $('#table-filter').on('keyup', function() {
        var searchTerm = $(this).val().toLowerCase();
        $('tbody tr').each(function() {
            var lineStr = $(this).text().toLowerCase();
            if(lineStr.indexOf(searchTerm) === -1) {
                $(this).hide();
            } else {
                $(this).show();
            }
        });
    });
	});
    </script>
<?php
}

// Edit Service
function sab_edit_service_page()
{
    global $wpdb;
    $table_name = $wpdb->prefix . "sab_services";

    if (!isset($_GET["service_id"]) || empty($_GET["service_id"])) { ?>
        <div class="nobat-page">
            <h1>ویرایش خدمات</h1>
            <div class="notice notice-warning">
                <p>لطفا از دکمه ویرایش جلوی خدماتی که از قبل ایجاد نموده اید اقدام نمایید..</p>
            </div>
            <a href="<?php echo admin_url(
                "admin.php?page=sab-services"
            ); ?>" class="button">بازگشت به لیست خدمات</a>
        </div>
        <?php return;}

    $service_id = intval($_GET["service_id"]);
    $service = $wpdb->get_row(
        $wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $service_id)
    );
    if (!$service) { ?>
        <div class="nobat-page">
            <h1>ویرایش خدمات</h1>
            <div class="notice notice-error">
                <p>خدمات مورد نظر یافت نشد.</p>
            </div>
            <a href="<?php echo admin_url(
                "admin.php?page=sab-services"
            ); ?>" class="button-secondary">بازگشت به لیست خدمات</a>
        </div>
        <?php return;}

    if (isset($_POST["update_service"])) {
        $service_name = sanitize_text_field($_POST["service_name"]);
        $service_price = intval($_POST["service_price"]);
        $wpdb->update(
            $table_name,
            ["name" => $service_name, "price" => $service_price],
            ["id" => $service_id]
        );
        echo '<div class="updated"><p>خدمات با موفقیت به روزرسانی شد.</p></div>';
        echo '<script>window.location.href="' .
            admin_url("admin.php?page=sab-services") .
            '";</script>';
        exit();
    }
    ?>
    <div class="nobat-page">
        <h1>ویرایش خدمات</h1>
        <form method="post">
			<div class="editing-service">
            <label for="service_name">نام خدمات:</label>
            <input type="text" name="service_name" value="<?php echo esc_attr(
                $service->name
            ); ?>" required>
            <br><br>
            <label for="service_price">قیمت (تومان):</label> <!-- افزودن فیلد قیمت -->
            <input type="number" name="service_price" value="<?php echo esc_attr(
                $service->price
            ); ?>" required>
            <br><br>
			</div>
            <input type="submit" name="update_service" class="button button-primary" value="ذخیره">
            <a href="<?php echo admin_url(
                "admin.php?page=sab-services"
            ); ?>" class="button-secondary">بازگشت</a>
        </form>
    </div>
    <?php
}